/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.UnaryOperator;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DataSerializerDeferredRegister
extends MekanismDeferredRegister<EntityDataSerializer<?>> {
    public DataSerializerDeferredRegister(String modid) {
        super(NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, modid);
    }

    public <T extends Enum<T>> MekanismDeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<T>> registerEnum(String name, Class<T> enumClass) {
        return this.register(name, () -> EntityDataSerializer.simpleEnum((Class)enumClass));
    }

    public <T> MekanismDeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<T>> registerSimple(String name, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
        return this.register(name, () -> EntityDataSerializer.simple((FriendlyByteBuf.Writer)writer, (FriendlyByteBuf.Reader)reader));
    }

    @Override
    public <T> MekanismDeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<ResourceKey<T>>> register(String name, ResourceKey<? extends Registry<T>> registryName) {
        return this.registerSimple(name, FriendlyByteBuf::writeResourceKey, buf -> buf.readResourceKey(registryName));
    }

    public <T> MekanismDeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<T>> register(String name, final FriendlyByteBuf.Writer<T> writer, final FriendlyByteBuf.Reader<T> reader, final UnaryOperator<T> copier) {
        return this.register(name, () -> new EntityDataSerializer<T>(){

            public void write(@NotNull FriendlyByteBuf buffer, @NotNull T value) {
                writer.accept((Object)buffer, value);
            }

            @NotNull
            public T read(@NotNull FriendlyByteBuf buffer) {
                return reader.apply((Object)buffer);
            }

            @NotNull
            public T copy(@NotNull T value) {
                return copier.apply(value);
            }
        });
    }
}

