/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.jetbrains.annotations.NotNull;

public class EntityTypeDeferredRegister
extends MekanismDeferredRegister<EntityType<?>> {
    private Map<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> livingEntityAttributes = new HashMap<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>();

    public EntityTypeDeferredRegister(String modid) {
        super(Registries.ENTITY_TYPE, modid);
    }

    public <ENTITY extends LivingEntity> MekanismDeferredHolder<EntityType<?>, EntityType<ENTITY>> register(String name, EntityType.Builder<ENTITY> builder, Supplier<AttributeSupplier.Builder> attributes) {
        MekanismDeferredHolder<EntityType<?>, EntityType<ENTITY>> entityTypeRO = this.register(name, builder);
        this.livingEntityAttributes.put((Supplier<? extends EntityType<? extends LivingEntity>>)((Object)entityTypeRO), attributes);
        return entityTypeRO;
    }

    @Override
    public <ENTITY extends Entity> MekanismDeferredHolder<EntityType<?>, EntityType<ENTITY>> register(String name, EntityType.Builder<ENTITY> builder) {
        return this.register(name, () -> builder.build(name));
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(this::registerEntityAttributes);
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        if (this.livingEntityAttributes == null) {
            Mekanism.logger.error("GlobalEntityTypeAttributes have already been set. This should not happen.");
        } else {
            for (Map.Entry<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> entry : this.livingEntityAttributes.entrySet()) {
                event.put(entry.getKey().get(), entry.getValue().get().build());
            }
            this.livingEntityAttributes = null;
        }
    }
}

