/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.providers.IItemProvider;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.registration.MekanismDeferredHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRegistryObject<ITEM extends Item>
extends MekanismDeferredHolder<Item, ITEM>
implements IItemProvider {
    @Nullable
    private Map<ContainerType<?, ?, ?>, Function<ItemStack, ? extends List<?>>> defaultContainers;
    @Nullable
    private List<Consumer<RegisterCapabilitiesEvent>> containerCapabilities;

    public ItemRegistryObject(ResourceKey<Item> key) {
        super(key);
    }

    @NotNull
    public ITEM asItem() {
        return (ITEM)((Item)this.value());
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachmentOnlyContainer(ContainerType<CONTAINER, ?, ?> containerType, Function<ItemStack, CONTAINER> defaultCreator) {
        return this.addAttachmentOnlyContainers(containerType, defaultCreator.andThen(List::of));
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachmentOnlyContainers(ContainerType<CONTAINER, ?, ?> containerType, Function<ItemStack, List<CONTAINER>> defaultCreators) {
        if (this.defaultContainers == null) {
            this.defaultContainers = new LinkedHashMap();
        }
        if (this.defaultContainers.put(containerType, defaultCreators) != null) {
            throw new IllegalStateException("Duplicate attachments added for container type: " + containerType.getAttachmentName());
        }
        return this;
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachedContainerCapability(ContainerType<CONTAINER, ?, ?> containerType, Function<ItemStack, CONTAINER> defaultCreator, IMekanismConfig ... requiredConfigs) {
        return this.addAttachedContainerCapabilities(containerType, defaultCreator.andThen(List::of), requiredConfigs);
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachedContainerCapabilities(ContainerType<CONTAINER, ?, ?> containerType, Function<ItemStack, List<CONTAINER>> defaultCreators, IMekanismConfig ... requiredConfigs) {
        this.addAttachmentOnlyContainers(containerType, defaultCreators);
        return this.addContainerCapability(containerType, requiredConfigs);
    }

    @ApiStatus.Internal
    private ItemRegistryObject<ITEM> addContainerCapability(ContainerType<?, ?, ?> containerType, IMekanismConfig ... requiredConfigs) {
        if (this.containerCapabilities == null) {
            this.containerCapabilities = new ArrayList<Consumer<RegisterCapabilitiesEvent>>();
        }
        this.containerCapabilities.add(event -> containerType.registerItemCapabilities((RegisterCapabilitiesEvent)event, (Item)this.asItem(), false, requiredConfigs));
        return this;
    }

    @ApiStatus.Internal
    public <TANK extends MergedChemicalTank> ItemRegistryObject<ITEM> addMissingMergedTanks(Supplier<AttachmentType<TANK>> backingAttachment, boolean supportsFluid, boolean exposeCapability) {
        int added = this.addMissingTankType(ContainerType.GAS, exposeCapability, stack -> ((MergedChemicalTank)stack.getData(backingAttachment)).getGasTank());
        added += this.addMissingTankType(ContainerType.INFUSION, exposeCapability, stack -> ((MergedChemicalTank)stack.getData(backingAttachment)).getInfusionTank());
        added += this.addMissingTankType(ContainerType.PIGMENT, exposeCapability, stack -> ((MergedChemicalTank)stack.getData(backingAttachment)).getPigmentTank());
        added += this.addMissingTankType(ContainerType.SLURRY, exposeCapability, stack -> ((MergedChemicalTank)stack.getData(backingAttachment)).getSlurryTank());
        if (supportsFluid) {
            Supplier attachment = backingAttachment;
            added += this.addMissingTankType(ContainerType.FLUID, exposeCapability, stack -> ((MergedTank)stack.getData(attachment)).getFluidTank());
        }
        if (added == 0) {
            throw new IllegalStateException("Unnecessary addMissingMergedTanks call");
        }
        return this;
    }

    private <CONTAINER extends INBTSerializable<CompoundTag>> int addMissingTankType(ContainerType<CONTAINER, ?, ?> containerType, boolean exposeCapability, Function<ItemStack, CONTAINER> defaultCreator) {
        if (this.defaultContainers != null && this.defaultContainers.containsKey(containerType)) {
            return 0;
        }
        this.addAttachmentOnlyContainer(containerType, defaultCreator);
        if (exposeCapability) {
            this.addContainerCapability(containerType, new IMekanismConfig[0]);
        }
        return 1;
    }

    @ApiStatus.Internal
    void registerCapabilities(RegisterCapabilitiesEvent event) {
        ITEM ITEM = this.asItem();
        if (ITEM instanceof ICapabilityAware) {
            ICapabilityAware capabilityAware = (ICapabilityAware)ITEM;
            capabilityAware.attachCapabilities(event);
        }
        if (this.containerCapabilities != null) {
            for (Consumer<RegisterCapabilitiesEvent> consumer : this.containerCapabilities) {
                consumer.accept(event);
            }
            this.containerCapabilities = null;
        }
    }

    @ApiStatus.Internal
    void attachDefaultContainers(IEventBus eventBus) {
        ITEM item = this.asItem();
        if (item instanceof IAttachmentAware) {
            IAttachmentAware attachmentAware = (IAttachmentAware)item;
            attachmentAware.attachAttachments(eventBus);
        }
        if (this.defaultContainers != null) {
            for (Map.Entry<ContainerType<?, ?, ?>, Function<ItemStack, List<?>>> entry : this.defaultContainers.entrySet()) {
                entry.getKey().addDefaultContainers(null, (Item)item, entry.getValue(), new IMekanismConfig[0]);
            }
            this.defaultContainers = null;
        }
    }
}

