/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntSupplier;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.robit.RobitSkin;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.BlockData;
import mekanism.common.attachments.DriveMetadata;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.FormulaAttachment;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.OverflowAware;
import mekanism.common.attachments.PortableQIODashboardInventory;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedFrequencyComponent;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.AttachedChemicalTanks;
import mekanism.common.attachments.containers.AttachedEnergyContainers;
import mekanism.common.attachments.containers.AttachedFluidTanks;
import mekanism.common.attachments.containers.AttachedHeatCapacitors;
import mekanism.common.attachments.containers.AttachedInventorySlots;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.security.OwnerObject;
import mekanism.common.attachments.security.SecurityObject;
import mekanism.common.capabilities.chemical.item.ChemicalTankRateLimitChemicalTank;
import mekanism.common.capabilities.chemical.variable.RateLimitGasTank;
import mekanism.common.capabilities.chemical.variable.RateLimitInfusionTank;
import mekanism.common.capabilities.chemical.variable.RateLimitPigmentTank;
import mekanism.common.capabilities.chemical.variable.RateLimitSlurryTank;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.RateLimitFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.ChemicalCrystallizerInputRecipeCache;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.AttachmentTypeDeferredRegister;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MekanismAttachmentTypes {
    public static final AttachmentTypeDeferredRegister ATTACHMENT_TYPES = new AttachmentTypeDeferredRegister("mekanism");
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Double>> RADIATION = ATTACHMENT_TYPES.register("radiation", () -> AttachmentType.builder(() -> 1.0E-7).serialize(Codec.doubleRange((double)1.0E-7, (double)Double.MAX_VALUE), radiation -> radiation != 1.0E-7).copyHandler((holder, radiation) -> radiation == 1.0E-7 ? null : radiation).comparator(Double::equals).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ModuleContainer>> MODULE_CONTAINER = ATTACHMENT_TYPES.register("module_container", () -> AttachmentType.serializable(ModuleContainer::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(ModuleContainer::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ItemAtomicDisassembler.DisassemblerMode>> DISASSEMBLER_MODE = ATTACHMENT_TYPES.register("disassembler_mode", ItemAtomicDisassembler.DisassemblerMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ItemConfigurator.ConfiguratorMode>> CONFIGURATOR_MODE = ATTACHMENT_TYPES.register("configurator_mode", ItemConfigurator.ConfiguratorMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ItemFlamethrower.FlamethrowerMode>> FLAMETHROWER_MODE = ATTACHMENT_TYPES.register("flamethrower_mode", ItemFlamethrower.FlamethrowerMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ItemFreeRunners.FreeRunnerMode>> FREE_RUNNER_MODE = ATTACHMENT_TYPES.register("free_runner_mode", ItemFreeRunners.FreeRunnerMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<IJetpackItem.JetpackMode>> JETPACK_MODE = ATTACHMENT_TYPES.register("jetpack_mode", IJetpackItem.JetpackMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<IFluidContainerManager.ContainerEditMode>> EDIT_MODE = ATTACHMENT_TYPES.register("edit_mode", IFluidContainerManager.ContainerEditMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<TileEntityChemicalTank.GasMode>> DUMP_MODE = ATTACHMENT_TYPES.register("dump_mode", TileEntityChemicalTank.GasMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<TileEntityChemicalTank.GasMode>> SECONDARY_DUMP_MODE = ATTACHMENT_TYPES.register("secondary_dump_mode", TileEntityChemicalTank.GasMode.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<IRedstoneControl.RedstoneControl>> REDSTONE_CONTROL = ATTACHMENT_TYPES.register("redstone_control", IRedstoneControl.RedstoneControl.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<TileEntityLaserAmplifier.RedstoneOutput>> REDSTONE_OUTPUT = ATTACHMENT_TYPES.register("redstone_output", TileEntityLaserAmplifier.RedstoneOutput.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Optional<EnumColor>>> TRANSPORTER_COLOR = ATTACHMENT_TYPES.register("transporter_color", () -> AttachmentType.builder(Optional::empty).serialize((IAttachmentSerializer)new IAttachmentSerializer<IntTag, Optional<EnumColor>>(){

        @Nullable
        public IntTag write(Optional<EnumColor> value) {
            return value.map(color -> IntTag.valueOf((int)color.ordinal())).orElse(null);
        }

        public Optional<EnumColor> read(IAttachmentHolder holder, IntTag tag) {
            return Optional.of(EnumColor.byIndexStatic(tag.getAsInt()));
        }
    }).copyHandler(AttachmentTypeDeferredRegister.optionalCopier((holder, attachment) -> attachment)).comparator(AttachmentTypeDeferredRegister.optionalComparator(Objects::equals)).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> SCUBA_TANK_MODE = ATTACHMENT_TYPES.registerBoolean("scuba_tank_mode", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> ELECTRIC_BOW_MODE = ATTACHMENT_TYPES.registerBoolean("electric_bow_mode", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> BUCKET_MODE = ATTACHMENT_TYPES.registerBoolean("bucket_mode", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> ROTARY_MODE = ATTACHMENT_TYPES.registerBoolean("rotary_mode", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> AUTO = ATTACHMENT_TYPES.registerBoolean("auto", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> SORTING = ATTACHMENT_TYPES.registerBoolean("sorting", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> EJECT = ATTACHMENT_TYPES.registerBoolean("eject", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> PULL = ATTACHMENT_TYPES.registerBoolean("pull", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> ROUND_ROBIN = ATTACHMENT_TYPES.registerBoolean("round_robin", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> SINGLE_ITEM = ATTACHMENT_TYPES.registerBoolean("single", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> FUZZY = ATTACHMENT_TYPES.registerBoolean("fuzzy", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> SILK_TOUCH = ATTACHMENT_TYPES.registerBoolean("silk_touch", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> INVERSE = ATTACHMENT_TYPES.registerBoolean("inverse", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> INVERSE_REQUIRES_REPLACE = ATTACHMENT_TYPES.registerBoolean("inverse_replace", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> FROM_RECIPE = ATTACHMENT_TYPES.registerBoolean("from_recipe", false);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> INSERT_INTO_FREQUENCY = ATTACHMENT_TYPES.registerBoolean("insert_into_frequency", true);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> RADIUS = ATTACHMENT_TYPES.registerNonNegativeInt("radius", 10);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> MIN_Y = ATTACHMENT_TYPES.registerInt("min_y", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> MAX_Y = ATTACHMENT_TYPES.registerInt("max_y", 60, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> DELAY = ATTACHMENT_TYPES.registerInt("delay", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Long>> LONG_AMOUNT = ATTACHMENT_TYPES.registerNonNegativeLong("long_amount", 0L);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FloatingLong>> MIN_THRESHOLD = ATTACHMENT_TYPES.registerFloatingLong("min_threshold", () -> FloatingLong.ZERO);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FloatingLong>> MAX_THRESHOLD = ATTACHMENT_TYPES.registerFloatingLong("max_threshold", MekanismConfig.storage.laserAmplifier);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<UUID>> PERSONAL_STORAGE_ID = ATTACHMENT_TYPES.registerUUID("storage_id");
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedEnergyContainers>> ENERGY_CONTAINERS = ATTACHMENT_TYPES.registerContainer("energy_containers", () -> ContainerType.ENERGY);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedInventorySlots>> INVENTORY_SLOTS = ATTACHMENT_TYPES.registerContainer("inventory_slots", () -> ContainerType.ITEM);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedFluidTanks>> FLUID_TANKS = ATTACHMENT_TYPES.registerContainer("fluid_tanks", () -> ContainerType.FLUID);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedChemicalTanks.AttachedGasTanks>> GAS_TANKS = ATTACHMENT_TYPES.registerContainer("gas_tanks", () -> ContainerType.GAS);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedChemicalTanks.AttachedInfusionTanks>> INFUSION_TANKS = ATTACHMENT_TYPES.registerContainer("infusion_tanks", () -> ContainerType.INFUSION);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedChemicalTanks.AttachedPigmentTanks>> PIGMENT_TANKS = ATTACHMENT_TYPES.registerContainer("pigment_tanks", () -> ContainerType.PIGMENT);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedChemicalTanks.AttachedSlurryTanks>> SLURRY_TANKS = ATTACHMENT_TYPES.registerContainer("slurry_tanks", () -> ContainerType.SLURRY);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedHeatCapacitors>> HEAT_CAPACITORS = ATTACHMENT_TYPES.registerContainer("heat_capacitors", () -> ContainerType.HEAT);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<OwnerObject.OwnerOnlyObject>> OWNER_ONLY = ATTACHMENT_TYPES.register("owner", () -> AttachmentType.serializable(OwnerObject.OwnerOnlyObject::new).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(OwnerObject::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<SecurityObject>> SECURITY = ATTACHMENT_TYPES.register("security", () -> AttachmentType.serializable(SecurityObject::new).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(SecurityObject::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedEjector>> EJECTOR = ATTACHMENT_TYPES.register("ejector", () -> AttachmentType.serializable(AttachedEjector::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(AttachedEjector::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedSideConfig>> SIDE_CONFIG = ATTACHMENT_TYPES.register("side_config", () -> AttachmentType.serializable(AttachedSideConfig::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(AttachedSideConfig::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Optional<EnumColor>>> COLORABLE = ATTACHMENT_TYPES.registerOptional("colorable", EnumColor.class);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FilterAware>> FILTER_AWARE = ATTACHMENT_TYPES.register("filters", () -> AttachmentType.serializable(FilterAware::new).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(FilterAware::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<OverflowAware>> OVERFLOW_AWARE = ATTACHMENT_TYPES.register("overflow", () -> AttachmentType.serializable(OverflowAware::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(OverflowAware::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<DriveMetadata>> DRIVE_METADATA = ATTACHMENT_TYPES.register("drive_metadata", () -> AttachmentType.serializable(DriveMetadata::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(DriveMetadata::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<BlockData>> BLOCK_DATA = ATTACHMENT_TYPES.register("block_data", () -> AttachmentType.serializable(BlockData::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(BlockData::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Component>> ROBIT_NAME = ATTACHMENT_TYPES.registerComponent("robit_name", MekanismLang.ROBIT::translate);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ResourceKey<RobitSkin>>> ROBIT_SKIN = ATTACHMENT_TYPES.registerResourceKey("robit_skin", MekanismAPI.ROBIT_SKIN_REGISTRY_NAME, () -> MekanismRobitSkins.BASE);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<CompoundTag>> CONFIGURATION_DATA = ATTACHMENT_TYPES.register("configuration_data", () -> AttachmentType.builder(CompoundTag::new).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, CompoundTag>(){

        @Nullable
        public CompoundTag write(CompoundTag tag) {
            return tag.isEmpty() ? null : tag;
        }

        public CompoundTag read(IAttachmentHolder holder, CompoundTag tag) {
            return tag;
        }
    }).copyHandler((holder, attachment) -> attachment.isEmpty() ? null : attachment.copy()).comparator(CompoundTag::equals).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Item>> REPLACE_STACK = ATTACHMENT_TYPES.register("replace_stack", () -> AttachmentType.builder(() -> Items.AIR).serialize((IAttachmentSerializer)new IAttachmentSerializer<StringTag, Item>(){

        @Nullable
        public StringTag write(Item item) {
            if (item == Items.AIR) {
                return null;
            }
            return StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey((Object)item).toString());
        }

        public Item read(IAttachmentHolder holder, StringTag tag) {
            ResourceLocation registryName = ResourceLocation.tryParse((String)tag.getAsString());
            if (registryName == null) {
                return Items.AIR;
            }
            return (Item)BuiltInRegistries.ITEM.get(registryName);
        }
    }).copyHandler((holder, item) -> item == Items.AIR ? null : item).comparator(Objects::equals).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ItemStack>> ITEM_TARGET = ATTACHMENT_TYPES.register("item_target", () -> AttachmentType.builder(() -> ItemStack.EMPTY).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, ItemStack>(){

        @Nullable
        public CompoundTag write(ItemStack stack) {
            if (stack.isEmpty()) {
                return null;
            }
            CompoundTag nbt = new CompoundTag();
            stack.save(nbt);
            return nbt;
        }

        public ItemStack read(IAttachmentHolder holder, CompoundTag tag) {
            return ItemStack.of((CompoundTag)tag);
        }
    }).copyHandler((holder, stack) -> stack.isEmpty() ? null : stack.copy()).comparator(ItemStack::matches).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<boolean[]>> STABILIZER_CHUNKS = ATTACHMENT_TYPES.register("stabilzer_chunks", () -> AttachmentType.builder(() -> new boolean[25]).serialize((IAttachmentSerializer)new IAttachmentSerializer<ByteArrayTag, boolean[]>(){

        @Nullable
        public ByteArrayTag write(boolean[] value) {
            boolean hasValue = false;
            byte[] bytes = new byte[value.length];
            for (int i = 0; i < value.length; ++i) {
                if (value[i]) {
                    bytes[i] = 1;
                    hasValue = true;
                    continue;
                }
                bytes[i] = 0;
            }
            return hasValue ? new ByteArrayTag(bytes) : null;
        }

        public boolean[] read(IAttachmentHolder holder, ByteArrayTag tag) {
            boolean[] chunksToLoad = new boolean[25];
            byte[] bytes = tag.getAsByteArray();
            if (bytes.length == chunksToLoad.length) {
                for (int i = 0; i < chunksToLoad.length; ++i) {
                    chunksToLoad[i] = bytes[i] == 1;
                }
            }
            return chunksToLoad;
        }
    }).copyHandler((holder, attachment) -> Arrays.copyOf(attachment, ((boolean[])attachment).length)).comparator(Objects::equals).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FrequencyAware<?>>> FREQUENCY_AWARE = ATTACHMENT_TYPES.registerFrequencyAware("frequency_aware", FrequencyAware::create);
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<AttachedFrequencyComponent>> FREQUENCY_COMPONENT = ATTACHMENT_TYPES.register("frequencies", () -> AttachmentType.serializable(AttachedFrequencyComponent::new).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(AttachedFrequencyComponent::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<UpgradeAware>> UPGRADES = ATTACHMENT_TYPES.register("upgrades", () -> AttachmentType.serializable(UpgradeAware::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(UpgradeAware::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FormulaAttachment>> FORMULA_HOLDER = ATTACHMENT_TYPES.register("formula", () -> AttachmentType.serializable(FormulaAttachment::create).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(FormulaAttachment::isCompatible).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<PortableQIODashboardInventory>> QIO_DASHBOARD = ATTACHMENT_TYPES.register("qio_dashboard", () -> AttachmentType.builder(PortableQIODashboardInventory::create).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<MergedChemicalTank>> CHEMICAL_TANK_CONTENTS_HANDLER = ATTACHMENT_TYPES.register("chemical_tank_contents_handler", () -> AttachmentType.builder(holder -> {
        Item patt26056$temp;
        ItemStack stack;
        if (holder instanceof ItemStack && !(stack = (ItemStack)holder).isEmpty() && (patt26056$temp = stack.getItem()) instanceof ItemBlockChemicalTank) {
            ItemBlockChemicalTank tank = (ItemBlockChemicalTank)patt26056$temp;
            ChemicalTankTier tier = Objects.requireNonNull(tank.getTier(), "Chemical tank tier cannot be null");
            return MergedChemicalTank.create(new ChemicalTankRateLimitChemicalTank.GasTankRateLimitChemicalTank(tier, null), new ChemicalTankRateLimitChemicalTank.InfusionTankRateLimitChemicalTank(tier, null), new ChemicalTankRateLimitChemicalTank.PigmentTankRateLimitChemicalTank(tier, null), new ChemicalTankRateLimitChemicalTank.SlurryTankRateLimitChemicalTank(tier, null));
        }
        throw new IllegalArgumentException("Attempted to attach a CHEMICAL_TANK_CONTENTS_HANDLER to an object other than a chemical tank.");
    }).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<MergedTank>> GAUGE_DROPPER_CONTENTS_HANDLER = ATTACHMENT_TYPES.register("gauge_dropper_contents_handler", () -> AttachmentType.builder(holder -> {
        ItemStack stack;
        if (holder instanceof ItemStack && (stack = (ItemStack)holder).is(MekanismItems.GAUGE_DROPPER)) {
            return MergedTank.create(RateLimitFluidTank.create((IntSupplier)MekanismConfig.gear.gaugeDroppedTransferRate, MekanismConfig.gear.gaugeDropperCapacity, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue), RateLimitGasTank.create(MekanismConfig.gear.gaugeDroppedTransferRate, MekanismConfig.gear.gaugeDropperCapacity, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue), RateLimitInfusionTank.create(MekanismConfig.gear.gaugeDroppedTransferRate, MekanismConfig.gear.gaugeDropperCapacity, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrue), RateLimitPigmentTank.create(MekanismConfig.gear.gaugeDroppedTransferRate, MekanismConfig.gear.gaugeDropperCapacity, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrue), RateLimitSlurryTank.create(MekanismConfig.gear.gaugeDroppedTransferRate, MekanismConfig.gear.gaugeDropperCapacity, ChemicalTankBuilder.SLURRY.alwaysTrueBi, ChemicalTankBuilder.SLURRY.alwaysTrueBi, ChemicalTankBuilder.SLURRY.alwaysTrue));
        }
        throw new IllegalArgumentException("Attempted to attach a GAUGE_DROPPER_CONTENTS_HANDLER to an object other than a gauge dropper.");
    }).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<MergedChemicalTank>> CDC_CONTENTS_HANDLER = ATTACHMENT_TYPES.register("cdc_contents_handler", () -> AttachmentType.builder(holder -> {
        ItemStack stack;
        if (holder instanceof ItemStack && (stack = (ItemStack)holder).is(MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER.asItem())) {
            return MergedChemicalTank.create(RateLimitGasTank.createBasicItem(10000L, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue), RateLimitInfusionTank.createBasicItem(10000L, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrue), RateLimitPigmentTank.createBasicItem(10000L, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrue), RateLimitSlurryTank.createBasicItem(10000L, ChemicalTankBuilder.SLURRY.alwaysTrueBi, ChemicalTankBuilder.SLURRY.alwaysTrueBi, ChemicalTankBuilder.SLURRY.alwaysTrue));
        }
        throw new IllegalArgumentException("Attempted to attach a CDC_CONTENTS_HANDLER to an object other than a chemical dissolution chamber.");
    }).build());
    public static final MekanismDeferredHolder<AttachmentType<?>, AttachmentType<MergedChemicalTank>> CRYSTALLIZER_CONTENTS_HANDLER = ATTACHMENT_TYPES.register("crystallizer_contents_handler", () -> AttachmentType.builder(holder -> {
        ItemStack stack;
        if (holder instanceof ItemStack && (stack = (ItemStack)holder).is(MekanismBlocks.CHEMICAL_CRYSTALLIZER.asItem())) {
            return MergedChemicalTank.create(RateLimitGasTank.createBasicItem(10000L, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> ((ChemicalCrystallizerInputRecipeCache)MekanismRecipeType.CRYSTALLIZING.getInputCache()).containsInput(null, gas)), RateLimitInfusionTank.createBasicItem(10000L, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrueBi, infuseType -> ((ChemicalCrystallizerInputRecipeCache)MekanismRecipeType.CRYSTALLIZING.getInputCache()).containsInput(null, infuseType)), RateLimitPigmentTank.createBasicItem(10000L, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, pigment -> ((ChemicalCrystallizerInputRecipeCache)MekanismRecipeType.CRYSTALLIZING.getInputCache()).containsInput(null, pigment)), RateLimitSlurryTank.createBasicItem(10000L, ChemicalTankBuilder.SLURRY.alwaysTrueBi, ChemicalTankBuilder.SLURRY.alwaysTrueBi, slurry -> ((ChemicalCrystallizerInputRecipeCache)MekanismRecipeType.CRYSTALLIZING.getInputCache()).containsInput(null, slurry)));
        }
        throw new IllegalArgumentException("Attempted to attach a CRYSTALLIZER_CONTENTS_HANDLER to an object other than a chemical crystallizer.");
    }).build());

    private MekanismAttachmentTypes() {
    }
}

