/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.Mekanism;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MekanismDamageTypes {
    private static final Map<ResourceLocation, MekanismDamageType> INTERNAL_DAMAGE_TYPES = new HashMap<ResourceLocation, MekanismDamageType>();
    public static final Codec<MekanismDamageType> CODEC = ResourceLocation.CODEC.flatXmap(rl -> {
        MekanismDamageType damageType = INTERNAL_DAMAGE_TYPES.get(rl);
        return damageType == null ? DataResult.error(() -> "Expected " + rl + " to represent a Mekanism damage type") : DataResult.success((Object)damageType);
    }, damageType -> DataResult.success((Object)damageType.registryName()));
    public static final MekanismDamageType LASER = new MekanismDamageType("laser", 0.1f);
    public static final MekanismDamageType RADIATION = new MekanismDamageType("radiation");

    public static Collection<MekanismDamageType> damageTypes() {
        return Collections.unmodifiableCollection(INTERNAL_DAMAGE_TYPES.values());
    }

    public record MekanismDamageType(ResourceKey<DamageType> key, float exhaustion) implements IHasTranslationKey
    {
        public MekanismDamageType(ResourceKey<DamageType> key, float exhaustion) {
            INTERNAL_DAMAGE_TYPES.put(key.location(), this);
            this.key = key;
            this.exhaustion = exhaustion;
        }

        private MekanismDamageType(String name) {
            this(name, 0.0f);
        }

        private MekanismDamageType(String name, float exhaustion) {
            this((ResourceKey<DamageType>)ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Mekanism.rl(name)), exhaustion);
        }

        public String getMsgId() {
            return this.registryName().getNamespace() + "." + this.registryName().getPath();
        }

        public ResourceLocation registryName() {
            return this.key.location();
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "death.attack." + this.getMsgId();
        }

        public DamageSource source(Level level) {
            return this.source(level.registryAccess());
        }

        public DamageSource source(RegistryAccess registryAccess) {
            return new DamageSource((Holder)registryAccess.registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(this.key()));
        }
    }
}

