/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.robit.AdvancementBasedRobitSkin;
import mekanism.api.robit.RobitSkin;
import mekanism.api.robit.RobitSkinSerializationHelper;
import mekanism.common.entity.RobitPrideSkinData;
import mekanism.common.registration.DatapackDeferredRegister;
import mekanism.common.registration.DeferredCodecHolder;
import mekanism.common.util.EnumUtils;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;

public class MekanismRobitSkins {
    private static final DatapackDeferredRegister<RobitSkin> ROBIT_SKINS = DatapackDeferredRegister.robitSkins("mekanism");
    public static final DeferredCodecHolder<RobitSkin, RobitSkin> BASIC_SERIALIZER = ROBIT_SKINS.registerCodec("basic", () -> RobitSkinSerializationHelper.NETWORK_CODEC);
    public static final DeferredCodecHolder<RobitSkin, AdvancementBasedRobitSkin> ADVANCEMENT_BASED_SERIALIZER = ROBIT_SKINS.registerCodec("advancement_based", () -> RobitSkinSerializationHelper.ADVANCEMENT_BASED_ROBIT_SKIN_CODEC);
    public static final ResourceKey<RobitSkin> BASE = ROBIT_SKINS.dataKey("robit");
    public static final ResourceKey<RobitSkin> ALLAY = ROBIT_SKINS.dataKey("allay");
    public static final Map<RobitPrideSkinData, ResourceKey<RobitSkin>> PRIDE_SKINS = (Map)Util.make(() -> {
        EnumMap<RobitPrideSkinData, ResourceKey<RobitSkin>> internal = new EnumMap<RobitPrideSkinData, ResourceKey<RobitSkin>>(RobitPrideSkinData.class);
        for (RobitPrideSkinData data : EnumUtils.PRIDE_SKINS) {
            internal.put(data, ROBIT_SKINS.dataKey(data.lowerCaseName()));
        }
        return Collections.unmodifiableMap(internal);
    });

    private MekanismRobitSkins() {
    }

    public static void createAndRegisterDatapack(IEventBus modEventBus) {
        ROBIT_SKINS.createAndRegisterDatapack(modEventBus, RobitSkinSerializationHelper.DIRECT_CODEC, RobitSkinSerializationHelper.NETWORK_CODEC);
    }

    public static SkinLookup lookup(RegistryAccess registryAccess, ResourceKey<RobitSkin> key) {
        Registry robitSkins = registryAccess.registryOrThrow(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
        RobitSkin skin = (RobitSkin)robitSkins.get(key);
        if (skin == null) {
            return new SkinLookup(BASE, (RobitSkin)robitSkins.getOrThrow(BASE));
        }
        return new SkinLookup(key, skin);
    }

    public record SkinLookup(ResourceKey<RobitSkin> name, RobitSkin skin) {
        public ResourceLocation location() {
            return this.name.location();
        }
    }
}

