/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBoundingBlock
extends TileEntityUpdateable
implements IUpgradeTile,
Nameable {
    private BlockPos mainPos = BlockPos.ZERO;
    private boolean receivedCoords;
    private int currentRedstoneLevel;

    public TileEntityBoundingBlock(BlockPos pos, BlockState state) {
        super(MekanismTileEntityTypes.BOUNDING_BLOCK, pos, state);
    }

    public void setMainLocation(BlockPos pos) {
        boolean bl = this.receivedCoords = pos != null;
        if (!this.isRemote()) {
            this.mainPos = pos;
            this.sendUpdatePacket();
        }
    }

    public boolean hasReceivedCoords() {
        return this.receivedCoords;
    }

    public BlockPos getMainPos() {
        if (this.mainPos == null) {
            this.mainPos = BlockPos.ZERO;
        }
        return this.mainPos;
    }

    @Nullable
    public BlockEntity getMainTile() {
        return this.receivedCoords ? WorldUtils.getTileEntity((BlockGetter)this.level, this.getMainPos()) : null;
    }

    @Nullable
    private IBoundingBlock getMain() {
        BlockEntity tile = this.getMainTile();
        if (tile != null && !(tile instanceof IBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IBoundingBlock, at {}. Multiblock cannot function", (Object)tile, (Object)this.getMainPos());
            return null;
        }
        return (IBoundingBlock)tile;
    }

    public boolean triggerEvent(int id, int param) {
        boolean handled = super.triggerEvent(id, param);
        IBoundingBlock main = this.getMain();
        return main != null && main.triggerBoundingEvent((Vec3i)this.worldPosition.subtract((Vec3i)this.getMainPos()), id, param) || handled;
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        int power;
        if (!this.isRemote() && this.currentRedstoneLevel != (power = this.level.getBestNeighborSignal(this.getBlockPos()))) {
            IBoundingBlock main = this.getMain();
            if (main != null) {
                main.onBoundingBlockPowerChange(this.worldPosition, this.currentRedstoneLevel, power);
            }
            this.currentRedstoneLevel = power;
        }
    }

    public int getComparatorSignal() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsComparator()) {
            return main.getBoundingComparatorSignal((Vec3i)this.worldPosition.subtract((Vec3i)this.getMainPos()));
        }
        return 0;
    }

    @Override
    public boolean supportsUpgrades() {
        IBoundingBlock main = this.getMain();
        return main != null && main.supportsUpgrades();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            return main.getComponent();
        }
        return null;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgradeType) {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            main.recalculateUpgrades(upgradeType);
        }
    }

    @Override
    public void load(@NotNull CompoundTag nbt) {
        super.load(nbt);
        NBTUtils.setBlockPosIfPresent(nbt, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = nbt.getInt("redstone");
        this.receivedCoords = nbt.getBoolean("receivedCoords");
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags) {
        super.saveAdditional(nbtTags);
        if (this.receivedCoords) {
            nbtTags.put("main", (Tag)NbtUtils.writeBlockPos((BlockPos)this.getMainPos()));
        }
        nbtTags.putInt("redstone", this.currentRedstoneLevel);
        nbtTags.putBoolean("receivedCoords", this.receivedCoords);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        if (this.receivedCoords) {
            updateTag.put("main", (Tag)NbtUtils.writeBlockPos((BlockPos)this.getMainPos()));
        }
        updateTag.putInt("redstone", this.currentRedstoneLevel);
        updateTag.putBoolean("receivedCoords", this.receivedCoords);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBlockPosIfPresent(tag, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = tag.getInt("redstone");
        this.receivedCoords = tag.getBoolean("receivedCoords");
    }

    public boolean hasCustomName() {
        Nameable mainTile;
        BlockEntity blockEntity = this.getMainTile();
        return blockEntity instanceof Nameable && (mainTile = (Nameable)blockEntity).hasCustomName();
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.getCustomName() : MekanismBlocks.BOUNDING_BLOCK.getTextComponent();
    }

    @NotNull
    public Component getDisplayName() {
        Component component;
        BlockEntity blockEntity = this.getMainTile();
        if (blockEntity instanceof Nameable) {
            Nameable mainTile = (Nameable)blockEntity;
            component = mainTile.getDisplayName();
        } else {
            component = MekanismBlocks.BOUNDING_BLOCK.getTextComponent();
        }
        return component;
    }

    @Nullable
    public Component getCustomName() {
        Component component;
        BlockEntity blockEntity = this.getMainTile();
        if (blockEntity instanceof Nameable) {
            Nameable mainTile = (Nameable)blockEntity;
            component = mainTile.getCustomName();
        } else {
            component = null;
        }
        return component;
    }

    public static <CAP> void proxyCapability(RegisterCapabilitiesEvent event, BlockCapability<CAP, @Nullable Direction> capability) {
        event.registerBlock(capability, (level, pos, state, blockEntity, context) -> {
            TileEntityBoundingBlock bounding;
            IBoundingBlock main;
            if (blockEntity instanceof TileEntityBoundingBlock && (main = (bounding = (TileEntityBoundingBlock)blockEntity).getMain()) != null) {
                return main.getOffsetCapability(capability, (Direction)context, (Vec3i)pos.subtract((Vec3i)bounding.getMainPos()));
            }
            return null;
        }, new Block[]{MekanismBlocks.BOUNDING_BLOCK.getBlock()});
    }

    public static <CAP, CONTEXT> void alwaysProxyCapability(RegisterCapabilitiesEvent event, BlockCapability<CAP, CONTEXT> capability) {
        event.registerBlock(capability, (level, pos, state, blockEntity, context) -> {
            BlockPos mainPos = BlockBounding.getMainBlockPos((BlockGetter)level, pos);
            return mainPos == null ? null : WorldUtils.getCapability(level, capability, mainPos, context);
        }, new Block[]{MekanismBlocks.BOUNDING_BLOCK.getBlock()});
    }
}

