/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChargepad
extends TileEntityMekanism {
    private static final Predicate<LivingEntity> CHARGE_PREDICATE = entity -> !entity.isSpectator() && (entity instanceof Player || entity instanceof EntityRobit);
    private MachineEnergyContainer<TileEntityChargepad> energyContainer;

    public TileEntityChargepad(BlockPos pos, BlockState state) {
        super(MekanismBlocks.CHARGEPAD, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        boolean active = false;
        if (!this.energyContainer.isEmpty()) {
            List entities = this.level.getEntitiesOfClass(LivingEntity.class, new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)this.worldPosition.getY() + 0.4, (double)(this.worldPosition.getZ() + 1)), CHARGE_PREDICATE);
            for (LivingEntity entity : entities) {
                if (this.energyContainer.isEmpty()) break;
                if (entity instanceof Player) {
                    IItemHandler itemHandler = (IItemHandler)Capabilities.ITEM.getCapability((Entity)entity);
                    if (this.chargeHandler(itemHandler)) {
                        active = true;
                        continue;
                    }
                    if (!Mekanism.hooks.CuriosLoaded || !this.chargeHandler(CuriosIntegration.getCuriosInventory(entity))) continue;
                    active = true;
                    continue;
                }
                if (!this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler((Entity)entity))) continue;
                active = true;
            }
        }
        if (active != this.getActive()) {
            this.setActive(active);
        }
        return sendUpdatePacket;
    }

    private boolean chargeHandler(@Nullable IItemHandler itemHandler) {
        if (itemHandler != null) {
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.isEmpty() || !this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler(stack))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean provideEnergy(@Nullable IStrictEnergyHandler energyHandler) {
        FloatingLong extractedEnergy;
        if (energyHandler == null) {
            return false;
        }
        FloatingLong energyToGive = this.energyContainer.getEnergyPerTick();
        FloatingLong simulatedRemainder = energyHandler.insertEnergy(energyToGive, Action.SIMULATE);
        if (simulatedRemainder.smallerThan(energyToGive) && !(extractedEnergy = this.energyContainer.extract(energyToGive.subtract(simulatedRemainder), Action.EXECUTE, AutomationType.INTERNAL)).isZero()) {
            MekanismUtils.logExpectedZero(energyHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
            return true;
        }
        return false;
    }

    @Override
    public void setActive(boolean active) {
        boolean wasActive = this.getActive();
        super.setActive(active);
        if (wasActive != active) {
            float pitch;
            SoundEvent sound;
            if (active) {
                sound = SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON;
                pitch = 0.8f;
            } else {
                sound = SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF;
                pitch = 0.7f;
            }
            this.level.playSound(null, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.1, (double)this.getBlockPos().getZ() + 0.5, sound, SoundSource.BLOCKS, 0.3f, pitch);
        }
    }
}

