/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.IContentsListener;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.security.PacketSyncSecurity;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySecurityDesk
extends TileEntityMekanism
implements IBoundingBlock {
    private SecurityInventorySlot unlockSlot;
    private SecurityInventorySlot lockSlot;

    public TileEntitySecurityDesk(BlockPos pos, BlockState state) {
        super(MekanismBlocks.SECURITY_DESK, pos, state);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.unlockSlot = SecurityInventorySlot.unlock(this::getOwnerUUID, listener, 146, 18);
        builder.addSlot(this.unlockSlot);
        this.lockSlot = SecurityInventorySlot.lock(listener, 146, 97);
        builder.addSlot(this.lockSlot);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        SecurityFrequency frequency = this.getFreq();
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null && frequency != null) {
            this.unlockSlot.unlock(ownerUUID);
            this.lockSlot.lock(ownerUUID, frequency);
        }
        return sendUpdatePacket;
    }

    public void toggleOverride() {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.setOverridden(!frequency.isOverridden());
            this.markForSave();
            PacketUtils.sendToAll(new PacketSyncSecurity(frequency));
            this.validateAccess();
        }
    }

    private void validateAccess() {
        MinecraftServer server;
        if (this.hasLevel() && (server = this.getWorldNN().getServer()) != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                this.closeIfNoAccess((Player)player);
            }
        }
    }

    public void removeTrusted(int index) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            MinecraftServer server;
            UUID removed = frequency.removeTrusted(index);
            this.markForSave();
            if (removed != null && this.hasLevel() && (server = this.getWorldNN().getServer()) != null) {
                this.closeIfNoAccess((Player)server.getPlayerList().getPlayer(removed));
            }
        }
    }

    private void closeIfNoAccess(@Nullable Player player) {
        ISecurityContainer container;
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof ISecurityContainer && !(container = (ISecurityContainer)abstractContainerMenu).canPlayerAccess(player)) {
            player.closeContainer();
        }
    }

    public void setSecurityDeskMode(SecurityMode mode) {
        SecurityMode old;
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null && (old = frequency.getSecurity()) != mode) {
            frequency.setSecurityMode(mode);
            this.markForSave();
            PacketUtils.sendToAll(new PacketSyncSecurity(frequency));
            if (ISecurityUtils.INSTANCE.moreRestrictive(old, mode)) {
                this.validateAccess();
            }
        }
    }

    public void addTrusted(String name) {
        Optional gameProfile;
        SecurityFrequency frequency;
        GameProfileCache profileCache;
        MinecraftServer server;
        if (this.level != null && (server = this.level.getServer()) != null && (profileCache = server.getProfileCache()) != null && (frequency = this.getFreq()) != null && (gameProfile = profileCache.get(name)).isPresent()) {
            GameProfile profile = (GameProfile)gameProfile.get();
            frequency.addTrusted(profile.getId(), profile.getName());
        }
    }

    public SecurityFrequency getFreq() {
        return (SecurityFrequency)this.getFrequency(FrequencyType.SECURITY);
    }
}

