/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.IConfigCardAccess;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.component.AttachedFrequencyComponent;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.capabilities.resolver.manager.HeatHandlerManager;
import mekanism.common.capabilities.resolver.manager.ItemHandlerManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.FactoryRegistry;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.MethodRestriction;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.item.ItemConfigurationCard;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.LastEnergyTracker;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.TileComponentFrequency;
import mekanism.common.lib.security.BlockSecurityUtils;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ITierUpgradable;
import mekanism.common.tile.interfaces.ITileActive;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.tile.interfaces.ITileRedstone;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.ITileUpgradable;
import mekanism.common.tile.interfaces.chemical.IGasTile;
import mekanism.common.tile.interfaces.chemical.IInfusionTile;
import mekanism.common.tile.interfaces.chemical.IPigmentTile;
import mekanism.common.tile.interfaces.chemical.ISlurryTile;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityMekanism
extends CapabilityTileEntity
implements IFrequencyHandler,
ITileDirectional,
IConfigCardAccess,
ITileActive,
ITileSound,
ITileRedstone,
ISecurityTile,
IMekanismInventory,
ITileUpgradable,
ITierUpgradable,
IComparatorSupport,
ITrackableContainer,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IGasTile,
IInfusionTile,
IPigmentTile,
ISlurryTile,
IComputerTile,
ITileRadioactive,
Nameable {
    public final Set<Player> playersUsing = new HashSet<Player>();
    public int ticker;
    private final List<ITileComponent> components = new ArrayList<ITileComponent>();
    protected final IBlockProvider blockProvider;
    private boolean supportsComparator;
    private boolean supportsComputers;
    private boolean supportsUpgrades;
    private boolean supportsRedstone;
    private boolean canBeUpgraded;
    private boolean isDirectional;
    private boolean isActivatable;
    private AttributeStateActive activeAttribute;
    private boolean hasSecurity;
    private boolean hasSound;
    private boolean hasGui;
    private boolean hasChunkloader;
    private boolean nameable;
    @Nullable
    private Component customName;
    @Nullable
    private String containerDescription;
    @Nullable
    private Direction cachedDirection;
    protected boolean redstone = false;
    private boolean redstoneLastTick = false;
    private IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private int currentRedstoneLevel;
    private boolean updateComparators;
    protected TileComponentUpgrade upgradeComponent;
    protected final TileComponentFrequency frequencyComponent;
    @Nullable
    protected final ItemHandlerManager itemHandlerManager;
    @Nullable
    private final ChemicalHandlerManager.GasHandlerManager gasHandlerManager;
    private float radiationScale;
    @Nullable
    private final ChemicalHandlerManager.InfusionHandlerManager infusionHandlerManager;
    @Nullable
    private final ChemicalHandlerManager.PigmentHandlerManager pigmentHandlerManager;
    @Nullable
    private final ChemicalHandlerManager.SlurryHandlerManager slurryHandlerManager;
    @Nullable
    private final FluidHandlerManager fluidHandlerManager;
    @Nullable
    private final EnergyHandlerManager energyHandlerManager;
    private final LastEnergyTracker lastEnergyTracker = new LastEnergyTracker();
    protected final Map<Direction, BlockCapabilityCache<IHeatHandler, @Nullable Direction>> adjacentHeatCaps;
    protected final CachedAmbientTemperature ambientTemperature;
    @Nullable
    protected final HeatHandlerManager heatHandlerManager;
    private TileComponentSecurity securityComponent;
    private boolean currentActive;
    private int updateDelay;
    protected IntSupplier delaySupplier;
    @Nullable
    protected final Supplier<SoundEvent> soundEvent;
    @Nullable
    protected SoundEvent lastSoundEvent;
    private SoundInstance activeSound;
    private int playSoundCooldown;

    public TileEntityMekanism(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType(), pos, state);
        IFluidTankHolder initialFluidTanks;
        this.delaySupplier = MekanismConfig.general.blockDeactivationDelay;
        this.playSoundCooldown = 0;
        this.blockProvider = blockProvider;
        Block block = this.blockProvider.getBlock();
        this.setSupportedTypes(block);
        this.presetVariables();
        IContentsListener saveOnlyListener = this::markForSave;
        this.gasHandlerManager = this.getInitialGasManager(this.getListener(ContainerType.GAS, saveOnlyListener));
        ArrayList capabilityHandlerManagers = new ArrayList();
        if (this.gasHandlerManager != null) {
            capabilityHandlerManagers.add(this.gasHandlerManager);
        }
        this.infusionHandlerManager = this.getInitialInfusionManager(this.getListener(ContainerType.INFUSION, saveOnlyListener));
        if (this.infusionHandlerManager != null) {
            capabilityHandlerManagers.add(this.infusionHandlerManager);
        }
        this.pigmentHandlerManager = this.getInitialPigmentManager(this.getListener(ContainerType.PIGMENT, saveOnlyListener));
        if (this.pigmentHandlerManager != null) {
            capabilityHandlerManagers.add(this.pigmentHandlerManager);
        }
        this.slurryHandlerManager = this.getInitialSlurryManager(this.getListener(ContainerType.SLURRY, saveOnlyListener));
        if (this.slurryHandlerManager != null) {
            capabilityHandlerManagers.add(this.slurryHandlerManager);
        }
        if ((initialFluidTanks = this.getInitialFluidTanks(this.getListener(ContainerType.FLUID, saveOnlyListener))) != null) {
            this.fluidHandlerManager = new FluidHandlerManager(initialFluidTanks, this);
            capabilityHandlerManagers.add(this.fluidHandlerManager);
        } else {
            this.fluidHandlerManager = null;
        }
        IEnergyContainerHolder initialEnergyContainers = this.getInitialEnergyContainers(this.getListener(ContainerType.ENERGY, saveOnlyListener));
        if (initialEnergyContainers != null) {
            this.energyHandlerManager = new EnergyHandlerManager(initialEnergyContainers, this);
            capabilityHandlerManagers.add(this.energyHandlerManager);
        } else {
            this.energyHandlerManager = null;
        }
        IInventorySlotHolder initialInventory = this.getInitialInventory(this.getListener(ContainerType.ITEM, saveOnlyListener));
        if (initialInventory != null) {
            this.itemHandlerManager = new ItemHandlerManager(initialInventory, this);
            capabilityHandlerManagers.add(this.itemHandlerManager);
        } else {
            this.itemHandlerManager = null;
        }
        CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(() -> ((TileEntityMekanism)this).getLevel(), () -> ((TileEntityMekanism)this).getBlockPos());
        IHeatCapacitorHolder initialHeatCapacitors = this.getInitialHeatCapacitors(this.getListener(ContainerType.HEAT, saveOnlyListener), ambientTemperature);
        if (initialHeatCapacitors != null) {
            this.heatHandlerManager = new HeatHandlerManager(initialHeatCapacitors, this);
            capabilityHandlerManagers.add(this.heatHandlerManager);
        } else {
            this.heatHandlerManager = null;
        }
        if (this.canHandleHeat()) {
            this.adjacentHeatCaps = new EnumMap<Direction, BlockCapabilityCache<IHeatHandler, Direction>>(Direction.class);
            this.ambientTemperature = ambientTemperature;
        } else {
            this.adjacentHeatCaps = Collections.emptyMap();
            this.ambientTemperature = null;
        }
        this.addCapabilityResolvers(capabilityHandlerManagers);
        this.frequencyComponent = new TileComponentFrequency(this);
        if (this.supportsUpgrades()) {
            this.upgradeComponent = new TileComponentUpgrade(this);
        }
        if (this.hasSecurity()) {
            this.securityComponent = new TileComponentSecurity(this);
        }
        this.soundEvent = this.hasSound() ? Attribute.getOrThrow(block, AttributeSound.class).getSound() : null;
    }

    private void setSupportedTypes(Block block) {
        this.supportsUpgrades = Attribute.has(block, AttributeUpgradeSupport.class);
        this.canBeUpgraded = Attribute.has(block, AttributeUpgradeable.class);
        this.isDirectional = Attribute.has(block, AttributeStateFacing.class);
        this.supportsRedstone = Attribute.has(block, Attributes.AttributeRedstone.class);
        this.hasSound = Attribute.has(block, AttributeSound.class);
        this.hasGui = Attribute.has(block, AttributeGui.class);
        this.hasSecurity = Attribute.has(block, Attributes.AttributeSecurity.class);
        this.activeAttribute = Attribute.get(block, AttributeStateActive.class);
        this.isActivatable = this.hasSound || this.activeAttribute != null;
        this.supportsComparator = Attribute.has(block, Attributes.AttributeComparator.class);
        this.supportsComputers = Mekanism.hooks.computerCompatEnabled() && Attribute.has(block, Attributes.AttributeComputerIntegration.class);
        this.hasChunkloader = this instanceof IChunkLoader;
        this.nameable = this.hasGui() && !Attribute.getOrThrow(this.getBlockType(), AttributeGui.class).hasCustomName();
    }

    protected void presetVariables() {
    }

    public Block getBlockType() {
        return this.blockProvider.getBlock();
    }

    public ResourceLocation getBlockTypeRegistryName() {
        return this.blockProvider.getRegistryName();
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        return type.canHandle(this);
    }

    public boolean syncs(ContainerType<?, ?, ?> type) {
        return this.persists(type);
    }

    @Override
    public final boolean supportsUpgrades() {
        return this.supportsUpgrades;
    }

    @Override
    public final boolean supportsComparator() {
        return this.supportsComparator;
    }

    @Override
    public final boolean canBeUpgraded() {
        return this.canBeUpgraded;
    }

    @Override
    public final boolean isDirectional() {
        return this.isDirectional;
    }

    @Override
    public final boolean supportsRedstone() {
        return this.supportsRedstone;
    }

    @Override
    public final boolean hasSound() {
        return this.hasSound;
    }

    public final boolean hasGui() {
        return this.hasGui;
    }

    @Override
    public final boolean hasSecurity() {
        return this.hasSecurity;
    }

    @Override
    public final boolean isActivatable() {
        return this.isActivatable;
    }

    @Override
    public final boolean hasComputerSupport() {
        return this.supportsComputers;
    }

    @Override
    public final boolean hasInventory() {
        return this.itemHandlerManager != null && this.itemHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleGas() {
        return this.gasHandlerManager != null && this.gasHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleInfusion() {
        return this.infusionHandlerManager != null && this.infusionHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandlePigment() {
        return this.pigmentHandlerManager != null && this.pigmentHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleSlurry() {
        return this.slurryHandlerManager != null && this.slurryHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleFluid() {
        return this.fluidHandlerManager != null && this.fluidHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleEnergy() {
        return this.energyHandlerManager != null && this.energyHandlerManager.canHandle();
    }

    @Override
    public final boolean canHandleHeat() {
        return this.heatHandlerManager != null && this.heatHandlerManager.canHandle();
    }

    public void addComponent(ITileComponent component) {
        this.components.add(component);
        if (component instanceof TileComponentConfig) {
            TileComponentConfig config = (TileComponentConfig)component;
            this.addConfigComponent(config);
        }
    }

    public List<ITileComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.getCustomName() : TextComponentUtil.build(this.getBlockType());
    }

    @NotNull
    public Component getDisplayName() {
        if (this.isNameable()) {
            return this.hasCustomName() ? this.getCustomName() : TextComponentUtil.translate(this.getContainerDescription());
        }
        return TextComponentUtil.build(this.getBlockType());
    }

    private String getContainerDescription() {
        if (this.containerDescription == null) {
            this.containerDescription = Util.makeDescriptionId((String)"container", (ResourceLocation)this.getBlockTypeRegistryName());
        }
        return this.containerDescription;
    }

    @Nullable
    public Component getCustomName() {
        return this.isNameable() ? this.customName : null;
    }

    public void setCustomName(@Nullable Component name) {
        if (this.isNameable()) {
            this.customName = name;
        }
    }

    public boolean isNameable() {
        return this.nameable;
    }

    @Override
    public void markDirtyComparator() {
        if (this.supportsComparator()) {
            this.updateComparators = true;
        }
    }

    protected void notifyComparatorChange() {
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockType());
    }

    public WrenchResult tryWrench(BlockState state, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        ItemStack stack = player.getItemInHand(hand);
        if (MekanismUtils.canUseAsWrench(stack)) {
            if (this.hasSecurity() && !IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, this.getWorldNN(), this.worldPosition, this)) {
                return WrenchResult.NO_SECURITY;
            }
            if (player.isShiftKeyDown()) {
                if (IRadiationManager.INSTANCE.isRadiationEnabled() && this.getRadiationScale() > 0.0f) {
                    return WrenchResult.RADIOACTIVE;
                }
                WorldUtils.dismantleBlock(state, this.getLevel(), this.worldPosition, this, (Entity)player);
                return WrenchResult.DISMANTLED;
            }
            if (this.isDirectional() && Attribute.getOrThrow(this.getBlockType(), AttributeStateFacing.class).canRotate()) {
                this.setFacing(this.getDirection().getClockWise());
            }
            return WrenchResult.SUCCESS;
        }
        return WrenchResult.PASS;
    }

    public InteractionResult openGui(Player player) {
        if (this.hasGui() && !this.isRemote() && !player.isShiftKeyDown()) {
            ItemConfigurator configurator;
            Item item;
            if (this.hasSecurity() && !IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, player.level(), this.worldPosition, this)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.getMainHandItem();
            if (this.isDirectional() && !stack.isEmpty() && (item = stack.getItem()) instanceof ItemConfigurator && (configurator = (ItemConfigurator)item).getMode(stack) == ItemConfigurator.ConfiguratorMode.ROTATE) {
                return InteractionResult.PASS;
            }
            if (!stack.isEmpty() && stack.getItem() instanceof ItemConfigurationCard && WorldUtils.getCapability(this.level, Capabilities.CONFIG_CARD, this.worldPosition, null, this, null) != null) {
                return InteractionResult.PASS;
            }
            player.openMenu(Attribute.getOrThrow(this.getBlockType(), AttributeGui.class).getProvider(this, true), this.worldPosition);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, TileEntityMekanism tile) {
        if (tile.hasSound()) {
            tile.updateSound();
        }
        tile.onUpdateClient();
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TileEntityMekanism tile) {
        tile.frequencyComponent.tickServer(level, pos);
        if (tile.supportsUpgrades()) {
            tile.upgradeComponent.tickServer();
        }
        if (tile.hasChunkloader) {
            ((IChunkLoader)((Object)tile)).getChunkLoader().tickServer();
        }
        if (tile.isActivatable() && tile.updateDelay > 0) {
            --tile.updateDelay;
            if (tile.updateDelay == 0 && tile.getClientActive() != tile.currentActive) {
                level.setBlockAndUpdate(pos, tile.activeAttribute.setActive(state, tile.currentActive));
            }
        }
        boolean sendUpdatePacket = tile.onUpdateServer();
        if (tile.updateRadiationScale()) {
            sendUpdatePacket = true;
        }
        if (tile.canHandleHeat()) {
            tile.updateHeatCapacitors(null);
        }
        tile.lastEnergyTracker.received(level.getGameTime(), FloatingLong.ZERO);
        if (tile.supportsComparator() && tile.updateComparators && !state.isAir()) {
            int newRedstoneLevel = tile.getRedstoneLevel();
            if (newRedstoneLevel != tile.currentRedstoneLevel) {
                tile.currentRedstoneLevel = newRedstoneLevel;
                tile.notifyComparatorChange();
            }
            tile.updateComparators = false;
        }
        ++tile.ticker;
        if (tile.supportsRedstone()) {
            tile.redstoneLastTick = tile.redstone;
        }
        if (sendUpdatePacket) {
            tile.sendUpdatePacket();
        }
    }

    public void open(Player player) {
        this.playersUsing.add(player);
    }

    public void close(Player player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        for (ITileComponent component : this.components) {
            component.invalidate();
        }
        if (this.isRemote() && this.hasSound()) {
            this.updateSound();
        }
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        for (ITileComponent component : this.components) {
            component.removed();
        }
        if (!this.isRemote() && IRadiationManager.INSTANCE.isRadiationEnabled() && this.shouldDumpRadiation()) {
            IRadiationManager.INSTANCE.dumpRadiation(this.getTileGlobalPos(), this.getGasTanks(null), false);
        }
    }

    protected void onUpdateClient() {
    }

    protected boolean onUpdateServer() {
        return false;
    }

    @Deprecated
    public void setBlockState(@NotNull BlockState newState) {
        Direction newDirection;
        super.setBlockState(newState);
        if (this.isDirectional() && this.cachedDirection != (newDirection = Attribute.getFacing(newState))) {
            this.invalidateDirectionCaches(newDirection);
        }
    }

    @Override
    public void load(@NotNull CompoundTag nbt) {
        super.load(nbt);
        NBTUtils.setBooleanIfPresent(nbt, "redstone", value -> {
            this.redstone = value;
        });
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.read(nbt);
        }
        this.readSustainedData(nbt);
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!containerType.canHandle(this) || !this.persists(containerType)) continue;
            containerType.readFrom(nbt, this);
        }
        if (this.isActivatable()) {
            NBTUtils.setBooleanIfPresent(nbt, "activeState", value -> {
                this.currentActive = value;
            });
            NBTUtils.setIntIfPresent(nbt, "updateDelay", value -> {
                this.updateDelay = value;
            });
        }
        if (this.supportsComparator()) {
            NBTUtils.setIntIfPresent(nbt, "currentRedstone", value -> {
                this.currentRedstoneLevel = value;
            });
        }
        if (this.isNameable()) {
            NBTUtils.setStringIfPresent(nbt, "CustomName", value -> {
                this.customName = Component.Serializer.fromJson((String)value);
            });
        }
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags) {
        super.saveAdditional(nbtTags);
        nbtTags.putBoolean("redstone", this.redstone);
        for (ITileComponent iTileComponent : this.components) {
            iTileComponent.write(nbtTags);
        }
        this.writeSustainedData(nbtTags);
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!containerType.canHandle(this) || !this.persists(containerType)) continue;
            containerType.saveTo(nbtTags, this);
        }
        if (this.isActivatable()) {
            nbtTags.putBoolean("activeState", this.currentActive);
            nbtTags.putInt("updateDelay", this.updateDelay);
        }
        if (this.supportsComparator()) {
            nbtTags.putInt("currentRedstone", this.currentRedstoneLevel);
        }
        if (this.customName != null && this.isNameable()) {
            nbtTags.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
    }

    public void writeSustainedData(CompoundTag data) {
        if (this.supportsRedstone()) {
            NBTUtils.writeEnum(data, "controlType", this.controlType);
        }
    }

    public void readSustainedData(CompoundTag data) {
        if (this.supportsRedstone()) {
            NBTUtils.setEnumIfPresent(data, "controlType", IRedstoneControl.RedstoneControl::byIndexStatic, type -> {
                this.controlType = this.supportedOrNextType((IRedstoneControl.RedstoneControl)type);
            });
        }
    }

    public Map<String, Holder<AttachmentType<?>>> getTileDataAttachmentRemap() {
        HashMap remap = new HashMap();
        if (this.supportsRedstone()) {
            remap.put("controlType", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.REDSTONE_CONTROL);
        }
        return remap;
    }

    @Override
    public void readFromStack(ItemStack stack) {
        Object storedUpgrades;
        super.readFromStack(stack);
        if (this.supportsRedstone()) {
            this.updatePower();
        }
        if (this.isNameable() && stack.hasCustomHoverName()) {
            this.setCustomName(stack.getHoverName());
        }
        if (!this.isRemote() && this.getFrequencyComponent().hasCustomFrequencies()) {
            ((AttachedFrequencyComponent)stack.getData(MekanismAttachmentTypes.FREQUENCY_COMPONENT)).copyTo(this.getFrequencyComponent());
        }
        if (this.hasSecurity()) {
            UUID uUID;
            ISecurityObject security = IItemSecurityUtils.INSTANCE.securityCapability(stack);
            if (security != null) {
                this.setSecurityMode(security.getSecurityMode());
            }
            if ((uUID = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack)) != null) {
                this.setOwnerUUID(uUID);
            }
        }
        if (this.supportsUpgrades() && ((Optional)(storedUpgrades = stack.getExistingData(MekanismAttachmentTypes.UPGRADES))).isPresent()) {
            ((UpgradeAware)((Optional)storedUpgrades).get()).copyTo(this.getComponent());
        }
        for (ContainerType containerType : ContainerType.TYPES) {
            if (!this.persists(containerType)) continue;
            containerType.copyFrom(stack, this);
        }
        TileEntityMekanism tileEntityMekanism = this;
        if (tileEntityMekanism instanceof ITileFilterHolder) {
            ITileFilterHolder filterHolder = (ITileFilterHolder)((Object)tileEntityMekanism);
            Optional optional = stack.getExistingData(MekanismAttachmentTypes.FILTER_AWARE);
            if (optional.isPresent()) {
                ((FilterAware)optional.get()).copyTo(filterHolder.getFilterManager());
            }
        }
        if (this.supportsRedstone()) {
            this.setControlType((IRedstoneControl.RedstoneControl)stack.getData(MekanismAttachmentTypes.REDSTONE_CONTROL));
        }
    }

    @Override
    public void writeToStack(ItemStack stack) {
        ITileFilterHolder filterHolder;
        FilterManager filterManager;
        ISecurityObject securityObject;
        IOwnerObject ownerObject;
        super.writeToStack(stack);
        if (this.getFrequencyComponent().hasCustomFrequencies()) {
            ((AttachedFrequencyComponent)stack.getData(MekanismAttachmentTypes.FREQUENCY_COMPONENT)).copyFrom(this.getFrequencyComponent());
        }
        if (this.hasSecurity() && (ownerObject = IItemSecurityUtils.INSTANCE.ownerCapability(stack)) != null) {
            ownerObject.setOwnerUUID(this.getOwnerUUID());
            securityObject = IItemSecurityUtils.INSTANCE.securityCapability(stack);
            if (securityObject != null) {
                securityObject.setSecurityMode(this.getSecurityMode());
            }
        }
        if (this.supportsUpgrades()) {
            ((UpgradeAware)stack.getData(MekanismAttachmentTypes.UPGRADES)).copyFrom(this.getComponent());
        }
        if ((securityObject = this) instanceof ITileFilterHolder && !(filterManager = (filterHolder = (ITileFilterHolder)((Object)securityObject)).getFilterManager()).getFilters().isEmpty()) {
            ((FilterAware)stack.getData(MekanismAttachmentTypes.FILTER_AWARE)).copyFrom(filterManager);
        }
        if (this.supportsRedstone()) {
            stack.setData(MekanismAttachmentTypes.REDSTONE_CONTROL, (Object)this.controlType);
        }
        for (ContainerType<?, ?, ?> type : ContainerType.TYPES) {
            if (!this.persists(type)) continue;
            type.copyTo(this, stack);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        block18: {
            SyncMapper.INSTANCE.setup(container, this.getClass(), () -> this);
            for (ITileComponent component : this.components) {
                component.trackForMainContainer(container);
            }
            if (this.supportsRedstone()) {
                container.track(SyncableEnum.create(IRedstoneControl.RedstoneControl::byIndexStatic, IRedstoneControl.RedstoneControl.DISABLED, () -> this.controlType, value -> {
                    this.controlType = value;
                }));
            }
            boolean isClient = this.isRemote();
            if (this.canHandleGas() && this.syncs(ContainerType.GAS)) {
                List gasTanks = this.getGasTanks(null);
                for (IGasTank gasTank : gasTanks) {
                    container.track(SyncableGasStack.create(gasTank, isClient));
                }
            }
            if (this.canHandleInfusion() && this.syncs(ContainerType.INFUSION)) {
                List infusionTanks = this.getInfusionTanks(null);
                for (IInfusionTank infusionTank : infusionTanks) {
                    container.track(SyncableInfusionStack.create(infusionTank, isClient));
                }
            }
            if (this.canHandlePigment() && this.syncs(ContainerType.PIGMENT)) {
                List pigmentTanks = this.getPigmentTanks(null);
                for (IPigmentTank pigmentTank : pigmentTanks) {
                    container.track(SyncablePigmentStack.create(pigmentTank, isClient));
                }
            }
            if (this.canHandleSlurry() && this.syncs(ContainerType.SLURRY)) {
                List slurryTanks = this.getSlurryTanks(null);
                for (ISlurryTank slurryTank : slurryTanks) {
                    container.track(SyncableSlurryStack.create(slurryTank, isClient));
                }
            }
            if (this.canHandleFluid() && this.syncs(ContainerType.FLUID)) {
                List<IExtendedFluidTank> fluidTanks = this.getFluidTanks(null);
                for (IExtendedFluidTank fluidTank : fluidTanks) {
                    container.track(SyncableFluidStack.create(fluidTank, isClient));
                }
            }
            if (this.canHandleHeat() && this.syncs(ContainerType.HEAT)) {
                List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(null);
                for (IHeatCapacitor capacitor : heatCapacitors) {
                    container.track(SyncableDouble.create(capacitor::getHeat, capacitor::setHeat));
                    if (!(capacitor instanceof BasicHeatCapacitor)) continue;
                    BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)capacitor;
                    container.track(SyncableDouble.create(capacitor::getHeatCapacity, capacity -> heatCapacitor.setHeatCapacity(capacity, false)));
                }
            }
            if (!this.canHandleEnergy() || !this.syncs(ContainerType.ENERGY)) break block18;
            this.trackLastEnergy(container);
            List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
            for (IEnergyContainer energyContainer : energyContainers) {
                block19: {
                    MachineEnergyContainer machineEnergy;
                    block20: {
                        if (!(energyContainer instanceof MachineEnergyContainer)) break block19;
                        machineEnergy = (MachineEnergyContainer)energyContainer;
                        if (this.supportsUpgrades()) break block20;
                        if (!machineEnergy.adjustableRates()) break block19;
                    }
                    container.track(SyncableFloatingLong.create(machineEnergy::getMaxEnergy, machineEnergy::setMaxEnergy));
                    container.track(SyncableFloatingLong.create(machineEnergy::getEnergyPerTick, machineEnergy::setEnergyPerTick));
                }
                container.track(SyncableFloatingLong.create(energyContainer::getEnergy, energyContainer::setEnergy));
            }
        }
    }

    protected void trackLastEnergy(MekanismContainer container) {
        container.track(SyncableFloatingLong.create(this.lastEnergyTracker::getLastEnergyReceived, this.lastEnergyTracker::setLastEnergyReceived));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        for (ITileComponent component : this.components) {
            component.addToUpdateTag(updateTag);
        }
        updateTag.putFloat("radiation", this.radiationScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        for (ITileComponent component : this.components) {
            component.readFromUpdateTag(tag);
        }
        this.radiationScale = tag.getFloat("radiation");
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        if (!this.isRemote()) {
            this.updatePower();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.updatePower();
        if (this.getClientActive()) {
            this.currentActive = true;
        }
    }

    @Override
    public TileComponentFrequency getFrequencyComponent() {
        return this.frequencyComponent;
    }

    public void parseUpgradeData(@NotNull IUpgradeData data) {
        Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
    }

    @Override
    @NotNull
    @ComputerMethod(restriction=MethodRestriction.DIRECTIONAL)
    public final Direction getDirection() {
        if (this.isDirectional()) {
            if (this.cachedDirection != null) {
                return this.cachedDirection;
            }
            BlockState state = this.getBlockState();
            this.cachedDirection = Attribute.getFacing(state);
            if (this.cachedDirection != null) {
                return this.cachedDirection;
            }
            if (!this.getType().isValid(state)) {
                Mekanism.logger.warn("Error invalid block for tile {} at {} in {}. Unable to get direction, falling back to north, things will probably not work correctly. This is almost certainly due to another mod incorrectly trying to move this tile and not properly updating the position.", new Object[]{RegistryUtils.getName(this.getType()), this.worldPosition, this.level});
            }
        }
        return Direction.NORTH;
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        this.cachedDirection = newDirection;
    }

    @Override
    public void setFacing(@NotNull Direction direction) {
        this.setFacing(direction, true);
    }

    public void setFacing(@NotNull Direction direction, boolean notifyCaps) {
        if (this.isDirectional() && direction != this.cachedDirection && this.level != null) {
            this.invalidateDirectionCaches(direction);
            BlockState state = Attribute.setFacing(this.getBlockState(), direction);
            if (state != null) {
                this.level.setBlockAndUpdate(this.worldPosition, state);
                if (notifyCaps) {
                    this.invalidateCapabilitiesFull();
                }
            }
        }
    }

    @Override
    @ComputerMethod(nameOverride="getRedstoneMode", restriction=MethodRestriction.REDSTONE_CONTROL)
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(@NotNull IRedstoneControl.RedstoneControl type) {
        if (this.supportsRedstone() && (type = this.supportedOrNextType(type)) != this.controlType) {
            this.controlType = type;
            this.markForSave();
        }
    }

    private IRedstoneControl.RedstoneControl supportedOrNextType(@NotNull IRedstoneControl.RedstoneControl type) {
        Objects.requireNonNull(type);
        if (!this.supportsMode(type)) {
            type = type.getNext(this::supportsMode);
        }
        return type;
    }

    @Override
    public boolean isPowered() {
        return this.supportsRedstone() && this.redstone;
    }

    @Override
    public final boolean wasPowered() {
        return this.supportsRedstone() && this.redstoneLastTick;
    }

    public final void updatePower() {
        boolean power;
        if (this.supportsRedstone() && this.redstone != (power = this.level.hasNeighborSignal(this.getBlockPos()))) {
            this.redstone = power;
            this.onPowerChange();
        }
    }

    public boolean canFunction() {
        if (this.supportsRedstone()) {
            return switch (this.controlType) {
                default -> throw new IncompatibleClassChangeError();
                case IRedstoneControl.RedstoneControl.DISABLED -> true;
                case IRedstoneControl.RedstoneControl.HIGH -> this.isPowered();
                case IRedstoneControl.RedstoneControl.LOW -> {
                    if (!this.isPowered()) {
                        yield true;
                    }
                    yield false;
                }
                case IRedstoneControl.RedstoneControl.PULSE -> this.isPowered() && !this.redstoneLastTick;
            };
        }
        return true;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.supportsComparator() && this.hasInventory()) {
            return MekanismUtils.redstoneLevelFromContents(this.getInventorySlots(null));
        }
        return 0;
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.ITEM;
    }

    protected final IContentsListener getListener(ContainerType<?, ?, ?> type, IContentsListener saveOnlyListener) {
        return !this.supportsComparator() || this.makesComparatorDirty(type) ? this : saveOnlyListener;
    }

    @Override
    @ComputerMethod(nameOverride="getComparatorLevel", restriction=MethodRestriction.COMPARATOR)
    public int getCurrentRedstoneLevel() {
        return this.currentRedstoneLevel;
    }

    @Override
    @NotNull
    public Set<Upgrade> getSupportedUpgrade() {
        if (this.supportsUpgrades()) {
            return Attribute.getOrThrow(this.getBlockType(), AttributeUpgradeSupport.class).supportedUpgrades();
        }
        return Collections.emptySet();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        block3: {
            block2: {
                if (upgrade != Upgrade.SPEED) break block2;
                for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                    if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                    MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                    machineEnergy.updateEnergyPerTick();
                }
                break block3;
            }
            if (upgrade != Upgrade.ENERGY) break block3;
            for (IEnergyContainer energyContainer : this.getEnergyContainers(null)) {
                if (!(energyContainer instanceof MachineEnergyContainer)) continue;
                MachineEnergyContainer machineEnergy = (MachineEnergyContainer)energyContainer;
                machineEnergy.updateMaxEnergy();
                machineEnergy.updateEnergyPerTick();
            }
        }
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.itemHandlerManager != null ? this.itemHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Override
    public void onContentsChanged() {
        this.setChanged();
    }

    @Override
    @Nullable
    public ChemicalHandlerManager.GasHandlerManager getGasManager() {
        return this.gasHandlerManager;
    }

    public boolean shouldDumpRadiation() {
        return this.canHandleGas();
    }

    private boolean updateRadiationScale() {
        float scale;
        if (this.shouldDumpRadiation() && Math.abs((scale = ITileRadioactive.calculateRadiationScale(this.getGasTanks(null))) - this.radiationScale) > 0.05f) {
            this.radiationScale = scale;
            return true;
        }
        return false;
    }

    @Override
    public float getRadiationScale() {
        return IRadiationManager.INSTANCE.isRadiationEnabled() ? this.radiationScale : 0.0f;
    }

    @Override
    @Nullable
    public ChemicalHandlerManager.InfusionHandlerManager getInfusionManager() {
        return this.infusionHandlerManager;
    }

    @Override
    @Nullable
    public ChemicalHandlerManager.PigmentHandlerManager getPigmentManager() {
        return this.pigmentHandlerManager;
    }

    @Override
    @Nullable
    public ChemicalHandlerManager.SlurryHandlerManager getSlurryManager() {
        return this.slurryHandlerManager;
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager != null ? this.fluidHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return null;
    }

    @Override
    @NotNull
    public final List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager != null ? this.energyHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Override
    @NotNull
    public FloatingLong insertEnergy(int container, @NotNull FloatingLong amount, @Nullable Direction side, @NotNull Action action) {
        return this.trackLastEnergy(amount, action, IMekanismStrictEnergyHandler.super.insertEnergy(container, amount, side, action));
    }

    @Override
    @NotNull
    public FloatingLong insertEnergy(@NotNull FloatingLong amount, @Nullable Direction side, @NotNull Action action) {
        return this.trackLastEnergy(amount, action, IMekanismStrictEnergyHandler.super.insertEnergy(amount, side, action));
    }

    private FloatingLong trackLastEnergy(@NotNull FloatingLong amount, @NotNull Action action, @NotNull FloatingLong remainder) {
        if (action.execute()) {
            this.lastEnergyTracker.received(this.level == null ? 0L : this.level.getGameTime(), remainder.isZero() ? amount : amount.subtract(remainder));
        }
        return remainder;
    }

    public final FloatingLong getInputRate() {
        return this.lastEnergyTracker.getLastEnergyReceived();
    }

    @Nullable
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return null;
    }

    @Override
    public double getAmbientTemperature(@NotNull Direction side) {
        if (this.canHandleHeat() && this.ambientTemperature != null) {
            return this.ambientTemperature.getTemperature(side);
        }
        return ITileHeatHandler.super.getAmbientTemperature(side);
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0) {
            return this.getAdjacentUnchecked(side);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    protected IHeatHandler getAdjacentUnchecked(@NotNull Direction side) {
        @Nullable BlockCapabilityCache cache = this.adjacentHeatCaps.get(side);
        if (cache == null) {
            cache = BlockCapabilityCache.create(Capabilities.HEAT, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Object)side.getOpposite());
            this.adjacentHeatCaps.put(side, (BlockCapabilityCache<IHeatHandler, Direction>)cache);
        }
        return (IHeatHandler)cache.getCapability();
    }

    @Override
    @NotNull
    public final List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatHandlerManager != null ? this.heatHandlerManager.getContainers(side) : Collections.emptyList();
    }

    @Override
    public CompoundTag getConfigurationData(Player player) {
        CompoundTag data = new CompoundTag();
        this.writeSustainedData(data);
        this.getFrequencyComponent().writeConfiguredFrequencies(data);
        return data;
    }

    @Override
    public void setConfigurationData(Player player, CompoundTag data) {
        this.readSustainedData(data);
        this.getFrequencyComponent().readConfiguredFrequencies(player, data);
    }

    @Override
    public Block getConfigurationDataType() {
        return this.getBlockType();
    }

    @Override
    public void configurationDataSet() {
        this.setChanged();
        this.invalidateCapabilitiesFull();
        this.sendUpdatePacket();
        WorldUtils.notifyLoadedNeighborsOfTileChange(this.getLevel(), this.getBlockPos());
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void onSecurityChanged(@NotNull SecurityMode old, @NotNull SecurityMode mode) {
        if (!this.isRemote() && this.hasGui() && this.level != null) {
            BlockSecurityUtils.get().securityChanged(this.playersUsing, this.level, this.worldPosition, this, old, mode);
        }
    }

    @Override
    public boolean getActive() {
        return this.isRemote() ? this.getClientActive() : this.currentActive;
    }

    private boolean getClientActive() {
        return this.activeAttribute != null && this.activeAttribute.isActive(this.getBlockState());
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActivatable() && active != this.currentActive) {
            BlockState state = this.getBlockState();
            if (this.activeAttribute != null) {
                this.currentActive = active;
                if (this.getClientActive() != active) {
                    if (active) {
                        this.level.setBlockAndUpdate(this.worldPosition, this.activeAttribute.setActive(state, true));
                    } else {
                        if (this.updateDelay == 0) {
                            this.level.setBlockAndUpdate(this.worldPosition, this.activeAttribute.setActive(state, this.currentActive));
                        }
                        this.updateDelay = this.delaySupplier.getAsInt();
                    }
                }
            }
        }
    }

    protected boolean canPlaySound() {
        return this.getActive();
    }

    private void updateSound() {
        if (!this.hasSound() || !MekanismConfig.client.enableMachineSounds.get() || this.soundEvent == null) {
            return;
        }
        if (this.canPlaySound() && !this.isRemoved()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            SoundEvent sound = this.soundEvent.get();
            if (sound != this.lastSoundEvent) {
                if (this.activeSound != null) {
                    SoundHandler.stopTileSound(this.getSoundPos());
                    this.activeSound = null;
                }
                this.lastSoundEvent = sound;
            }
            if (!(this.isFullyMuffled() || this.activeSound != null && Minecraft.getInstance().getSoundManager().isActive(this.activeSound))) {
                this.activeSound = SoundHandler.startTileSound(this.lastSoundEvent, this.getSoundCategory(), this.getInitialVolume(), this.level.getRandom(), this.getSoundPos());
            }
            this.playSoundCooldown = 20;
        } else if (this.activeSound != null) {
            SoundHandler.stopTileSound(this.getSoundPos());
            this.activeSound = null;
            this.playSoundCooldown = 0;
        }
    }

    protected boolean isFullyMuffled() {
        if (this.hasSound() && this.supportsUpgrade(Upgrade.MUFFLING)) {
            return this.getComponent().getUpgrades(Upgrade.MUFFLING) >= Upgrade.MUFFLING.getMax();
        }
        return false;
    }

    @Override
    public String getComputerName() {
        if (this.hasComputerSupport()) {
            return Attribute.getOrThrow(this.getBlockType(), Attributes.AttributeComputerIntegration.class).name();
        }
        return "";
    }

    public void validateSecurityIsPublic() throws ComputerException {
        if (this.hasSecurity() && IBlockSecurityUtils.INSTANCE.getSecurityMode(this.getWorldNN(), this.worldPosition, this) != SecurityMode.PUBLIC) {
            throw new ComputerException("Setter not available due to machine security not being public.");
        }
    }

    @Override
    public void getComputerMethods(BoundMethodHolder holder) {
        IComputerTile.super.getComputerMethods(holder);
        for (ITileComponent component : this.components) {
            FactoryRegistry.bindTo(holder, component);
        }
    }

    @ComputerMethod(nameOverride="getEnergy", restriction=MethodRestriction.ENERGY)
    FloatingLong getTotalEnergy() {
        return this.getTotalEnergy(IEnergyContainer::getEnergy);
    }

    @ComputerMethod(nameOverride="getMaxEnergy", restriction=MethodRestriction.ENERGY)
    FloatingLong getTotalMaxEnergy() {
        return this.getTotalEnergy(IEnergyContainer::getMaxEnergy);
    }

    @ComputerMethod(nameOverride="getEnergyNeeded", restriction=MethodRestriction.ENERGY)
    FloatingLong getTotalEnergyNeeded() {
        return this.getTotalEnergy(IEnergyContainer::getNeeded);
    }

    private FloatingLong getTotalEnergy(Function<IEnergyContainer, FloatingLong> getter) {
        FloatingLong total = FloatingLong.ZERO;
        List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            total = total.plusEqual(getter.apply(energyContainer));
        }
        return total;
    }

    @ComputerMethod(nameOverride="getEnergyFilledPercentage", restriction=MethodRestriction.ENERGY)
    double getTotalEnergyFilledPercentage() {
        FloatingLong stored = FloatingLong.ZERO;
        FloatingLong max = FloatingLong.ZERO;
        List<IEnergyContainer> energyContainers = this.getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            stored = stored.plusEqual(energyContainer.getEnergy());
            max = max.plusEqual(energyContainer.getMaxEnergy());
        }
        return stored.divideToLevel(max);
    }

    @ComputerMethod(restriction=MethodRestriction.REDSTONE_CONTROL, requiresPublicSecurity=true)
    void setRedstoneMode(IRedstoneControl.RedstoneControl type) throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.supportsMode(type)) {
            throw new ComputerException("Unsupported redstone control mode: %s", type);
        }
        this.setControlType(type);
    }
}

