/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.Chunk3D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketUpdateTile;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityUpdateable
extends BlockEntity
implements ITileWrapper {
    @Nullable
    private BiMap<AttachmentType<? extends INBTSerializable<?>>, String> syncableAttachmentTypes;
    @Nullable
    private GlobalPos cachedCoord;
    private boolean cacheCoord;
    private long lastSave;

    public TileEntityUpdateable(TileEntityTypeRegistryObject<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)type.get(), pos, state);
    }

    protected <SERIALIZABLE extends INBTSerializable<?>> void syncAttachmentType(DeferredHolder<AttachmentType<?>, AttachmentType<SERIALIZABLE>> holder) {
        if (this.syncableAttachmentTypes == null) {
            this.syncableAttachmentTypes = HashBiMap.create();
        }
        this.syncableAttachmentTypes.put((Object)((AttachmentType)holder.value()), (Object)holder.getId().toString());
    }

    public void readFromStack(ItemStack stack) {
    }

    public void writeToStack(ItemStack stack) {
    }

    public void onAdded() {
    }

    protected void cacheCoord() {
        this.cacheCoord = true;
        this.updateCoord();
    }

    @NotNull
    protected Level getWorldNN() {
        return Objects.requireNonNull(this.getLevel(), "getWorldNN called before world set");
    }

    public boolean isRemote() {
        return this.getWorldNN().isClientSide();
    }

    public void blockRemoved() {
    }

    public void markDirtyComparator() {
    }

    public final void setChanged() {
        this.setChanged(true);
    }

    public final void markForSave() {
        this.setChanged(false);
    }

    protected void setChanged(boolean updateComparator) {
        if (this.level != null) {
            long time = this.level.getGameTime();
            if (this.lastSave != time) {
                WorldUtils.markChunkDirty(this.level, this.worldPosition);
                this.lastSave = time;
            }
            if (updateComparator && !this.isRemote()) {
                this.markDirtyComparator();
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.load(tag);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        return this.getReducedUpdateTag();
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getUpdateTag();
        if (this.syncableAttachmentTypes != null) {
            CompoundTag serializedAttachments = updateTag.contains("neoforge:attachments", 10) ? updateTag.getCompound("neoforge:attachments") : new CompoundTag();
            for (Map.Entry entry : this.syncableAttachmentTypes.entrySet()) {
                Optional<Tag> tag = this.getExistingData((AttachmentType)entry.getKey()).map(INBTSerializable::serializeNBT);
                if (!tag.isPresent()) continue;
                serializedAttachments.put((String)entry.getValue(), tag.get());
            }
            if (!serializedAttachments.isEmpty()) {
                updateTag.put("neoforge:attachments", (Tag)serializedAttachments);
            }
        }
        return updateTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag;
        if (this.isRemote() && net.getDirection() == PacketFlow.CLIENTBOUND && (tag = pkt.getTag()) != null) {
            this.handleUpdatePacket(tag);
        }
    }

    public void handleUpdatePacket(@NotNull CompoundTag tag) {
        this.handleUpdateTag(tag);
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(this);
    }

    public void sendUpdatePacket(BlockEntity tracking) {
        if (this.isRemote()) {
            Mekanism.logger.warn("Update packet call requested from client side", (Throwable)new IllegalStateException());
        } else if (this.isRemoved()) {
            Mekanism.logger.warn("Update packet call requested for removed tile", (Throwable)new IllegalStateException());
        } else {
            PacketUtils.sendToAllTracking(new PacketUpdateTile(this), tracking);
        }
    }

    protected void updateModelData() {
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void load(@NotNull CompoundTag nbt) {
        super.load(nbt);
        this.updateCoord();
    }

    public void setLevel(@NotNull Level world) {
        super.setLevel(world);
        this.updateCoord();
    }

    private void updateCoord() {
        if (this.cacheCoord && this.level != null) {
            this.cachedCoord = GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition);
        }
    }

    @Override
    public GlobalPos getTileGlobalPos() {
        return this.cacheCoord && this.cachedCoord != null ? this.cachedCoord : ITileWrapper.super.getTileGlobalPos();
    }

    @Override
    public Chunk3D getTileChunk() {
        if (this.cacheCoord && this.cachedCoord != null) {
            return new Chunk3D(this.cachedCoord);
        }
        BlockPos pos = this.getBlockPos();
        return new Chunk3D((ResourceKey<Level>)this.getLevel().dimension(), SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }
}

