/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface ITileComponent {
    public String getComponentKey();

    default public void read(CompoundTag nbtTags) {
        NBTUtils.setCompoundIfPresent(nbtTags, this.getComponentKey(), this::deserialize);
    }

    default public void write(CompoundTag nbtTags) {
        CompoundTag componentTag = this.serialize();
        if (!componentTag.isEmpty()) {
            nbtTags.put(this.getComponentKey(), (Tag)componentTag);
        }
    }

    public void deserialize(CompoundTag var1);

    public CompoundTag serialize();

    default public void invalidate() {
    }

    default public void removed() {
    }

    default public void trackForMainContainer(MekanismContainer container) {
    }

    default public void addToUpdateTag(CompoundTag updateTag) {
    }

    default public void readFromUpdateTag(CompoundTag updateTag) {
    }
}

