/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.IPersistentConfigInfo;
import mekanism.common.tile.component.config.slot.BaseSlotInfo;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.HeatSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentConfig
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    public final TileEntityMekanism tile;
    private final Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private final Map<TransmissionType, List<Consumer<Direction>>> configChangeListeners = new EnumMap<TransmissionType, List<Consumer<Direction>>>(TransmissionType.class);
    private final List<TransmissionType> transmissionTypes = new ArrayList<TransmissionType>();

    public TileComponentConfig(TileEntityMekanism tile, Set<TransmissionType> types) {
        this.tile = tile;
        for (TransmissionType type : types) {
            this.configInfo.put(type, new ConfigInfo(tile::getDirection));
            this.transmissionTypes.add(type);
        }
        tile.addComponent(this);
    }

    public void addConfigChangeListener(TransmissionType transmissionType, Consumer<Direction> listener) {
        this.configChangeListeners.computeIfAbsent(transmissionType, type -> new ArrayList(1)).add(listener);
    }

    public void sideChanged(TransmissionType transmissionType, RelativeSide side) {
        Direction direction = side.getDirection(this.tile.getDirection());
        this.sideChangedBasic(transmissionType, direction);
        this.tile.sendUpdatePacket();
    }

    private void sideChangedBasic(TransmissionType transmissionType, Direction direction) {
        switch (transmissionType) {
            case ENERGY: {
                this.tile.invalidateCapabilities(EnergyCompatUtils.getLoadedEnergyCapabilities(), direction);
                break;
            }
            case FLUID: {
                this.tile.invalidateCapability(Capabilities.FLUID.block(), direction);
                break;
            }
            case GAS: {
                this.tile.invalidateCapability(Capabilities.GAS.block(), direction);
                break;
            }
            case INFUSION: {
                this.tile.invalidateCapability(Capabilities.INFUSION.block(), direction);
                break;
            }
            case PIGMENT: {
                this.tile.invalidateCapability(Capabilities.PIGMENT.block(), direction);
                break;
            }
            case SLURRY: {
                this.tile.invalidateCapability(Capabilities.SLURRY.block(), direction);
                break;
            }
            case ITEM: {
                this.tile.invalidateCapability(Capabilities.ITEM.block(), direction);
                break;
            }
            case HEAT: {
                this.tile.invalidateCapability(Capabilities.HEAT, direction);
            }
        }
        this.tile.markForSave();
        for (Consumer listener : this.configChangeListeners.getOrDefault(transmissionType, Collections.emptyList())) {
            listener.accept(direction);
        }
    }

    private RelativeSide getSide(Direction direction) {
        return RelativeSide.fromDirections(this.tile.getDirection(), direction);
    }

    @ComputerMethod(nameOverride="getConfigurableTypes")
    public List<TransmissionType> getTransmissions() {
        return this.transmissionTypes;
    }

    public boolean isCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        ConfigInfo info;
        TransmissionType type = null;
        if (Capabilities.ITEM.is(capability)) {
            type = TransmissionType.ITEM;
        } else if (Capabilities.GAS.is(capability)) {
            type = TransmissionType.GAS;
        } else if (Capabilities.INFUSION.is(capability)) {
            type = TransmissionType.INFUSION;
        } else if (Capabilities.PIGMENT.is(capability)) {
            type = TransmissionType.PIGMENT;
        } else if (Capabilities.SLURRY.is(capability)) {
            type = TransmissionType.SLURRY;
        } else if (capability == Capabilities.HEAT) {
            type = TransmissionType.HEAT;
        } else if (Capabilities.FLUID.is(capability)) {
            type = TransmissionType.FLUID;
        } else if (EnergyCompatUtils.isEnergyCapability(capability)) {
            type = TransmissionType.ENERGY;
        }
        if (type != null && (info = this.getConfig(type)) != null && side != null) {
            ISlotInfo slotInfo = info.getSlotInfo(this.getSide(side));
            return slotInfo == null || !slotInfo.isEnabled();
        }
        return false;
    }

    @Nullable
    public ConfigInfo getConfig(TransmissionType type) {
        return this.configInfo.get(type);
    }

    public void addDisabledSides(RelativeSide ... sides) {
        for (ConfigInfo config : this.configInfo.values()) {
            config.addDisabledSides(sides);
        }
    }

    public ConfigInfo setupInputConfig(TransmissionType type, Object container) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, false, container));
            config.fill(DataType.INPUT);
            config.setCanEject(false);
        }
        return config;
    }

    public ConfigInfo setupOutputConfig(TransmissionType type, Object container, RelativeSide ... sides) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, false, true, container));
            config.setDataType(DataType.OUTPUT, sides);
            config.setEjecting(true);
        }
        return config;
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputInfo, Object outputInfo, RelativeSide outputSide) {
        return this.setupIOConfig(type, inputInfo, outputInfo, outputSide, false);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputContainer, Object outputContainer, RelativeSide outputSide, boolean alwaysAllow) {
        return this.setupIOConfig(type, inputContainer, outputContainer, outputSide, alwaysAllow, alwaysAllow);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputContainer, Object outputContainer, RelativeSide outputSide, boolean alwaysAllowInput, boolean alwaysAllowOutput) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, alwaysAllowOutput, inputContainer));
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, alwaysAllowInput, true, outputContainer));
            config.addSlotInfo(DataType.INPUT_OUTPUT, TileComponentConfig.createInfo(type, true, true, List.of(inputContainer, outputContainer)));
            config.fill(DataType.INPUT);
            config.setDataType(DataType.OUTPUT, outputSide);
        }
        return config;
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object info, RelativeSide outputSide) {
        return this.setupIOConfig(type, info, outputSide, false);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object info, RelativeSide outputSide, boolean alwaysAllow) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, alwaysAllow, info));
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, alwaysAllow, true, info));
            config.addSlotInfo(DataType.INPUT_OUTPUT, TileComponentConfig.createInfo(type, true, true, info));
            config.fill(DataType.INPUT);
            config.setDataType(DataType.OUTPUT, outputSide);
        }
        return config;
    }

    public ConfigInfo setupItemIOConfig(IInventorySlot inputSlot, IInventorySlot outputSlot, IInventorySlot energySlot) {
        return this.setupItemIOConfig(Collections.singletonList(inputSlot), Collections.singletonList(outputSlot), energySlot, false);
    }

    public ConfigInfo setupItemIOConfig(List<IInventorySlot> inputSlots, List<IInventorySlot> outputSlots, IInventorySlot energySlot, boolean alwaysAllow) {
        ConfigInfo itemConfig = this.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, alwaysAllow, inputSlots));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(alwaysAllow, true, outputSlots));
            ArrayList<IInventorySlot> ioSlots = new ArrayList<IInventorySlot>(inputSlots);
            ioSlots.addAll(outputSlots);
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, ioSlots));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, energySlot));
            itemConfig.setDefaults();
        }
        return itemConfig;
    }

    public ConfigInfo setupItemIOExtraConfig(IInventorySlot inputSlot, IInventorySlot outputSlot, IInventorySlot extraSlot, IInventorySlot energySlot) {
        ConfigInfo itemConfig = this.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, false, inputSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(false, true, outputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, inputSlot, outputSlot));
            itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, extraSlot));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, energySlot));
            itemConfig.setDefaults();
        }
        return itemConfig;
    }

    @Nullable
    public DataType getDataType(TransmissionType type, RelativeSide side) {
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getDataType(side);
    }

    @Nullable
    public ISlotInfo getSlotInfo(TransmissionType type, Direction direction) {
        if (direction == null) {
            return null;
        }
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getSlotInfo(this.getSide(direction));
    }

    public boolean supports(TransmissionType type) {
        return this.configInfo.containsKey(type);
    }

    @Override
    public String getComponentKey() {
        return "componentConfig";
    }

    @Override
    public void deserialize(CompoundTag configNBT) {
        TileComponentConfig.read(configNBT, this.configInfo, (type, side) -> {
            if (this.tile.hasLevel()) {
                Direction direction = side.getDirection(this.tile.getDirection());
                this.sideChangedBasic((TransmissionType)type, direction);
            }
        });
    }

    public static void read(CompoundTag configNBT, Map<TransmissionType, ? extends IPersistentConfigInfo> configInfo) {
        TileComponentConfig.read(configNBT, configInfo, (type, side) -> {});
    }

    public static void read(CompoundTag configNBT, Map<TransmissionType, ? extends IPersistentConfigInfo> configInfo, BiConsumer<TransmissionType, RelativeSide> onChange) {
        for (Map.Entry<TransmissionType, ? extends IPersistentConfigInfo> entry : configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            IPersistentConfigInfo info = entry.getValue();
            NBTUtils.setBooleanIfPresent(configNBT, "eject" + type.ordinal(), info::setEjecting);
            String configKey = "config" + type.ordinal();
            if (!configNBT.contains(configKey, 11)) continue;
            int[] sideData = configNBT.getIntArray(configKey);
            for (int i = 0; i < sideData.length && i < EnumUtils.SIDES.length; ++i) {
                RelativeSide side = EnumUtils.SIDES[i];
                if (!info.setDataType(DataType.byIndexStatic(sideData[i]), side)) continue;
                onChange.accept(type, side);
            }
        }
    }

    @Override
    public CompoundTag serialize() {
        return TileComponentConfig.write(this.configInfo, true);
    }

    public static CompoundTag write(Map<TransmissionType, ? extends IPersistentConfigInfo> configInfo, boolean full) {
        CompoundTag configNBT = new CompoundTag();
        for (Map.Entry<TransmissionType, ? extends IPersistentConfigInfo> entry : configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            IPersistentConfigInfo info = entry.getValue();
            if (full) {
                configNBT.putBoolean("eject" + type.ordinal(), info.isEjecting());
            }
            int[] sideData = new int[EnumUtils.SIDES.length];
            for (int i = 0; i < EnumUtils.SIDES.length; ++i) {
                sideData[i] = info.getDataType(EnumUtils.SIDES[i]).ordinal();
            }
            configNBT.putIntArray("config" + type.ordinal(), sideData);
        }
        return configNBT;
    }

    @Override
    public void addToUpdateTag(CompoundTag updateTag) {
        CompoundTag configNBT = TileComponentConfig.write(this.configInfo, false);
        if (!configNBT.isEmpty()) {
            updateTag.put(this.getComponentKey(), (Tag)configNBT);
        }
    }

    @Override
    public void readFromUpdateTag(CompoundTag updateTag) {
        NBTUtils.setCompoundIfPresent(updateTag, this.getComponentKey(), configNBT -> TileComponentConfig.read(configNBT, this.configInfo));
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        for (TransmissionType transmission : this.getTransmissions()) {
            ConfigInfo info = this.configInfo.get(transmission);
            list.add(SyncableBoolean.create(info::isEjecting, info::setEjecting));
        }
        return list;
    }

    public static BaseSlotInfo createInfo(TransmissionType type, boolean input, boolean output, Object ... containers) {
        return TileComponentConfig.createInfo(type, input, output, List.of(containers));
    }

    public static BaseSlotInfo createInfo(TransmissionType type, boolean input, boolean output, List<?> containers) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TransmissionType.ITEM -> new InventorySlotInfo(input, output, containers);
            case TransmissionType.FLUID -> new FluidSlotInfo(input, output, containers);
            case TransmissionType.GAS -> new ChemicalSlotInfo.GasSlotInfo(input, output, (List<IGasTank>)containers);
            case TransmissionType.INFUSION -> new ChemicalSlotInfo.InfusionSlotInfo(input, output, (List<IInfusionTank>)containers);
            case TransmissionType.PIGMENT -> new ChemicalSlotInfo.PigmentSlotInfo(input, output, (List<IPigmentTank>)containers);
            case TransmissionType.SLURRY -> new ChemicalSlotInfo.SlurrySlotInfo(input, output, (List<ISlurryTank>)containers);
            case TransmissionType.ENERGY -> new EnergySlotInfo(input, output, containers);
            case TransmissionType.HEAT -> new HeatSlotInfo(input, output, containers);
        };
    }

    private void validateSupportedTransmissionType(TransmissionType type) throws ComputerException {
        if (!this.supports(type)) {
            throw new ComputerException("This machine does not support configuring transmission type '%s'.", type);
        }
    }

    @ComputerMethod
    boolean canEject(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).canEject();
    }

    @ComputerMethod
    boolean isEjecting(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).isEjecting();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setEjecting(TransmissionType type, boolean ejecting) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo config = this.configInfo.get(type);
        if (!config.canEject()) {
            throw new ComputerException("This machine does not support auto-ejecting for transmission type '%s'.", type);
        }
        if (config.isEjecting() != ejecting) {
            config.setEjecting(ejecting);
            this.tile.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    Set<DataType> getSupportedModes(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).getSupportedDataTypes();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    DataType getMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).getDataType(side);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setMode(TransmissionType type, RelativeSide side, DataType mode) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo config = this.configInfo.get(type);
        if (!config.supports(mode)) {
            throw new ComputerException("This machine does not support mode '%s' for transmission type '%s'.", mode, type);
        }
        DataType currentMode = config.getDataType(side);
        if (mode != currentMode) {
            config.setDataType(mode, side);
            this.sideChanged(type, side);
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo configInfo = this.configInfo.get(type);
        if (configInfo.getDataType(side) != configInfo.incrementDataType(side)) {
            this.sideChanged(type, side);
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo configInfo = this.configInfo.get(type);
        if (configInfo.getDataType(side) != configInfo.decrementDataType(side)) {
            this.sideChanged(type, side);
        }
    }
}

