/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.IPersistentConfigInfo;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigInfo
implements IPersistentConfigInfo {
    private final Supplier<Direction> facingSupplier;
    private boolean canEject;
    private boolean ejecting;
    private final Map<RelativeSide, DataType> sideConfig;
    private final Map<DataType, ISlotInfo> slotInfo;
    private final Map<Object, List<DataType>> containerTypeMapping;
    @Nullable
    private Set<RelativeSide> disabledSides;
    @Nullable
    private Set<DataType> supportedDataTypes;

    public ConfigInfo(@NotNull Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
        this.canEject = true;
        this.ejecting = false;
        this.sideConfig = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            this.sideConfig.put(side, DataType.NONE);
        }
        this.slotInfo = new EnumMap<DataType, ISlotInfo>(DataType.class);
        this.containerTypeMapping = new HashMap<Object, List<DataType>>();
    }

    public boolean canEject() {
        return this.canEject;
    }

    public void setCanEject(boolean canEject) {
        this.canEject = canEject;
    }

    @Override
    public boolean isEjecting() {
        return this.ejecting;
    }

    @Override
    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    public void addDisabledSides(RelativeSide ... sides) {
        if (this.disabledSides == null) {
            this.disabledSides = EnumSet.noneOf(RelativeSide.class);
        }
        for (RelativeSide side : sides) {
            this.disabledSides.add(side);
            this.sideConfig.put(side, DataType.NONE);
        }
    }

    public boolean isSideEnabled(@NotNull RelativeSide side) {
        if (this.disabledSides == null) {
            return true;
        }
        return !this.disabledSides.contains(side);
    }

    @Override
    @NotNull
    public DataType getDataType(@NotNull RelativeSide side) {
        return this.sideConfig.get(side);
    }

    public Set<Map.Entry<RelativeSide, DataType>> getSideConfig() {
        return this.sideConfig.entrySet();
    }

    @Override
    public boolean setDataType(@NotNull DataType dataType, @NotNull RelativeSide side) {
        return this.isSideEnabled(side) && this.sideConfig.put(side, dataType) != dataType;
    }

    @NotNull
    public Set<DataType> getSupportedDataTypes() {
        if (this.supportedDataTypes == null) {
            this.supportedDataTypes = EnumSet.of(DataType.NONE);
            this.supportedDataTypes.addAll(this.slotInfo.keySet());
        }
        return this.supportedDataTypes;
    }

    public boolean supports(DataType type) {
        return type == DataType.NONE || this.slotInfo.containsKey(type);
    }

    public void fill(@NotNull DataType dataType) {
        for (RelativeSide side : EnumUtils.SIDES) {
            this.setDataType(dataType, side);
        }
    }

    @Nullable
    public ISlotInfo getSlotInfo(@NotNull RelativeSide side) {
        return this.getSlotInfo(this.getDataType(side));
    }

    @Nullable
    public ISlotInfo getSlotInfo(@NotNull DataType dataType) {
        return this.slotInfo.get(dataType);
    }

    public void addSlotInfo(@NotNull DataType dataType, @NotNull ISlotInfo info) {
        block5: {
            block6: {
                block4: {
                    this.slotInfo.put(dataType, info);
                    if (this.supportedDataTypes != null) {
                        this.supportedDataTypes.add(dataType);
                    }
                    if (!(info instanceof ChemicalSlotInfo)) break block4;
                    ChemicalSlotInfo slotInfo = (ChemicalSlotInfo)info;
                    for (IChemicalTank tank : slotInfo.getTanks()) {
                        this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                    }
                    break block5;
                }
                if (!(info instanceof FluidSlotInfo)) break block6;
                FluidSlotInfo slotInfo = (FluidSlotInfo)info;
                for (IExtendedFluidTank tank : slotInfo.getTanks()) {
                    this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                }
                break block5;
            }
            if (!(info instanceof InventorySlotInfo)) break block5;
            InventorySlotInfo slotInfo = (InventorySlotInfo)info;
            for (IInventorySlot slot : slotInfo.getSlots()) {
                this.containerTypeMapping.computeIfAbsent(slot, t -> new ArrayList()).add(dataType);
            }
        }
    }

    public List<DataType> getDataTypeForContainer(Object container) {
        return this.containerTypeMapping.getOrDefault(container, new ArrayList());
    }

    public void setDefaults() {
        if (this.slotInfo.containsKey(DataType.INPUT)) {
            this.fill(DataType.INPUT);
        }
        if (this.slotInfo.containsKey(DataType.OUTPUT)) {
            this.setDataType(DataType.OUTPUT, RelativeSide.RIGHT);
        }
        if (this.slotInfo.containsKey(DataType.EXTRA)) {
            this.setDataType(DataType.EXTRA, RelativeSide.BOTTOM);
        }
        if (this.slotInfo.containsKey(DataType.ENERGY)) {
            this.setDataType(DataType.ENERGY, RelativeSide.BACK);
        }
    }

    @NotNull
    public DataType incrementDataType(@NotNull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            DataType newType = current.getNext(this::supports);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }

    @NotNull
    public DataType decrementDataType(@NotNull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            DataType newType = current.getPrevious(this::supports);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }
}

