/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.Comparator;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.lasers.ILaserDissipation;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.BlockLaserTrigger;
import mekanism.common.advancements.triggers.MekanismDamageTrigger;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketHitBlockEffect;
import mekanism.common.particle.LaserParticleData;
import mekanism.common.registries.MekanismDamageTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.ShieldBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityBasicLaser
extends TileEntityMekanism {
    protected LaserEnergyContainer energyContainer;
    @SyntheticComputerMethod(getter="getDiggingPos")
    private BlockPos digging;
    private FloatingLong diggingProgress = FloatingLong.ZERO;
    private FloatingLong lastFired = FloatingLong.ZERO;

    public TileEntityBasicLaser(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.addInitialEnergyContainers(builder, listener);
        return builder.build();
    }

    protected abstract void addInitialEnergyContainers(EnergyContainerHelper var1, IContentsListener var2);

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        FloatingLong firing = this.energyContainer.extract(this.toFire(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!firing.isZero()) {
            Pos3D to;
            Pos3D from;
            if (!firing.equals(this.lastFired) || !this.getActive()) {
                this.setActive(true);
                this.lastFired = firing;
                sendUpdatePacket = true;
            }
            Direction direction = this.getDirection();
            Level level = this.getWorldNN();
            BlockHitResult result = level.clip(new ClipContext((Vec3)(from = Pos3D.create(this).centre().translate(direction, 0.501)), (Vec3)(to = from.translate(direction, (double)MekanismConfig.general.laserRange.get() - 0.002)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (result.getType() != HitResult.Type.MISS) {
                to = new Pos3D(result.getLocation());
            }
            float laserEnergyScale = this.getEnergyScale(firing);
            FloatingLong remainingEnergy = firing.copy();
            List hitEntities = level.getEntitiesOfClass(Entity.class, Pos3D.getAABB(from, to));
            if (hitEntities.isEmpty()) {
                this.setEmittingRedstone(false);
            } else {
                this.setEmittingRedstone(true);
                Pos3D finalFrom = from;
                hitEntities.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr((Vec3)finalFrom)));
                FloatingLong energyPerDamage = (FloatingLong)MekanismConfig.general.laserEnergyPerDamage.get();
                for (Entity entity2 : hitEntities) {
                    float energyScale;
                    ItemEntity item;
                    if (entity2.isInvulnerableTo(MekanismDamageTypes.LASER.source(level))) {
                        remainingEnergy = FloatingLong.ZERO;
                        to = from.adjustPosition(direction, entity2);
                        break;
                    }
                    if (entity2 instanceof ItemEntity && this.handleHitItem(item = (ItemEntity)entity2)) continue;
                    boolean updateEnergyScale = false;
                    FloatingLong value = remainingEnergy.divide(energyPerDamage);
                    float damage = value.floatValue();
                    float health = 0.0f;
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        boolean updateDamage = false;
                        if (livingEntity.isBlocking() && livingEntity.getUseItem().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                            float damageBlocked;
                            Vec3 viewVector = livingEntity.getViewVector(1.0f);
                            Vec3 vectorTo = from.vectorTo(livingEntity.position()).normalize();
                            vectorTo = new Vec3(vectorTo.x, 0.0, vectorTo.z);
                            if (vectorTo.dot(viewVector) < 0.0 && (damageBlocked = this.damageShield(level, livingEntity, livingEntity.getUseItem(), damage, 2)) > 0.0f) {
                                if (livingEntity instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)livingEntity;
                                    ((BlockLaserTrigger)((Object)MekanismCriteriaTriggers.BLOCK_LASER.value())).trigger(player);
                                }
                                if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damageBlocked))).isZero()) {
                                    to = from.adjustPosition(direction, entity2);
                                    break;
                                }
                                updateDamage = true;
                            }
                        }
                        double dissipationPercent = 0.0;
                        double refractionPercent = 0.0;
                        for (ItemStack armor : livingEntity.getArmorSlots()) {
                            ILaserDissipation laserDissipation;
                            if (armor.isEmpty() || (laserDissipation = (ILaserDissipation)armor.getCapability(Capabilities.LASER_DISSIPATION)) == null) continue;
                            dissipationPercent += laserDissipation.getDissipationPercent();
                            refractionPercent += laserDissipation.getRefractionPercent();
                            if (!(dissipationPercent >= 1.0)) continue;
                            break;
                        }
                        if (dissipationPercent > 0.0) {
                            if ((remainingEnergy = remainingEnergy.timesEqual(FloatingLong.create(1.0 - (dissipationPercent = Math.min(dissipationPercent, 1.0))))).isZero()) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateDamage = true;
                        }
                        if (refractionPercent > 0.0) {
                            refractionPercent = Math.min(refractionPercent, 1.0);
                            FloatingLong refractedEnergy = remainingEnergy.multiply(FloatingLong.create(refractionPercent));
                            value = remainingEnergy.subtract(refractedEnergy).divide(energyPerDamage);
                            damage = value.floatValue();
                            updateDamage = false;
                            updateEnergyScale = true;
                        }
                        if (updateDamage) {
                            value = remainingEnergy.divide(energyPerDamage);
                            damage = value.floatValue();
                        }
                        health = livingEntity.getHealth();
                    }
                    if (damage > 0.0f) {
                        boolean damaged;
                        if (!entity2.fireImmune()) {
                            entity2.setSecondsOnFire(value.intValue());
                        }
                        int totemTimesUsed = -1;
                        if (entity2 instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity2;
                            MinecraftServer server = entity2.getServer();
                            if (server != null && server.isHardcore()) {
                                totemTimesUsed = player.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                            }
                        }
                        if (damaged = entity2.hurt(MekanismDamageTypes.LASER.source(level), damage)) {
                            if (entity2 instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity2;
                                damage = Math.min(damage, Math.max(0.0f, health - livingEntity.getHealth()));
                                if (entity2 instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)entity2;
                                    boolean hardcoreTotem = totemTimesUsed != -1 && totemTimesUsed < player.getStats().getValue(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING));
                                    ((MekanismDamageTrigger)((Object)MekanismCriteriaTriggers.DAMAGE.value())).trigger(player, MekanismDamageTypes.LASER, hardcoreTotem);
                                }
                            }
                            if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damage))).isZero()) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateEnergyScale = true;
                        }
                    }
                    if (!updateEnergyScale || !((double)(laserEnergyScale - (energyScale = this.getEnergyScale(remainingEnergy))) > 0.01)) continue;
                    Pos3D entityPos = from.adjustPosition(direction, entity2);
                    this.sendLaserDataToPlayers(new LaserParticleData(direction, entityPos.distance(from), laserEnergyScale), from);
                    laserEnergyScale = energyScale;
                    from = entityPos;
                }
            }
            this.sendLaserDataToPlayers(new LaserParticleData(direction, to.distance(from), laserEnergyScale), from);
            if (remainingEnergy.isZero() || result.getType() == HitResult.Type.MISS) {
                this.digging = null;
                this.diggingProgress = FloatingLong.ZERO;
            } else {
                ILaserReceptor laserReceptor;
                BlockPos hitPos = result.getBlockPos();
                if (!hitPos.equals((Object)this.digging)) {
                    this.digging = result.getType() == HitResult.Type.MISS ? null : hitPos;
                    this.diggingProgress = FloatingLong.ZERO;
                }
                if ((laserReceptor = WorldUtils.getCapability(level, Capabilities.LASER_RECEPTOR, hitPos, result.getDirection())) != null && !laserReceptor.canLasersDig()) {
                    laserReceptor.receiveLaserEnergy(remainingEnergy);
                } else {
                    BlockState hitState = level.getBlockState(hitPos);
                    float hardness = hitState.getDestroySpeed((BlockGetter)level, hitPos);
                    if (hardness >= 0.0f) {
                        this.diggingProgress = this.diggingProgress.plusEqual(remainingEnergy);
                        if (this.diggingProgress.compareTo(((FloatingLong)MekanismConfig.general.laserEnergyNeededPerHardness.get()).multiply(hardness)) >= 0) {
                            if (MekanismConfig.general.aestheticWorldDamage.get()) {
                                this.withFakePlayer((ServerLevel)level, to.x(), to.y(), to.z(), hitPos, hitState, result.getDirection());
                            }
                            this.diggingProgress = FloatingLong.ZERO;
                        } else {
                            PacketUtils.sendToAllTracking(new PacketHitBlockEffect(result), this);
                        }
                    }
                }
            }
            this.energyContainer.extract(firing, Action.EXECUTE, AutomationType.INTERNAL);
        } else if (this.getActive()) {
            this.setActive(false);
            if (!this.diggingProgress.isZero()) {
                this.diggingProgress = FloatingLong.ZERO;
            }
            if (!this.lastFired.isZero()) {
                this.lastFired = FloatingLong.ZERO;
                sendUpdatePacket = true;
            }
        }
        return sendUpdatePacket;
    }

    private void withFakePlayer(ServerLevel level, double x, double y, double z, BlockPos hitPos, BlockState hitState, Direction hitSide) {
        MekFakePlayer dummy = MekFakePlayer.setupFakePlayer(level, x, y, z);
        dummy.setEmulatingUUID(this.getOwnerUUID());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)level, hitPos, hitState, (Player)dummy);
        if (!((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            if (hitState.getBlock() instanceof TntBlock && hitState.isFlammable((BlockGetter)level, hitPos, hitSide)) {
                hitState.onCaughtFire((Level)level, hitPos, hitSide, null);
                level.removeBlock(hitPos, false);
            } else {
                this.handleBreakBlock(hitState, hitPos, (Player)dummy, ItemAtomicDisassembler.fullyChargedStack());
            }
        }
        dummy.cleanupFakePlayer(level);
    }

    private float damageShield(Level level, LivingEntity livingEntity, ItemStack activeStack, float damage, int absorptionRatio) {
        float damageBlocked = damage;
        float effectiveDamage = damage / (float)absorptionRatio;
        if (effectiveDamage >= 1.0f) {
            ShieldBlockEvent event = CommonHooks.onShieldBlock((LivingEntity)livingEntity, (DamageSource)MekanismDamageTypes.LASER.source(level), (float)effectiveDamage);
            if (event.isCanceled()) {
                return 0.0f;
            }
            if (event.shieldTakesDamage()) {
                int durabilityNeeded = 1 + Mth.floor((float)effectiveDamage);
                int activeDurability = activeStack.getMaxDamage() - activeStack.getDamageValue();
                InteractionHand hand = livingEntity.getUsedItemHand();
                activeStack.hurtAndBreak(durabilityNeeded, livingEntity, entity -> {
                    entity.broadcastBreakEvent(hand);
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)activeStack, (InteractionHand)hand);
                    }
                });
                if (activeStack.isEmpty()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        livingEntity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    } else {
                        livingEntity.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    }
                    livingEntity.stopUsingItem();
                    livingEntity.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + 0.4f * level.random.nextFloat());
                    int unblockedDamage = (durabilityNeeded - activeDurability) * absorptionRatio;
                    damageBlocked = Math.max(0.0f, damage - (float)unblockedDamage);
                }
            }
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (damageBlocked > 0.0f && damageBlocked < 3.4028235E37f) {
                player.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(damageBlocked * 10.0f));
            }
        }
        return damageBlocked;
    }

    private float getEnergyScale(FloatingLong energy) {
        return Math.min(energy.divide((FloatingLong)MekanismConfig.usage.laser.get()).divide(10L).floatValue(), 0.6f);
    }

    private void sendLaserDataToPlayers(LaserParticleData data, Vec3 from) {
        Object object;
        if (!this.isRemote() && (object = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.players()) {
                serverWorld.sendParticles(player, (ParticleOptions)data, true, from.x, from.y, from.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void setEmittingRedstone(boolean foundEntity) {
    }

    protected boolean handleHitItem(ItemEntity entity) {
        return false;
    }

    protected void handleBreakBlock(BlockState state, BlockPos hitPos, Player player, ItemStack tool) {
        Block.dropResources((BlockState)state, (Level)this.level, (BlockPos)hitPos, (BlockEntity)WorldUtils.getTileEntity((BlockGetter)this.level, hitPos), (Entity)player, (ItemStack)tool, (boolean)false);
        this.breakBlock(state, hitPos);
    }

    protected final void breakBlock(BlockState state, BlockPos hitPos) {
        this.level.removeBlock(hitPos, false);
        this.level.gameEvent(GameEvent.BLOCK_DESTROY, hitPos, GameEvent.Context.of(null, (BlockState)state));
        this.level.levelEvent(2001, hitPos, Block.getId((BlockState)state));
    }

    protected FloatingLong toFire() {
        return FloatingLong.MAX_VALUE;
    }

    @Override
    public void load(@NotNull CompoundTag nbt) {
        super.load(nbt);
        NBTUtils.setFloatingLongIfPresent(nbt, "lastFired", value -> {
            this.lastFired = value;
        });
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags) {
        super.saveAdditional(nbtTags);
        nbtTags.putString("lastFired", this.lastFired.toString());
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.putString("lastFired", this.lastFired.toString());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setFloatingLongIfPresent(tag, "lastFired", fired -> {
            this.lastFired = fired;
        });
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

