/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidBlock;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityElectricPump
extends TileEntityMekanism
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final int MAX_FLUID = 10000;
    private static final int BASE_OUTPUT_RATE = 256;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="buffer tank")
    public BasicFluidTank fluidTank;
    @NotNull
    private FluidStack activeType = FluidStack.EMPTY;
    public int ticksRequired = 19;
    public int operatingTicks;
    private boolean usedEnergy = false;
    private int outputRate = 256;
    private final Set<BlockPos> recurringNodes = new ObjectOpenHashSet();
    private List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> fluidHandlerAbove = Collections.emptyList();
    private MachineEnergyContainer<TileEntityElectricPump> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityElectricPump(BlockPos pos, BlockState state) {
        super(MekanismBlocks.ELECTRIC_PUMP, pos, state);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.output(10000, listener);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.drain(this.fluidTank, listener, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(listener, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectricPump)this).getLevel(), listener, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        FloatingLong energyPerTick;
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.drainTank(this.outputSlot);
        FloatingLong clientEnergyUsed = FloatingLong.ZERO;
        if (this.canFunction() && (this.fluidTank.isEmpty() || this.estimateIncrementAmount() <= this.fluidTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (!this.activeType.isEmpty()) {
                clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck()) {
                    if (clientEnergyUsed.isZero()) {
                        clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                } else {
                    this.reset();
                }
            }
        }
        boolean bl = this.usedEnergy = !clientEnergyUsed.isZero();
        if (!this.fluidTank.isEmpty()) {
            if (this.fluidHandlerAbove.isEmpty()) {
                this.fluidHandlerAbove = List.of(Capabilities.FLUID.createCache((ServerLevel)this.level, this.worldPosition.above(), Direction.DOWN));
            }
            FluidUtils.emit(this.fluidHandlerAbove, this.fluidTank, this.outputRate);
        }
        return sendUpdatePacket;
    }

    public int estimateIncrementAmount() {
        return this.fluidTank.getFluid().is((Fluid)MekanismFluids.HEAVY_WATER.getFluid()) ? MekanismConfig.general.pumpHeavyWaterAmount.get() : 1000;
    }

    private boolean suck() {
        boolean hasFilter = this.upgradeComponent.isUpgradeInstalled(Upgrade.FILTER);
        if (this.suck(this.worldPosition.relative(Direction.DOWN), hasFilter, true)) {
            return true;
        }
        ArrayList<BlockPos> tempPumpList = new ArrayList<BlockPos>(this.recurringNodes);
        Collections.shuffle(tempPumpList);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos tempPumpPos : tempPumpList) {
            if (this.suck(tempPumpPos, hasFilter, false)) {
                return true;
            }
            for (Direction orientation : EnumUtils.DIRECTIONS) {
                mutable.setWithOffset((Vec3i)tempPumpPos, orientation);
                if (!(WorldUtils.distanceBetween(this.worldPosition, (BlockPos)mutable) <= (double)MekanismConfig.general.maxPumpRange.get()) || !this.suck((BlockPos)mutable, hasFilter, true)) continue;
                return true;
            }
            this.recurringNodes.remove(tempPumpPos);
        }
        return false;
    }

    private boolean suck(BlockPos pos, boolean hasFilter, boolean addRecurring) {
        BlockState blockState;
        FluidState fluidState;
        Optional<BlockState> state = WorldUtils.getBlockState((BlockGetter)this.level, pos);
        if (state.isPresent() && !(fluidState = (blockState = state.get()).getFluidState()).isEmpty() && fluidState.isSource()) {
            Block block = blockState.getBlock();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (this.validFluid(fluidBlock.drain(this.level, pos, IFluidHandler.FluidAction.SIMULATE))) {
                    this.suck(fluidBlock.drain(this.level, pos, IFluidHandler.FluidAction.EXECUTE), pos, addRecurring);
                    return true;
                }
            } else if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                Fluid sourceFluid = fluidState.getType();
                FluidStack fluidStack = this.getOutput(sourceFluid, hasFilter);
                if (this.validFluid(fluidStack)) {
                    if (this.shouldPump(this.level, sourceFluid)) {
                        BucketItem bucket;
                        ItemStack pickedUpStack = bucketPickup.pickupBlock(null, (LevelAccessor)this.level, pos, blockState);
                        if (pickedUpStack.isEmpty()) {
                            return false;
                        }
                        Item item = pickedUpStack.getItem();
                        if (item instanceof BucketItem && !this.validFluid(fluidStack = this.getOutput(sourceFluid = (bucket = (BucketItem)item).getFluid(), hasFilter))) {
                            Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{fluidState.getType(), pos, this.level, sourceFluid});
                            return false;
                        }
                    }
                    this.suck(fluidStack, pos, addRecurring);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldPump(Level level, Fluid sourceFluid) {
        if (!MekanismConfig.general.pumpInfiniteFluidSources.get()) {
            if (sourceFluid == Fluids.WATER) {
                return !level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
            }
            if (sourceFluid == Fluids.LAVA) {
                return !level.getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION);
            }
        }
        return true;
    }

    private FluidStack getOutput(Fluid sourceFluid, boolean hasFilter) {
        if (hasFilter && sourceFluid == Fluids.WATER) {
            return MekanismFluids.HEAVY_WATER.getFluidStack(MekanismConfig.general.pumpHeavyWaterAmount.get());
        }
        return new FluidStack(sourceFluid, 1000);
    }

    private void suck(@NotNull FluidStack fluidStack, BlockPos pos, boolean addRecurring) {
        this.activeType = fluidStack.copyWithAmount(1);
        if (addRecurring) {
            pos = pos.immutable();
            this.recurringNodes.add(pos);
        }
        int amountOffered = fluidStack.getAmount();
        if (this.fluidTank.insert(fluidStack, Action.EXECUTE, AutomationType.INTERNAL).getAmount() != amountOffered) {
            this.level.gameEvent(null, GameEvent.FLUID_PICKUP, pos);
        }
    }

    private boolean validFluid(@NotNull FluidStack fluidStack) {
        if (!fluidStack.isEmpty() && (this.activeType.isEmpty() || this.activeType.isFluidEqual(fluidStack))) {
            if (this.fluidTank.isEmpty()) {
                return true;
            }
            if (this.fluidTank.isFluidEqual(fluidStack)) {
                return fluidStack.getAmount() <= this.fluidTank.getNeeded();
            }
        }
        return false;
    }

    public void reset() {
        this.activeType = FluidStack.EMPTY;
        this.recurringNodes.clear();
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags) {
        super.saveAdditional(nbtTags);
        nbtTags.putInt("progress", this.operatingTicks);
        if (!this.activeType.isEmpty()) {
            nbtTags.put("fluid", (Tag)this.activeType.writeToNBT(new CompoundTag()));
        }
        if (!this.recurringNodes.isEmpty()) {
            ListTag recurringList = new ListTag();
            for (BlockPos nodePos : this.recurringNodes) {
                recurringList.add((Object)NbtUtils.writeBlockPos((BlockPos)nodePos));
            }
            nbtTags.put("recurringNodes", (Tag)recurringList);
        }
    }

    @Override
    public void load(@NotNull CompoundTag nbt) {
        super.load(nbt);
        this.operatingTicks = nbt.getInt("progress");
        NBTUtils.setFluidStackIfPresent(nbt, "fluid", fluid -> {
            this.activeType = fluid;
        });
        if (nbt.contains("recurringNodes", 9)) {
            ListTag tagList = nbt.getList("recurringNodes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.recurringNodes.add(NbtUtils.readBlockPos((CompoundTag)tagList.getCompound(i)));
            }
        }
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        this.reset();
        player.displayClientMessage((Component)MekanismLang.PUMP_RESET.translate(), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 19);
            this.outputRate = 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityElectricPump> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    @NotNull
    public FluidStack getActiveType() {
        return this.activeType;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
        container.track(SyncableFluidStack.create(this::getActiveType, value -> {
            this.activeType = value;
        }));
    }

    @ComputerMethod(nameOverride="reset", requiresPublicSecurity=true)
    void resetPump() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }
}

