/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TileEntityFluidicPlenisher
extends TileEntityMekanism
implements IConfigurable {
    private static final EnumSet<Direction> dirs = EnumSet.complementOf(EnumSet.of(Direction.UP));
    public static final int BASE_TICKS_REQUIRED = 20;
    public static final int MAX_FLUID = 10000;
    private final Set<BlockPos> activeNodes = new ObjectLinkedOpenHashSet();
    private final Set<BlockPos> usedNodes = new ObjectOpenHashSet();
    public boolean finishedCalc;
    public int ticksRequired = 20;
    public int operatingTicks;
    private boolean usedEnergy = false;
    private MachineEnergyContainer<TileEntityFluidicPlenisher> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="buffer tank")
    public BasicFluidTank fluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityFluidicPlenisher(BlockPos pos, BlockState state) {
        super(MekanismBlocks.FLUIDIC_PLENISHER, pos, state);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.input(10000, this::isValidFluid, listener);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.fill(this.fluidTank, listener, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(listener, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFluidicPlenisher)this).getLevel(), listener, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    private boolean isValidFluid(@NotNull FluidStack stack) {
        return stack.getFluidType().canBePlacedInLevel((BlockAndTintGetter)this.getLevel(), this.worldPosition.below(), stack);
    }

    @Override
    protected boolean onUpdateServer() {
        FloatingLong energyPerTick;
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.fillTank(this.outputSlot);
        FloatingLong clientEnergyUsed = FloatingLong.ZERO;
        if (this.canFunction() && !this.fluidTank.isEmpty() && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (!this.finishedCalc) {
                clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.finishedCalc) {
                    BlockPos below = this.getBlockPos().below();
                    if (this.canReplace(below, false, false) && this.canExtractBucket() && WorldUtils.tryPlaceContainedLiquid(null, this.level, below, this.fluidTank.getFluid(), null)) {
                        this.level.gameEvent(null, GameEvent.FLUID_PLACE, below);
                        clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        this.fluidTank.extract(1000, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                } else {
                    this.doPlenish();
                }
            }
        }
        this.usedEnergy = !clientEnergyUsed.isZero();
        return sendUpdatePacket;
    }

    private boolean canExtractBucket() {
        return this.fluidTank.extract(1000, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == 1000;
    }

    private void doPlenish() {
        if (this.usedNodes.size() >= MekanismConfig.general.maxPlenisherNodes.get()) {
            this.finishedCalc = true;
            return;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (this.activeNodes.isEmpty()) {
            if (this.usedNodes.isEmpty()) {
                mutable.setWithOffset((Vec3i)this.getBlockPos(), Direction.DOWN);
                if (!this.canReplace((BlockPos)mutable, true, true)) {
                    this.finishedCalc = true;
                    return;
                }
                this.activeNodes.add(mutable.immutable());
            } else {
                this.finishedCalc = true;
                return;
            }
        }
        ObjectOpenHashSet toRemove = new ObjectOpenHashSet();
        for (BlockPos nodePos : this.activeNodes) {
            if (WorldUtils.isBlockLoaded((BlockGetter)this.level, nodePos)) {
                if (this.canReplace(nodePos, true, false) && this.canExtractBucket() && WorldUtils.tryPlaceContainedLiquid(null, this.level, nodePos, this.fluidTank.getFluid(), null)) {
                    this.level.gameEvent(null, GameEvent.FLUID_PLACE, nodePos);
                    this.fluidTank.extract(1000, Action.EXECUTE, AutomationType.INTERNAL);
                }
                for (Direction dir : dirs) {
                    mutable.setWithOffset((Vec3i)nodePos, dir);
                    if (!WorldUtils.isBlockLoaded((BlockGetter)this.level, (BlockPos)mutable) || !this.canReplace((BlockPos)mutable, true, true)) continue;
                    this.activeNodes.add(mutable.immutable());
                }
                toRemove.add(nodePos);
                break;
            }
            toRemove.add(nodePos);
        }
        this.usedNodes.addAll((Collection<BlockPos>)toRemove);
        this.activeNodes.removeAll((Collection<?>)toRemove);
    }

    private boolean canReplace(BlockPos pos, boolean checkNodes, boolean isPathfinding) {
        LiquidBlockContainer liquidBlockContainer;
        if (checkNodes && this.usedNodes.contains(pos)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        if (state.isAir()) {
            return true;
        }
        FluidState currentFluidState = state.getFluidState();
        if (!currentFluidState.isEmpty()) {
            if (currentFluidState.isSource()) {
                return isPathfinding;
            }
            return true;
        }
        FluidStack stack = this.fluidTank.getFluid();
        if (stack.isEmpty()) {
            return state.canBeReplaced() || state.getBlock() instanceof LiquidBlockContainer;
        }
        Fluid fluid = stack.getFluid();
        if (state.canBeReplaced(fluid)) {
            return true;
        }
        Block block = state.getBlock();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)this.level, pos, state, fluid);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags) {
        super.saveAdditional(nbtTags);
        nbtTags.putInt("progress", this.operatingTicks);
        nbtTags.putBoolean("finished", this.finishedCalc);
        if (!this.activeNodes.isEmpty()) {
            ListTag activeList = new ListTag();
            for (BlockPos wrapper : this.activeNodes) {
                activeList.add((Object)NbtUtils.writeBlockPos((BlockPos)wrapper));
            }
            nbtTags.put("activeNodes", (Tag)activeList);
        }
        if (!this.usedNodes.isEmpty()) {
            ListTag usedList = new ListTag();
            for (BlockPos obj : this.usedNodes) {
                usedList.add((Object)NbtUtils.writeBlockPos((BlockPos)obj));
            }
            nbtTags.put("usedNodes", (Tag)usedList);
        }
    }

    @Override
    public void load(@NotNull CompoundTag nbt) {
        int i;
        ListTag tagList;
        super.load(nbt);
        this.operatingTicks = nbt.getInt("progress");
        this.finishedCalc = nbt.getBoolean("finished");
        if (nbt.contains("activeNodes", 9)) {
            tagList = nbt.getList("activeNodes", 10);
            for (i = 0; i < tagList.size(); ++i) {
                this.activeNodes.add(NbtUtils.readBlockPos((CompoundTag)tagList.getCompound(i)));
            }
        }
        if (nbt.contains("usedNodes", 9)) {
            tagList = nbt.getList("usedNodes", 10);
            for (i = 0; i < tagList.size(); ++i) {
                this.usedNodes.add(NbtUtils.readBlockPos((CompoundTag)tagList.getCompound(i)));
            }
        }
    }

    public void reset() {
        this.activeNodes.clear();
        this.usedNodes.clear();
        this.finishedCalc = false;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        this.reset();
        player.displayClientMessage((Component)MekanismLang.PLENISHER_RESET.translate(), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 20);
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.finishedCalc, value -> {
            this.finishedCalc = value;
        }));
        container.track(SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    public MachineEnergyContainer<TileEntityFluidicPlenisher> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(nameOverride="reset", requiresPublicSecurity=true)
    void resetPlenisher() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }
}

