/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityInductionPort
extends TileEntityInductionCasing {
    private final Map<Direction, BlockEnergyCapabilityCache> energyCapabilityCaches = new EnumMap<Direction, BlockEnergyCapabilityCache>(Direction.class);

    public TileEntityInductionPort(BlockPos pos, BlockState state) {
        super(MekanismBlocks.INDUCTION_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> ((MatrixMultiblockData)this.getMultiblock()).getEnergyContainers((Direction)side));
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public void addEnergyTargetCapability(List<MultiblockData.EnergyOutputTarget> outputTargets, Direction side) {
        BlockEnergyCapabilityCache cache = this.energyCapabilityCaches.get(side);
        if (cache == null) {
            cache = BlockEnergyCapabilityCache.create((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.energyCapabilityCaches.put(side, cache);
        }
        outputTargets.add(new MultiblockData.EnergyOutputTarget(cache, this::getActive));
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.displayClientMessage((Component)MekanismLang.INDUCTION_PORT_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.InputOutput.of(oldMode, true)), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getRedstoneLevel() {
        return ((MatrixMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input.")
    boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    void setMode(boolean output) {
        this.setActive(output);
    }
}

