/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityConfigurableMachine
extends TileEntityMekanism
implements ISideConfiguration {
    public TileComponentEjector ejectorComponent;
    public final TileComponentConfig configComponent;

    public TileEntityConfigurableMachine(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent = new TileComponentConfig(this, Attribute.getOrThrow(blockProvider, AttributeSideConfig.class).supportedTypes());
    }

    @Override
    public final TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public final TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void readFromStack(ItemStack stack) {
        super.readFromStack(stack);
        ((AttachedSideConfig)stack.getData(MekanismAttachmentTypes.SIDE_CONFIG)).copyTo(this.configComponent);
        ((AttachedEjector)stack.getData(MekanismAttachmentTypes.EJECTOR)).copyTo(this.ejectorComponent);
    }

    @Override
    public void writeToStack(ItemStack stack) {
        super.writeToStack(stack);
        ((AttachedSideConfig)stack.getData(MekanismAttachmentTypes.SIDE_CONFIG)).copyFrom(this.configComponent);
        ((AttachedEjector)stack.getData(MekanismAttachmentTypes.EJECTOR)).copyFrom(this.ejectorComponent);
    }

    @Override
    public CompoundTag getConfigurationData(Player player) {
        CompoundTag data = super.getConfigurationData(player);
        this.configComponent.write(data);
        this.ejectorComponent.write(data);
        return data;
    }

    @Override
    public void setConfigurationData(Player player, CompoundTag data) {
        super.setConfigurationData(player, data);
        this.configComponent.read(data);
        this.ejectorComponent.read(data);
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.ejectorComponent.tickServer();
        return sendUpdatePacket;
    }
}

