/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.Collection;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIOComponent
extends TileEntityMekanism
implements IQIOFrequencyHolder {
    @Nullable
    private EnumColor lastColor;

    public TileEntityQIOComponent(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.frequencyComponent.track(FrequencyType.QIO, true, true, true);
    }

    @Nullable
    public EnumColor getColor() {
        return this.lastColor;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        return sendUpdatePacket |= this.onUpdateServer(this.getQIOFrequency());
    }

    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean needsUpdate;
        EnumColor prev = this.lastColor;
        this.lastColor = frequency == null ? null : frequency.getColor();
        boolean bl = needsUpdate = prev != this.lastColor;
        if (this.level.getGameTime() % 10L == 0L) {
            this.setActive(frequency != null);
        }
        return needsUpdate;
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        if (this.lastColor != null) {
            NBTUtils.writeEnum(dataMap, "color", this.lastColor);
        }
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        this.lastColor = dataMap.contains("color", 3) ? EnumColor.byIndexStatic(dataMap.getInt("color")) : null;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        if (this.lastColor != null) {
            NBTUtils.writeEnum(updateTag, "color", this.lastColor);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        EnumColor color;
        super.handleUpdateTag(tag);
        EnumColor enumColor = color = tag.contains("color", 3) ? EnumColor.byIndexStatic(tag.getInt("color")) : null;
        if (this.lastColor != color) {
            this.lastColor = color;
            WorldUtils.updateBlock(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @ComputerMethod(methodDescription="Lists public frequencies")
    Collection<QIOFrequency> getFrequencies() {
        return FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequencies();
    }

    @ComputerMethod
    boolean hasFrequency() {
        QIOFrequency frequency = this.getQIOFrequency();
        return frequency != null && frequency.isValid() && !frequency.isRemoved();
    }

    @ComputerMethod(nameOverride="getFrequency", methodDescription="Requires a frequency to be selected")
    QIOFrequency computerGetFrequency() throws ComputerException {
        QIOFrequency frequency = this.getQIOFrequency();
        if (frequency == null || !frequency.isValid() || frequency.isRemoved()) {
            throw new ComputerException("No frequency is currently selected.");
        }
        return frequency;
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a public frequency to exist")
    void setFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency == null) {
            throw new ComputerException("No public QIO frequency with name '%s' found.", name);
        }
        this.setFrequency(FrequencyType.QIO, frequency.getIdentity(), this.getOwnerUUID());
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires frequency to not already exist and for it to be public so that it can make it as the player who owns the block. Also sets the frequency after creation")
    void createFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = FrequencyType.QIO.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency != null) {
            throw new ComputerException("Unable to create public QIO frequency with name '%s' as one already exists.", name);
        }
        this.setFrequency(FrequencyType.QIO, new Frequency.FrequencyIdentity(name, SecurityMode.PUBLIC, this.getOwnerUUID()), this.getOwnerUUID());
    }

    @ComputerMethod(methodDescription="Requires a frequency to be selected")
    EnumColor getFrequencyColor() throws ComputerException {
        return this.computerGetFrequency().getColor();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void setFrequencyColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.computerGetFrequency().setColor(color);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void incrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = this.computerGetFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getNext());
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires a frequency to be selected")
    void decrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        QIOFrequency frequency = this.computerGetFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getPrevious());
    }
}

