/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIODashboard
extends TileEntityQIOComponent
implements IQIOCraftingWindowHolder {
    private QIOCraftingWindow[] craftingWindows;
    private boolean insertIntoFrequency = true;
    private boolean recipesChecked = false;

    public TileEntityQIODashboard(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_DASHBOARD, pos, state);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.craftingWindows = new QIOCraftingWindow[3];
        for (byte tableIndex = 0; tableIndex < this.craftingWindows.length; tableIndex = (byte)(tableIndex + 1)) {
            this.craftingWindows[tableIndex] = new QIOCraftingWindow(this, tableIndex);
        }
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.readOnly();
        for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
            for (int slot = 0; slot < 9; ++slot) {
                builder.addSlot(craftingWindow.getInputSlot(slot));
            }
            builder.addSlot(craftingWindow.getOutputSlot());
        }
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean needsUpdate = super.onUpdateServer(frequency);
        if (CommonWorldTickHandler.flushTagAndRecipeCaches || !this.recipesChecked) {
            this.recipesChecked = true;
            for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
                craftingWindow.invalidateRecipe();
            }
        }
        return needsUpdate;
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        return this.getQIOFrequency();
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        dataMap.putBoolean("insert_into_frequency", this.insertIntoFrequency);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "insert_into_frequency", value -> {
            this.insertIntoFrequency = value;
        });
    }

    @Override
    public Map<String, Holder<AttachmentType<?>>> getTileDataAttachmentRemap() {
        Map<String, Holder<AttachmentType<?>>> remap = super.getTileDataAttachmentRemap();
        remap.put("insert_into_frequency", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.INSERT_INTO_FREQUENCY);
        return remap;
    }

    @Override
    public void writeToStack(ItemStack stack) {
        super.writeToStack(stack);
        stack.setData(MekanismAttachmentTypes.INSERT_INTO_FREQUENCY, (Object)this.insertIntoFrequency);
    }

    @Override
    public void readFromStack(ItemStack stack) {
        super.readFromStack(stack);
        this.insertIntoFrequency = (Boolean)stack.getData(MekanismAttachmentTypes.INSERT_INTO_FREQUENCY);
    }

    public boolean shiftClickIntoFrequency() {
        return this.insertIntoFrequency;
    }

    public void toggleShiftClickDirection() {
        this.insertIntoFrequency = !this.insertIntoFrequency;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::shiftClickIntoFrequency, value -> {
            this.insertIntoFrequency = value;
        }));
    }

    private void validateWindow(int window) throws ComputerException {
        if (window < 0 || window >= this.craftingWindows.length) {
            throw new ComputerException("Window '%d' is out of bounds, must be between 0 and %d.", window, this.craftingWindows.length);
        }
    }

    @ComputerMethod
    ItemStack getCraftingInput(int window, int slot) throws ComputerException {
        this.validateWindow(window);
        if (slot < 0 || slot >= 9) {
            throw new ComputerException("Slot '%d' is out of bounds, must be between 0 and 9.", slot);
        }
        return this.craftingWindows[window].getInputSlot(slot).getStack();
    }

    @ComputerMethod
    ItemStack getCraftingOutput(int window) throws ComputerException {
        this.validateWindow(window);
        return this.craftingWindows[window].getOutputSlot().getStack();
    }
}

