/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.Collection;
import mekanism.api.Upgrade;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityQIOFilterHandler
extends TileEntityQIOComponent
implements ITileFilterHolder<QIOFilter<?>> {
    private final SortableFilterManager<QIOFilter<?>> filterManager = new SortableFilterManager<QIOFilter>(QIOFilter.class, this::markForSave);
    private int maxTransitCount = 64;
    private int maxTransitTypes = 1;

    public TileEntityQIOFilterHandler(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    public SortableFilterManager<QIOFilter<?>> getFilterManager() {
        return this.filterManager;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            int speedUpgrades = this.upgradeComponent.getUpgrades(Upgrade.SPEED);
            this.maxTransitCount = 64 + 32 * speedUpgrades;
            this.maxTransitTypes = Math.round(1.0f + (float)speedUpgrades / 2.0f);
        }
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        this.filterManager.writeToNBT(dataMap);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        this.filterManager.readFromNBT(dataMap);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.filterManager.addContainerTrackers(container);
    }

    protected int getMaxTransitCount() {
        return this.maxTransitCount;
    }

    protected int getMaxTransitTypes() {
        return this.maxTransitTypes;
    }

    @ComputerMethod
    Collection<QIOFilter<?>> getFilters() {
        return this.filterManager.getFilters();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean addFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.addFilter(filter);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean removeFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.removeFilter(filter);
    }
}

