/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIOImporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private final Predicate<ItemStack> FILTER_ENABLED = stack -> this.getFilterManager().anyEnabledMatch(stack, (filter, s) -> filter.getFinder().test(s));
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> backInventory;
    private int delay = 0;
    private boolean importWithoutFilter = true;

    public TileEntityQIOImporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_IMPORTER, pos, state);
    }

    @Override
    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean needsUpdate = super.onUpdateServer(frequency);
        if (frequency != null && this.canFunction()) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.tryImport(frequency);
                this.delay = 10;
            }
        }
        return needsUpdate;
    }

    @Override
    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.backInventory = null;
    }

    private void tryImport(QIOFrequency freq) {
        Predicate<Object> canFilter;
        IItemHandler inventory;
        if (this.backInventory == null) {
            Direction direction = this.getDirection();
            this.backInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.worldPosition.relative(direction.getOpposite()), direction);
        }
        if ((inventory = (IItemHandler)this.backInventory.getCapability()) == null) {
            return;
        }
        if (this.getFilterManager().hasEnabledFilters()) {
            canFilter = this.FILTER_ENABLED;
        } else if (this.importWithoutFilter) {
            canFilter = ConstantPredicates.alwaysTrue();
        } else {
            return;
        }
        int slots = inventory.getSlots();
        if (slots == 0) {
            return;
        }
        HashSet<HashedItem> typesAdded = new HashSet<HashedItem>();
        int maxTypes = this.getMaxTransitTypes();
        int maxCount = this.getMaxTransitCount();
        int countAdded = 0;
        for (int i = slots - 1; i >= 0; --i) {
            ItemStack ret;
            HashedItem type;
            ItemStack stack = inventory.extractItem(i, maxCount - countAdded, true);
            if (stack.isEmpty() || !typesAdded.contains(type = HashedItem.create(stack)) && typesAdded.size() == maxTypes || !canFilter.test(stack)) continue;
            ItemStack used = TransporterManager.getToUse(stack, freq.addItem(stack));
            if (!InventoryUtils.areItemsStackable(used, ret = inventory.extractItem(i, used.getCount(), false)) || used.getCount() != ret.getCount()) {
                Mekanism.logger.error("QIO insertion error: item handler at {} in {} returned {} during simulated extraction, but returned {} during execution. This is wrong!", new Object[]{this.worldPosition.relative(this.getOppositeDirection()), this.level.dimension().location(), stack, ret});
            }
            typesAdded.add(type);
            countAdded += used.getCount();
        }
    }

    @ComputerMethod
    public boolean getImportWithoutFilter() {
        return this.importWithoutFilter;
    }

    public void toggleImportWithoutFilter() {
        this.importWithoutFilter = !this.importWithoutFilter;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getImportWithoutFilter, value -> {
            this.importWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        dataMap.putBoolean("auto", this.importWithoutFilter);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "auto", value -> {
            this.importWithoutFilter = value;
        });
    }

    @Override
    public Map<String, Holder<AttachmentType<?>>> getTileDataAttachmentRemap() {
        Map<String, Holder<AttachmentType<?>>> remap = super.getTileDataAttachmentRemap();
        remap.put("auto", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.AUTO);
        return remap;
    }

    @Override
    public void writeToStack(ItemStack stack) {
        super.writeToStack(stack);
        stack.setData(MekanismAttachmentTypes.AUTO, (Object)this.importWithoutFilter);
    }

    @Override
    public void readFromStack(ItemStack stack) {
        super.readFromStack(stack);
        this.importWithoutFilter = (Boolean)stack.getData(MekanismAttachmentTypes.AUTO);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setImportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.importWithoutFilter != value) {
            this.toggleImportWithoutFilter();
        }
    }
}

