/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.Map;
import mekanism.client.model.data.DataBasedModelLoader;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIORedstoneAdapter
extends TileEntityQIOComponent {
    @Nullable
    private HashedItem itemType = null;
    private boolean fuzzy;
    private boolean inverted;
    private long count = 0L;
    private long clientStoredCount = 0L;
    private boolean isEmitting;

    public TileEntityQIORedstoneAdapter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_REDSTONE_ADAPTER, pos, state);
    }

    public int getRedstoneLevel(Direction side) {
        return side != this.getOppositeDirection() && this.getActive() && this.isEmitting ? 15 : 0;
    }

    private long getFreqStored() {
        return this.getStored(this.getQIOFrequency());
    }

    private long getStored(@Nullable QIOFrequency freq) {
        if (freq == null || this.itemType == null) {
            return 0L;
        }
        if (this.fuzzy) {
            return freq.getTypesForItem(this.itemType.getItem()).stream().mapToLong(freq::getStoredByHash).sum();
        }
        return freq.getStoredByHash(this.itemType);
    }

    public void handleStackChange(ItemStack stack) {
        this.itemType = stack.isEmpty() ? null : HashedItem.create(stack);
        this.markForSave();
    }

    public void handleCountChange(long count) {
        if (this.count != count) {
            this.count = count;
            this.markForSave();
        }
    }

    public void toggleFuzzyMode() {
        this.setFuzzyMode(!this.fuzzy);
    }

    private void setFuzzyMode(boolean fuzzy) {
        if (this.fuzzy != fuzzy) {
            this.fuzzy = fuzzy;
            this.markForSave();
        }
    }

    public void invertSignal() {
        this.setSignalInverted(!this.inverted);
    }

    private void setSignalInverted(boolean inverted) {
        if (this.inverted != inverted) {
            this.inverted = inverted;
            this.markForSave();
        }
    }

    @Override
    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean shouldEmit;
        boolean needsUpdate = super.onUpdateServer(frequency);
        long stored = this.getStored(frequency);
        boolean hasStored = stored > 0L && stored >= this.count;
        boolean bl = shouldEmit = hasStored != this.inverted;
        if (this.isEmitting != shouldEmit) {
            this.isEmitting = shouldEmit;
            needsUpdate = true;
            this.level.updateNeighborsAtExceptFromFacing(this.getBlockPos(), this.getBlockType(), this.getOppositeDirection());
        }
        return needsUpdate;
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        if (this.itemType != null) {
            dataMap.put("singleItem", (Tag)this.itemType.internalToNBT());
        }
        dataMap.putLong("amount", this.count);
        dataMap.putBoolean("fuzzyMode", this.fuzzy);
        dataMap.putBoolean("inverse", this.inverted);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setItemStackIfPresent(dataMap, "singleItem", item -> {
            this.itemType = HashedItem.create(item);
        });
        NBTUtils.setLongIfPresent(dataMap, "amount", value -> {
            this.count = value;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "fuzzyMode", value -> {
            this.fuzzy = value;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "inverse", value -> {
            this.inverted = value;
        });
    }

    @NotNull
    public ModelData getModelData() {
        if (this.isEmitting) {
            return ModelData.builder().with(DataBasedModelLoader.EMITTING, null).build();
        }
        return super.getModelData();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.putBoolean("emitting", this.isEmitting);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        boolean emitting = tag.getBoolean("emitting");
        if (this.isEmitting != emitting) {
            this.isEmitting = emitting;
            this.updateModelData();
        }
    }

    @Override
    public Map<String, Holder<AttachmentType<?>>> getTileDataAttachmentRemap() {
        Map<String, Holder<AttachmentType<?>>> remap = super.getTileDataAttachmentRemap();
        remap.put("singleItem", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.ITEM_TARGET);
        remap.put("amount", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.LONG_AMOUNT);
        remap.put("fuzzyMode", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.FUZZY);
        remap.put("inverse", (Holder<AttachmentType<?>>)MekanismAttachmentTypes.INVERSE);
        return remap;
    }

    @Override
    public void writeToStack(ItemStack stack) {
        super.writeToStack(stack);
        if (this.itemType != null) {
            stack.setData(MekanismAttachmentTypes.ITEM_TARGET, (Object)this.itemType.getInternalStack());
        }
        stack.setData(MekanismAttachmentTypes.LONG_AMOUNT, (Object)this.count);
        stack.setData(MekanismAttachmentTypes.FUZZY, (Object)this.fuzzy);
        stack.setData(MekanismAttachmentTypes.INVERSE, (Object)this.inverted);
    }

    @Override
    public void readFromStack(ItemStack stack) {
        super.readFromStack(stack);
        this.itemType = stack.getExistingData(MekanismAttachmentTypes.ITEM_TARGET).filter(type -> !type.isEmpty()).map(HashedItem::create).orElse(null);
        this.count = (Long)stack.getData(MekanismAttachmentTypes.LONG_AMOUNT);
        this.fuzzy = (Boolean)stack.getData(MekanismAttachmentTypes.FUZZY);
        this.inverted = (Boolean)stack.getData(MekanismAttachmentTypes.INVERSE);
    }

    @ComputerMethod(nameOverride="getTargetItem")
    public ItemStack getItemType() {
        return this.itemType == null ? ItemStack.EMPTY : this.itemType.getInternalStack();
    }

    @ComputerMethod(nameOverride="getTriggerAmount")
    public long getCount() {
        return this.count;
    }

    @ComputerMethod
    public boolean getFuzzyMode() {
        return this.fuzzy;
    }

    @ComputerMethod
    public boolean isInverted() {
        return this.inverted;
    }

    public long getStoredCount() {
        return this.clientStoredCount;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableItemStack.create(this::getItemType, value -> {
            this.itemType = value.isEmpty() ? null : HashedItem.create(value);
        }));
        container.track(SyncableLong.create(this::getCount, value -> {
            this.count = value;
        }));
        container.track(SyncableBoolean.create(this::getFuzzyMode, value -> {
            this.fuzzy = value;
        }));
        container.track(SyncableBoolean.create(this::isInverted, value -> {
            this.inverted = value;
        }));
        container.track(SyncableLong.create(this::getFreqStored, value -> {
            this.clientStoredCount = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearTargetItem() throws ComputerException {
        this.validateSecurityIsPublic();
        this.handleStackChange(ItemStack.EMPTY);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setTargetItem(ResourceLocation itemName) throws ComputerException {
        this.validateSecurityIsPublic();
        Item item = (Item)BuiltInRegistries.ITEM.get(itemName);
        if (item == Items.AIR) {
            throw new ComputerException("Target item '%s' could not be found. If you are trying to clear it consider using clearTargetItem instead.", itemName);
        }
        this.handleStackChange(new ItemStack((ItemLike)item));
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setTriggerAmount(long amount) throws ComputerException {
        this.validateSecurityIsPublic();
        if (amount < 0L) {
            throw new ComputerException("Trigger amount cannot be negative. Received: %d", amount);
        }
        this.handleCountChange(amount);
    }

    @ComputerMethod(nameOverride="toggleFuzzyMode", requiresPublicSecurity=true)
    void computerToggleFuzzyMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.toggleFuzzyMode();
    }

    @ComputerMethod(nameOverride="setFuzzyMode", requiresPublicSecurity=true)
    void computerSetFuzzyMode(boolean fuzzy) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setFuzzyMode(fuzzy);
    }

    @ComputerMethod(nameOverride="invertSignal", requiresPublicSecurity=true)
    void computerInvertSignal() throws ComputerException {
        this.validateSecurityIsPublic();
        this.invertSignal();
    }

    @ComputerMethod(nameOverride="setSignalInverted", requiresPublicSecurity=true)
    void computerSetSignalInverted(boolean inverted) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setSignalInverted(inverted);
    }
}

