/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.DynamicFluidHandler;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter
implements IComputerTile {
    private final FluidHandlerManager fluidHandlerManager = new FluidHandlerManager(direction -> {
        MechanicalPipe pipe = this.getTransmitter();
        if (direction != null && pipe.getConnectionTypeRaw(direction) == ConnectionType.NONE || pipe.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return pipe.getFluidTanks(direction);
    }, new DynamicFluidHandler(this::getFluidTanks, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityMechanicalPipe(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(this.fluidHandlerManager);
    }

    protected MechanicalPipe createTransmitter(IBlockProvider blockProvider) {
        return new MechanicalPipe(blockProvider, this);
    }

    public MechanicalPipe getTransmitter() {
        return (MechanicalPipe)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_MECHANICAL_PIPE;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_MECHANICAL_PIPE;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_MECHANICAL_PIPE;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_MECHANICAL_PIPE;
            default -> null;
        });
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag updateTag = super.getUpdateTag();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.put("fluid", (Tag)network.lastFluid.writeToNBT(new CompoundTag()));
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.FLUID.block(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilityAll(Capabilities.FLUID.block());
        } else {
            this.invalidateCapabilities();
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "MechanicalPipe";
    }

    @ComputerMethod
    FluidStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        MechanicalPipe pipe = this.getTransmitter();
        return pipe.hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitterNetwork()).getCapacity() : pipe.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - (long)this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

