/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.dynamic.DynamicChemicalHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPressurizedTube
extends TileEntityTransmitter
implements IComputerTile,
ITileRadioactive {
    private static final Collection<BlockCapability<?, @Nullable Direction>> CAPABILITIES = Set.of(Capabilities.GAS.block(), Capabilities.INFUSION.block(), Capabilities.PIGMENT.block(), Capabilities.SLURRY.block());
    private final ChemicalHandlerManager.GasHandlerManager gasHandlerManager;
    private final ChemicalHandlerManager.InfusionHandlerManager infusionHandlerManager;
    private final ChemicalHandlerManager.PigmentHandlerManager pigmentHandlerManager;
    private final ChemicalHandlerManager.SlurryHandlerManager slurryHandlerManager;

    public TileEntityPressurizedTube(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        Predicate<@Nullable Direction> canExtract = this.getExtractPredicate();
        Predicate<@Nullable Direction> canInsert = this.getInsertPredicate();
        this.gasHandlerManager = new ChemicalHandlerManager.GasHandlerManager(this.getHolder(BoxedPressurizedTube::getGasTanks), new DynamicChemicalHandler.DynamicGasHandler(this::getGasTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.gasHandlerManager);
        this.infusionHandlerManager = new ChemicalHandlerManager.InfusionHandlerManager(this.getHolder(BoxedPressurizedTube::getInfusionTanks), new DynamicChemicalHandler.DynamicInfusionHandler(this::getInfusionTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.infusionHandlerManager);
        this.pigmentHandlerManager = new ChemicalHandlerManager.PigmentHandlerManager(this.getHolder(BoxedPressurizedTube::getPigmentTanks), new DynamicChemicalHandler.DynamicPigmentHandler(this::getPigmentTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.pigmentHandlerManager);
        this.slurryHandlerManager = new ChemicalHandlerManager.SlurryHandlerManager(this.getHolder(BoxedPressurizedTube::getSlurryTanks), new DynamicChemicalHandler.DynamicSlurryHandler(this::getSlurryTanks, canExtract, canInsert, null));
        this.addCapabilityResolver(this.slurryHandlerManager);
    }

    protected BoxedPressurizedTube createTransmitter(IBlockProvider blockProvider) {
        return new BoxedPressurizedTube(blockProvider, this);
    }

    public BoxedPressurizedTube getTransmitter() {
        return (BoxedPressurizedTube)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_PRESSURIZED_TUBE;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_PRESSURIZED_TUBE;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_PRESSURIZED_TUBE;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE;
            default -> null;
        });
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag updateTag = super.getUpdateTag();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.put("boxedChemical", (Tag)network.lastChemical.write(new CompoundTag()));
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> IChemicalTankHolder<CHEMICAL, STACK, TANK> getHolder(BiFunction<BoxedPressurizedTube, Direction, List<TANK>> tankFunction) {
        return direction -> {
            BoxedPressurizedTube tube = this.getTransmitter();
            if (direction != null && tube.getConnectionTypeRaw(direction) == ConnectionType.NONE || tube.isRedstoneActivated()) {
                return Collections.emptyList();
            }
            return (List)tankFunction.apply(tube, direction);
        };
    }

    @Override
    public float getRadiationScale() {
        if (IRadiationManager.INSTANCE.isRadiationEnabled()) {
            BoxedPressurizedTube tube = this.getTransmitter();
            if (this.isRemote()) {
                if (tube.hasTransmitterNetwork()) {
                    BoxedChemicalNetwork network = (BoxedChemicalNetwork)tube.getTransmitterNetwork();
                    if (!network.lastChemical.isEmpty() && !network.isTankEmpty() && network.lastChemical.getChemical().isRadioactive()) {
                        return network.currentScale;
                    }
                }
            } else {
                IGasTank gasTank = tube.getGasTank();
                if (!gasTank.isEmpty() && ((GasStack)gasTank.getStack()).isRadioactive()) {
                    return (float)gasTank.getStored() / (float)gasTank.getCapacity();
                }
            }
        }
        return 0.0f;
    }

    @Override
    public int getRadiationParticleCount() {
        return MathUtils.clampToInt(3.0f * this.getRadiationScale());
    }

    private List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasHandlerManager.getContainers(side);
    }

    private List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionHandlerManager.getContainers(side);
    }

    private List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentHandlerManager.getContainers(side);
    }

    private List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(CAPABILITIES, side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilitiesAll(CAPABILITIES);
        } else {
            this.invalidateCapabilities();
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "PressurizedTube";
    }

    @ComputerMethod
    ChemicalStack<?> getBuffer() {
        return this.getTransmitter().getBufferWithFallback().getChemicalStack();
    }

    @ComputerMethod
    long getCapacity() {
        BoxedPressurizedTube tube = this.getTransmitter();
        return tube.hasTransmitterNetwork() ? ((BoxedChemicalNetwork)tube.getTransmitterNetwork()).getCapacity() : tube.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

