/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfuseTypeBuilder;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentBuilder;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.AttachedChemicalTanks;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.MultiTypeCapability;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.ItemCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalUtil {
    private ChemicalUtil() {
    }

    public static MultiTypeCapability<? extends IChemicalHandler<?, ?>> getCapabilityForChemical(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> Capabilities.GAS;
            case ChemicalType.INFUSION -> Capabilities.INFUSION;
            case ChemicalType.PIGMENT -> Capabilities.PIGMENT;
            case ChemicalType.SLURRY -> Capabilities.SLURRY;
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, ?>> MultiTypeCapability<HANDLER> getCapabilityForChemical(CHEMICAL chemical) {
        return ChemicalUtil.getCapabilityForChemical(ChemicalType.getTypeFor(chemical));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> MultiTypeCapability<HANDLER> getCapabilityForChemical(STACK stack) {
        return ChemicalUtil.getCapabilityForChemical(stack.getType());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> MultiTypeCapability<HANDLER> getCapabilityForChemical(IChemicalTank<CHEMICAL, STACK> tank) {
        return ChemicalUtil.getCapabilityForChemical(tank.getEmptyStack());
    }

    public static ChemicalStack<?> getEmptyStack(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> GasStack.EMPTY;
            case ChemicalType.INFUSION -> InfusionStack.EMPTY;
            case ChemicalType.PIGMENT -> PigmentStack.EMPTY;
            case ChemicalType.SLURRY -> SlurryStack.EMPTY;
        };
    }

    public static <STACK extends ChemicalStack<?>> STACK getEmptyStack(STACK stack) {
        if (stack instanceof GasStack) {
            return (STACK)GasStack.EMPTY;
        }
        if (stack instanceof InfusionStack) {
            return (STACK)InfusionStack.EMPTY;
        }
        if (stack instanceof PigmentStack) {
            return (STACK)PigmentStack.EMPTY;
        }
        if (stack instanceof SlurryStack) {
            return (STACK)SlurryStack.EMPTY;
        }
        throw new IllegalStateException("Unknown Chemical Type: " + stack.getType().getClass().getName());
    }

    public static boolean compareTypes(ChemicalType chemicalType, MergedChemicalTank.Current current) {
        return current == (switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> MergedChemicalTank.Current.GAS;
            case ChemicalType.INFUSION -> MergedChemicalTank.Current.INFUSION;
            case ChemicalType.PIGMENT -> MergedChemicalTank.Current.PIGMENT;
            case ChemicalType.SLURRY -> MergedChemicalTank.Current.SLURRY;
        });
    }

    public static <STACK extends ChemicalStack<?>> STACK copy(STACK stack) {
        return (STACK)stack.copy();
    }

    public static <STACK extends ChemicalStack<?>> STACK copyWithAmount(STACK stack, long amount) {
        if (stack.isEmpty() || amount <= 0L) {
            return ChemicalUtil.getEmptyStack(stack);
        }
        STACK result = ChemicalUtil.copy(stack);
        result.setAmount(amount);
        return result;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK withAmount(IChemicalProvider<CHEMICAL> provider, long amount) {
        return (STACK)provider.getStack(amount);
    }

    public static ItemStack getFullChemicalTank(ChemicalTankTier tier, @NotNull Chemical<?> chemical) {
        return ChemicalUtil.getFilledVariant(ChemicalUtil.getEmptyChemicalTank(tier), chemical);
    }

    private static ItemStack getEmptyChemicalTank(ChemicalTankTier tier) {
        return (switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalTankTier.BASIC -> MekanismBlocks.BASIC_CHEMICAL_TANK;
            case ChemicalTankTier.ADVANCED -> MekanismBlocks.ADVANCED_CHEMICAL_TANK;
            case ChemicalTankTier.ELITE -> MekanismBlocks.ELITE_CHEMICAL_TANK;
            case ChemicalTankTier.ULTIMATE -> MekanismBlocks.ULTIMATE_CHEMICAL_TANK;
            case ChemicalTankTier.CREATIVE -> MekanismBlocks.CREATIVE_CHEMICAL_TANK;
        }).getItemStack();
    }

    public static ItemStack getFilledVariant(ItemStack toFill, IChemicalProvider<?> provider) {
        if (provider instanceof IGasProvider) {
            IGasProvider gasProvider = (IGasProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, gasProvider, ContainerType.GAS);
        }
        if (provider instanceof IInfuseTypeProvider) {
            IInfuseTypeProvider infuseTypeProvider = (IInfuseTypeProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, infuseTypeProvider, ContainerType.INFUSION);
        }
        if (provider instanceof IPigmentProvider) {
            IPigmentProvider pigmentProvider = (IPigmentProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, pigmentProvider, ContainerType.PIGMENT);
        }
        if (provider instanceof ISlurryProvider) {
            ISlurryProvider slurryProvider = (ISlurryProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, slurryProvider, ContainerType.SLURRY);
        }
        throw new IllegalStateException("Unknown Chemical Type: " + provider.getChemical().getClass().getName());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> ItemStack getFilledVariant(ItemStack toFill, IChemicalProvider<CHEMICAL> provider, ContainerType<TANK, ? extends AttachedChemicalTanks<CHEMICAL, STACK, TANK>, ?> containerType) {
        AttachedChemicalTanks<CHEMICAL, STACK, TANK> attachment = containerType.getAttachment((IAttachmentHolder)toFill);
        if (attachment != null) {
            for (IChemicalTank tank : attachment.getChemicalTanks(null)) {
                tank.setStack(ChemicalUtil.withAmount(provider, tank.getCapacity()));
            }
        }
        return toFill;
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack gasStack = StorageUtils.getStoredGasFromAttachment(stack);
        if (!gasStack.isEmpty()) {
            return gasStack.getChemicalColorRepresentation();
        }
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromAttachment(stack);
        if (!infusionStack.isEmpty()) {
            return infusionStack.getChemicalColorRepresentation();
        }
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromAttachment(stack);
        if (!pigmentStack.isEmpty()) {
            return pigmentStack.getChemicalColorRepresentation();
        }
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromAttachment(stack);
        if (!slurryStack.isEmpty()) {
            return slurryStack.getChemicalColorRepresentation();
        }
        return 0;
    }

    public static boolean hasGas(ItemStack stack) {
        return ChemicalUtil.hasChemical(stack, ConstantPredicates.alwaysTrue(), Capabilities.GAS.item());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean hasChemical(ItemStack stack, CHEMICAL type) {
        MultiTypeCapability capability = ChemicalUtil.getCapabilityForChemical(type);
        return ChemicalUtil.hasChemical(stack, s -> s.isTypeEqual(type), capability.item());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean hasChemical(ItemStack stack, Predicate<STACK> validityCheck, ItemCapability<HANDLER, Void> capability) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(capability);
        if (handler != null) {
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalStack).isEmpty() || !validityCheck.test(chemicalStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAttributeTooltips(List<Component> tooltips, Chemical<?> chemical) {
        for (ChemicalAttribute attr : chemical.getAttributes()) {
            attr.addTooltipText(tooltips);
        }
    }

    public static void addChemicalDataToTooltip(List<Component> tooltips, Chemical<?> chemical, boolean advanced) {
        if (!chemical.isEmptyType()) {
            Gas gas;
            ChemicalUtil.addAttributeTooltips(tooltips, chemical);
            if (chemical instanceof Gas && (gas = (Gas)chemical).is(MekanismTags.Gases.WASTE_BARREL_DECAY_BLACKLIST)) {
                tooltips.add((Component)MekanismLang.DECAY_IMMUNE.translateColored(EnumColor.AQUA));
            }
            if (advanced) {
                tooltips.add((Component)TextComponentUtil.build(ChatFormatting.DARK_GRAY, chemical.getRegistryName()));
            }
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void emit(Collection<BlockCapabilityCache<HANDLER, @Nullable Direction>> targets, IChemicalTank<CHEMICAL, STACK> tank) {
        ChemicalUtil.emit(targets, tank, tank.getCapacity());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void emit(Collection<BlockCapabilityCache<HANDLER, @Nullable Direction>> targets, IChemicalTank<CHEMICAL, STACK> tank, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(ChemicalUtil.emit(targets, tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL)), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> long emit(Collection<BlockCapabilityCache<HANDLER, @Nullable Direction>> targets, @NotNull STACK stack) {
        if (stack.isEmpty() || targets.isEmpty()) {
            return 0L;
        }
        ChemicalHandlerTarget target = new ChemicalHandlerTarget(stack, targets.size());
        for (BlockCapabilityCache<HANDLER, Direction> capability : targets) {
            IChemicalHandler handler = (IChemicalHandler)capability.getCapability();
            if (handler == null || !ChemicalUtil.canInsert(handler, stack)) continue;
            target.addHandler(handler);
        }
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, stack.getAmount(), ChemicalUtil.copy(stack));
        }
        return 0L;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean canInsert(HANDLER handler, @NotNull STACK stack) {
        return ((ChemicalStack)handler.insertChemical(stack, Action.SIMULATE)).getAmount() < stack.getAmount();
    }

    public static Gas gas(GasBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new Gas(builder);
        }
        final int color = colorRepresentation;
        return new Gas(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }

    public static InfuseType infuseType(InfuseTypeBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new InfuseType(builder);
        }
        final int color = colorRepresentation;
        return new InfuseType(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }

    public static Pigment pigment(PigmentBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new Pigment(builder);
        }
        final int color = colorRepresentation;
        return new Pigment(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }

    public static Slurry slurry(SlurryBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new Slurry(builder);
        }
        final int color = colorRepresentation;
        return new Slurry(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }
}

