/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.interfaces.IDroppableContents;
import mekanism.common.lib.inventory.HandlerTransitRequest;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dropItemContents(ItemEntity entity, DamageSource source) {
        IModuleContainer moduleContainer;
        Player player;
        ItemStack stack = entity.getItem();
        Level level = entity.level();
        if (level.isClientSide || stack.isEmpty()) return;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof Player ? !IItemSecurityUtils.INSTANCE.canAccess(player = (Player)entity2, stack) : !IItemSecurityUtils.INSTANCE.canAccess(null, stack, false)) {
            return;
        }
        int scalar = stack.getCount();
        BlockPos blockPos = entity.blockPosition();
        ItemDropper dropper = (lvl, pos, ignored, slotStack) -> lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), slotStack));
        Item item = stack.getItem();
        if (item instanceof IDroppableContents) {
            IDroppableContents inventory = (IDroppableContents)item;
            if (!inventory.canContentsDrop(stack)) return;
            scalar = inventory.getScalar(stack);
            InventoryUtils.dropItemContents(level, blockPos, inventory.getDroppedSlots(stack), scalar, dropper);
        } else if (ContainerType.ITEM.supports(stack)) {
            InventoryUtils.dropItemContents(level, blockPos, ContainerType.ITEM.getAttachmentContainersIfPresent((IAttachmentHolder)stack), scalar, dropper);
        }
        Optional existingUpgrades = stack.getExistingData(MekanismAttachmentTypes.UPGRADES);
        if (existingUpgrades.isPresent()) {
            UpgradeAware upgradeAware = (UpgradeAware)existingUpgrades.get();
            InventoryUtils.dropItemContents(level, blockPos, upgradeAware.getInventorySlots(null), scalar, dropper);
            InventoryUtils.dropItemContents(level, blockPos, upgradeAware.getUpgrades().entrySet(), scalar, dropper, entry -> UpgradeUtils.getStack((Upgrade)entry.getKey(), (Integer)entry.getValue()));
        }
        if ((moduleContainer = IModuleHelper.INSTANCE.getModuleContainerNullable(stack)) == null) return;
        InventoryUtils.dropItemContents(level, blockPos, moduleContainer.modules(), scalar, dropper, module -> module.getData().getItemProvider().getItemStack(module.getInstalledCount()));
    }

    private static void dropItemContents(Level level, BlockPos pos, List<IInventorySlot> slots, int scalar, ItemDropper dropper) {
        InventoryUtils.dropItemContents(level, pos, slots, scalar, dropper, slot -> slot.getStack().copy());
    }

    private static <T> void dropItemContents(Level level, BlockPos pos, Collection<T> toDrop, int scalar, ItemDropper dropper, Function<T, ItemStack> stackExtractor) {
        for (T drop : toDrop) {
            ItemStack stackToDrop = stackExtractor.apply(drop);
            if (stackToDrop.isEmpty()) continue;
            if (scalar > 1) {
                if (stackToDrop.getCount() > 64) {
                    stackToDrop.setCount(MathUtils.clampToInt((long)scalar * (long)stackToDrop.getCount()));
                } else {
                    stackToDrop.setCount(scalar * stackToDrop.getCount());
                }
            }
            InventoryUtils.dropStack(level, pos, null, stackToDrop, dropper);
        }
    }

    public static void dropStack(Level level, BlockPos pos, Direction side, ItemStack stack, ItemDropper dropper) {
        int max;
        int count = stack.getCount();
        if (count > (max = stack.getMaxStackSize())) {
            while (count > max) {
                dropper.drop(level, pos, side, stack.copyWithCount(max));
                count -= max;
            }
            if (count > 0) {
                dropper.drop(level, pos, side, stack.copyWithCount(count));
            }
        } else {
            dropper.drop(level, pos, side, stack);
        }
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.isEmpty() || inSlot.isEmpty()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static boolean isItemHandler(Level level, BlockPos pos, Direction side) {
        return Capabilities.ITEM.getCapabilityIfLoaded(level, pos, side) != null;
    }

    public static HandlerTransitRequest getEjectItemMap(IItemHandler handler, List<IInventorySlot> slots) {
        return InventoryUtils.getEjectItemMap(new HandlerTransitRequest(handler), slots);
    }

    @Contract(value="_, _ -> param1")
    public static <REQUEST extends HandlerTransitRequest> REQUEST getEjectItemMap(REQUEST request, List<IInventorySlot> slots) {
        ArrayList<IInventorySlot> shuffled = new ArrayList<IInventorySlot>(slots);
        Collections.shuffle(shuffled);
        for (IInventorySlot slot : shuffled) {
            ItemStack simulatedExtraction = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.EXTERNAL);
            if (simulatedExtraction.isEmpty()) continue;
            request.addItem(simulatedExtraction, slots.indexOf(slot));
        }
        return request;
    }

    public static ItemStack insertItem(List<? extends IInventorySlot> slots, @NotNull ItemStack stack, Action action, AutomationType automationType) {
        stack = InventoryUtils.insertItem(slots, stack, true, false, action, automationType);
        return InventoryUtils.insertItem(slots, stack, false, false, action, automationType);
    }

    @NotNull
    public static ItemStack insertItem(List<? extends IInventorySlot> slots, @NotNull ItemStack stack, boolean ignoreEmpty, boolean checkAll, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (IInventorySlot iInventorySlot : slots) {
            if (!checkAll && ignoreEmpty == iInventorySlot.isEmpty() || !(stack = iInventorySlot.insertItem(stack, action, automationType)).isEmpty()) continue;
            break;
        }
        return stack;
    }

    public static interface ItemDropper {
        public void drop(Level var1, BlockPos var2, Direction var3, ItemStack var4);
    }
}

