/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IGasProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.AttachedChemicalTanks;
import mekanism.common.attachments.containers.AttachedEnergyContainers;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtils {
    private StorageUtils() {
    }

    public static void addStoredEnergy(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredEnergy(stack, tooltip, showMissingCap, MekanismLang.STORED_ENERGY);
    }

    public static void addStoredEnergy(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry langEntry) {
        IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        if (energyHandlerItem == null) {
            energyHandlerItem = ContainerType.ENERGY.getAttachmentIfPresent((IAttachmentHolder)stack);
        }
        if (energyHandlerItem != null) {
            int energyContainerCount = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < energyContainerCount; ++container) {
                tooltip.add((Component)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.of(energyHandlerItem.getEnergy(container), energyHandlerItem.getMaxEnergy(container))));
            }
        } else if (showMissingCap) {
            tooltip.add((Component)langEntry.translateColored(EnumColor.BRIGHT_GREEN, EnumColor.GRAY, EnergyDisplay.ZERO));
        }
    }

    public static void addStoredGas(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes) {
        StorageUtils.addStoredGas(stack, tooltip, showMissingCap, showAttributes, MekanismLang.NO_GAS);
    }

    public static void addStoredGas(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry) {
        StorageUtils.addStoredChemical(stack, tooltip, showMissingCap, showAttributes, emptyLangEntry, (stored, emptyLang) -> {
            if (stored.isEmpty()) {
                return emptyLang.translateColored(EnumColor.GRAY);
            }
            return MekanismLang.STORED.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, MekanismLang.GENERIC_MB.translate(TextUtils.format(stored.getAmount())));
        }, Capabilities.GAS.item(), ContainerType.GAS);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addStoredChemical(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, boolean showAttributes, ILangEntry emptyLangEntry, BiFunction<STACK, ILangEntry, Component> storedFunction, ItemCapability<? extends IChemicalHandler<CHEMICAL, STACK>, Void> capability, ContainerType<?, ? extends IChemicalHandler<CHEMICAL, STACK>, ?> containerType) {
        IChemicalHandler<CHEMICAL, STACK> handler = (IChemicalHandler<CHEMICAL, STACK>)stack.getCapability(capability);
        if (handler == null) {
            handler = containerType.getAttachmentIfPresent((IAttachmentHolder)stack);
        }
        if (handler != null) {
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                STACK chemicalInTank = handler.getChemicalInTank(tank);
                tooltip.add(storedFunction.apply(chemicalInTank, emptyLangEntry));
                if (!showAttributes) continue;
                ChemicalUtil.addAttributeTooltips(tooltip, ((ChemicalStack)chemicalInTank).getType());
            }
        } else if (showMissingCap) {
            tooltip.add((Component)emptyLangEntry.translate());
        }
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap) {
        StorageUtils.addStoredFluid(stack, tooltip, showMissingCap, MekanismLang.NO_FLUID_TOOLTIP);
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry emptyLangEntry) {
        StorageUtils.addStoredFluid(stack, tooltip, showMissingCap, emptyLangEntry, (stored, emptyLang) -> {
            if (stored.isEmpty()) {
                return emptyLang.translateColored(EnumColor.GRAY);
            }
            return MekanismLang.STORED.translateColored(EnumColor.ORANGE, EnumColor.ORANGE, stored, EnumColor.GRAY, MekanismLang.GENERIC_MB.translate(TextUtils.format(stored.getAmount())));
        });
    }

    public static void addStoredFluid(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean showMissingCap, ILangEntry emptyLangEntry, BiFunction<FluidStack, ILangEntry, Component> storedFunction) {
        IFluidHandlerItem handler = Capabilities.FLUID.getCapability(stack);
        if (handler == null) {
            handler = (IFluidHandlerItem)ContainerType.FLUID.getAttachmentIfPresent((IAttachmentHolder)stack);
        }
        if (handler != null) {
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                tooltip.add(storedFunction.apply(handler.getFluidInTank(tank), emptyLangEntry));
            }
        } else if (showMissingCap) {
            tooltip.add((Component)emptyLangEntry.translate());
        }
    }

    public static void addStoredSubstance(@NotNull ItemStack stack, @NotNull List<Component> tooltip, boolean isCreative) {
        MekanismLang type;
        long amount;
        Object contents;
        FluidStack fluidStack = StorageUtils.getStoredFluidFromAttachment(stack);
        GasStack gasStack = StorageUtils.getStoredGasFromAttachment(stack);
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromAttachment(stack);
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromAttachment(stack);
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromAttachment(stack);
        if (fluidStack.isEmpty() && gasStack.isEmpty() && infusionStack.isEmpty() && pigmentStack.isEmpty() && slurryStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.EMPTY.translate());
            return;
        }
        if (!fluidStack.isEmpty()) {
            contents = fluidStack;
            amount = fluidStack.getAmount();
            type = MekanismLang.LIQUID;
        } else {
            ChemicalStack chemicalStack;
            if (!gasStack.isEmpty()) {
                chemicalStack = gasStack;
                type = MekanismLang.GAS;
            } else if (!infusionStack.isEmpty()) {
                chemicalStack = infusionStack;
                type = MekanismLang.INFUSE_TYPE;
            } else if (!pigmentStack.isEmpty()) {
                chemicalStack = pigmentStack;
                type = MekanismLang.PIGMENT;
            } else if (!slurryStack.isEmpty()) {
                chemicalStack = slurryStack;
                type = MekanismLang.SLURRY;
            } else {
                throw new IllegalStateException("Unknown chemical");
            }
            contents = chemicalStack;
            amount = chemicalStack.getAmount();
        }
        if (isCreative) {
            tooltip.add((Component)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED.translate(contents, EnumColor.GRAY, MekanismLang.INFINITE)));
        } else {
            tooltip.add((Component)type.translateColored(EnumColor.YELLOW, EnumColor.ORANGE, MekanismLang.GENERIC_STORED_MB.translate(contents, EnumColor.GRAY, TextUtils.format(amount))));
        }
    }

    @NotNull
    public static GasStack getContainedGas(ItemStack stack, IGasProvider type) {
        return StorageUtils.getContainedGas((IGasHandler)Capabilities.GAS.getCapability(stack), type);
    }

    @NotNull
    public static GasStack getContainedGas(IGasHandler gasHandler, IGasProvider type) {
        return StorageUtils.getContainedChemical(gasHandler, (Gas)type.getChemical()).orElse(GasStack.EMPTY);
    }

    @NotNull
    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> Optional<STACK> getContainedChemical(HANDLER handler, CHEMICAL type) {
        int tanks = handler.getTanks();
        for (int tank = 0; tank < tanks; ++tank) {
            STACK chemicalInTank = handler.getChemicalInTank(tank);
            if (!((ChemicalStack)chemicalInTank).isTypeEqual(type)) continue;
            return Optional.of(chemicalInTank);
        }
        return Optional.empty();
    }

    public static FluidStack getContainedFluid(@NotNull IFluidHandlerItem fluidHandlerItem, FluidStack type) {
        int tanks = fluidHandlerItem.getTanks();
        for (int i = 0; i < tanks; ++i) {
            FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(i);
            if (!fluidInTank.isFluidEqual(type)) continue;
            return fluidInTank;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public static FluidStack getStoredFluidFromAttachment(ItemStack stack) {
        FluidStack fluid = FluidStack.EMPTY;
        for (IExtendedFluidTank tank : ContainerType.FLUID.getAttachmentContainersIfPresent((IAttachmentHolder)stack)) {
            if (tank.isEmpty()) continue;
            if (fluid.isEmpty()) {
                fluid = tank.getFluid().copy();
                continue;
            }
            if (!tank.isFluidEqual(fluid)) continue;
            if (fluid.getAmount() < Integer.MAX_VALUE - tank.getFluidAmount()) {
                fluid.grow(tank.getFluidAmount());
                continue;
            }
            fluid.setAmount(Integer.MAX_VALUE);
        }
        return fluid;
    }

    @NotNull
    public static GasStack getStoredGasFromAttachment(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromAttachment(stack, GasStack.EMPTY, ContainerType.GAS);
    }

    @NotNull
    public static InfusionStack getStoredInfusionFromAttachment(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromAttachment(stack, InfusionStack.EMPTY, ContainerType.INFUSION);
    }

    @NotNull
    public static PigmentStack getStoredPigmentFromAttachment(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromAttachment(stack, PigmentStack.EMPTY, ContainerType.PIGMENT);
    }

    @NotNull
    public static SlurryStack getStoredSlurryFromAttachment(ItemStack stack) {
        return StorageUtils.getStoredChemicalFromAttachment(stack, SlurryStack.EMPTY, ContainerType.SLURRY);
    }

    @NotNull
    private static <STACK extends ChemicalStack<?>, TANK extends IChemicalTank<?, STACK>> STACK getStoredChemicalFromAttachment(ItemStack stack, STACK emptyStack, ContainerType<TANK, ? extends AttachedChemicalTanks<?, STACK, TANK>, ?> containerType) {
        STACK chemicalStack = emptyStack;
        for (IChemicalTank tank : containerType.getAttachmentContainersIfPresent((IAttachmentHolder)stack)) {
            if (tank.isEmpty()) continue;
            if (chemicalStack.isEmpty()) {
                chemicalStack = ChemicalUtil.copy(tank.getStack());
                continue;
            }
            if (!tank.isTypeEqual(chemicalStack)) continue;
            if (chemicalStack.getAmount() < Long.MAX_VALUE - tank.getStored()) {
                chemicalStack.grow(tank.getStored());
                continue;
            }
            chemicalStack.setAmount(Long.MAX_VALUE);
        }
        return chemicalStack;
    }

    public static FloatingLong getStoredEnergyFromAttachment(ItemStack stack) {
        FloatingLong energy = FloatingLong.ZERO;
        for (IEnergyContainer energyContainer : ContainerType.ENERGY.getAttachmentContainersIfPresent((IAttachmentHolder)stack)) {
            energy = energy.plusEqual(energyContainer.getEnergy());
        }
        return energy;
    }

    public static ItemStack getFilledEnergyVariant(ItemStack toFill) {
        AttachedEnergyContainers attachment = ContainerType.ENERGY.getAttachment((IAttachmentHolder)toFill);
        if (attachment != null) {
            for (IEnergyContainer energyContainer : attachment.getEnergyContainers(null)) {
                energyContainer.setEnergy(energyContainer.getMaxEnergy());
            }
        }
        return toFill;
    }

    @Nullable
    public static IEnergyContainer getEnergyContainer(ItemStack stack, int container) {
        if (stack.isEmpty()) {
            return null;
        }
        IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        if (energyHandlerItem instanceof IMekanismStrictEnergyHandler) {
            IMekanismStrictEnergyHandler energyHandler = (IMekanismStrictEnergyHandler)energyHandlerItem;
            return energyHandler.getEnergyContainer(container, null);
        }
        return null;
    }

    public static double getEnergyRatio(ItemStack stack) {
        IEnergyContainer container = StorageUtils.getEnergyContainer(stack, 0);
        return container == null ? 0.0 : container.getEnergy().divideToLevel(container.getMaxEnergy());
    }

    public static Component getEnergyPercent(ItemStack stack, boolean colorText) {
        return StorageUtils.getStoragePercent(StorageUtils.getEnergyRatio(stack), colorText);
    }

    public static Component getStoragePercent(double ratio, boolean colorText) {
        Component text = TextUtils.getPercent(ratio);
        if (!colorText) {
            return text;
        }
        EnumColor color = ratio < (double)0.01f ? EnumColor.DARK_RED : (ratio < (double)0.1f ? EnumColor.RED : (ratio < 0.25 ? EnumColor.ORANGE : (ratio < 0.5 ? EnumColor.YELLOW : EnumColor.BRIGHT_GREEN)));
        return TextComponentUtil.build(color, text);
    }

    public static int getBarWidth(ItemStack stack) {
        if (stack.getCount() > 1) {
            return 0;
        }
        return MathUtils.clampToInt(Math.round(13.0 - 13.0 * StorageUtils.getDurabilityForDisplay(stack)));
    }

    private static double getDurabilityForDisplay(ItemStack stack) {
        double bestRatio = 0.0;
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.GAS.item());
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.INFUSION.item());
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.PIGMENT.item());
        bestRatio = StorageUtils.calculateRatio(stack, bestRatio, Capabilities.SLURRY.item());
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(stack);
        if (fluidHandlerItem != null) {
            int tanks = fluidHandlerItem.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(fluidHandlerItem.getFluidInTank(tank).getAmount(), fluidHandlerItem.getTankCapacity(tank)));
            }
        }
        return 1.0 - bestRatio;
    }

    public static int getEnergyBarWidth(ItemStack stack) {
        if (stack.getCount() > 1) {
            return 0;
        }
        return MathUtils.clampToInt(Math.round(13.0 - 13.0 * StorageUtils.getEnergyDurabilityForDisplay(stack)));
    }

    private static double getEnergyDurabilityForDisplay(ItemStack stack) {
        double bestRatio = 0.0;
        IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        if (energyHandlerItem != null) {
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                bestRatio = Math.max(bestRatio, energyHandlerItem.getEnergy(container).divideToLevel(energyHandlerItem.getMaxEnergy(container)));
            }
        }
        return 1.0 - bestRatio;
    }

    private static double calculateRatio(ItemStack stack, double bestRatio, ItemCapability<? extends IChemicalHandler<?, ?>, Void> capability) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(capability);
        if (handler != null) {
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                bestRatio = Math.max(bestRatio, StorageUtils.getRatio(((ChemicalStack)handler.getChemicalInTank(tank)).getAmount(), handler.getTankCapacity(tank)));
            }
        }
        return bestRatio;
    }

    public static double getRatio(long amount, long capacity) {
        return capacity == 0L ? 1.0 : (double)amount / (double)capacity;
    }

    public static void mergeFluidTanks(List<IExtendedFluidTank> tanks, List<IExtendedFluidTank> toAdd, List<FluidStack> rejects) {
        StorageUtils.validateSizeMatches(tanks, toAdd, "tank");
        for (int i = 0; i < toAdd.size(); ++i) {
            int remaining;
            IExtendedFluidTank mergeTank = toAdd.get(i);
            if (mergeTank.isEmpty()) continue;
            IExtendedFluidTank tank = tanks.get(i);
            FluidStack mergeStack = mergeTank.getFluid();
            if (tank.isEmpty()) {
                int capacity = tank.getCapacity();
                if (mergeStack.getAmount() <= capacity) {
                    tank.setStack(mergeStack);
                    continue;
                }
                tank.setStack(mergeStack.copyWithAmount(capacity));
                remaining = mergeStack.getAmount() - capacity;
                if (remaining <= 0) continue;
                rejects.add(mergeStack.copyWithAmount(remaining));
                continue;
            }
            if (tank.isFluidEqual(mergeStack)) {
                int amount = tank.growStack(mergeStack.getAmount(), Action.EXECUTE);
                remaining = mergeStack.getAmount() - amount;
                if (remaining <= 0) continue;
                rejects.add(mergeStack.copyWithAmount(remaining));
                continue;
            }
            rejects.add(mergeStack);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void mergeTanks(List<TANK> tanks, List<TANK> toAdd, List<STACK> rejects) {
        StorageUtils.validateSizeMatches(tanks, toAdd, "tank");
        for (int i = 0; i < toAdd.size(); ++i) {
            long remaining;
            IChemicalTank mergeTank = (IChemicalTank)toAdd.get(i);
            if (mergeTank.isEmpty()) continue;
            IChemicalTank tank = (IChemicalTank)tanks.get(i);
            Object mergeStack = mergeTank.getStack();
            if (tank.isEmpty()) {
                long capacity = tank.getCapacity();
                if (((ChemicalStack)mergeStack).getAmount() <= capacity) {
                    tank.setStack(mergeStack);
                    continue;
                }
                tank.setStack(ChemicalUtil.copyWithAmount(mergeStack, capacity));
                remaining = ((ChemicalStack)mergeStack).getAmount() - capacity;
                if (remaining <= 0L) continue;
                rejects.add(ChemicalUtil.copyWithAmount(mergeStack, remaining));
                continue;
            }
            if (tank.isTypeEqual(mergeStack)) {
                long amount = tank.growStack(((ChemicalStack)mergeStack).getAmount(), Action.EXECUTE);
                remaining = ((ChemicalStack)mergeStack).getAmount() - amount;
                if (remaining <= 0L) continue;
                rejects.add(ChemicalUtil.copyWithAmount(mergeStack, remaining));
                continue;
            }
            rejects.add(mergeStack);
        }
    }

    public static void mergeEnergyContainers(List<IEnergyContainer> containers, List<IEnergyContainer> toAdd) {
        StorageUtils.validateSizeMatches(containers, toAdd, "energy container");
        for (int i = 0; i < toAdd.size(); ++i) {
            IEnergyContainer container = containers.get(i);
            IEnergyContainer mergeContainer = toAdd.get(i);
            container.setEnergy(container.getEnergy().add(mergeContainer.getEnergy()));
        }
    }

    public static void mergeHeatCapacitors(List<IHeatCapacitor> capacitors, List<IHeatCapacitor> toAdd) {
        StorageUtils.validateSizeMatches(capacitors, toAdd, "heat capacitor");
        for (int i = 0; i < toAdd.size(); ++i) {
            IHeatCapacitor capacitor = capacitors.get(i);
            IHeatCapacitor mergeCapacitor = toAdd.get(i);
            capacitor.setHeat(capacitor.getHeat() + mergeCapacitor.getHeat());
            if (!(capacitor instanceof BasicHeatCapacitor)) continue;
            BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)capacitor;
            heatCapacitor.setHeatCapacity(capacitor.getHeatCapacity() + mergeCapacitor.getHeatCapacity(), false);
        }
    }

    public static <T> void validateSizeMatches(List<T> base, List<T> toAdd, String type) {
        if (base.size() != toAdd.size()) {
            throw new IllegalArgumentException("Mismatched " + type + " count, orig: " + base.size() + ", toAdd: " + toAdd.size());
        }
    }
}

