/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.ItemTileEntityCache;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.corelib.block.IItemBlock;
import de.maxhenkel.easyvillagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easyvillagers.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.easyvillagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.BreederContainer;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.items.render.BreederItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BreederBlock
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public BreederBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.5f).sound(SoundType.METAL).noOcclusion());
    }

    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, new Item.Properties()){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new BreederItemRenderer();
            }
        };
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
        EasyVillagerEntity villager2;
        super.appendHoverText(stack, blockGetter, components, tooltipFlag);
        BreederTileentity trader = ItemTileEntityCache.getTileEntity(stack, () -> new BreederTileentity(BlockPos.ZERO, ((TraderBlock)ModBlocks.TRADER.get()).defaultBlockState()));
        EasyVillagerEntity villager1 = trader.getVillagerEntity1();
        if (villager1 != null) {
            components.add(villager1.getAdvancedName());
        }
        if ((villager2 = trader.getVillagerEntity2()) != null) {
            components.add(villager2.getAdvancedName());
        }
    }

    public InteractionResult use(final BlockState state, final Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (!(tileEntity instanceof BreederTileentity)) {
            return super.use(state, worldIn, pos, player, handIn, hit);
        }
        final BreederTileentity breeder = (BreederTileentity)tileEntity;
        if (!breeder.hasVillager1() && heldItem.getItem() instanceof VillagerItem) {
            breeder.setVillager1(heldItem.copy());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_YES);
            return InteractionResult.SUCCESS;
        }
        if (!breeder.hasVillager2() && heldItem.getItem() instanceof VillagerItem) {
            breeder.setVillager2(heldItem.copy());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_YES);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && breeder.hasVillager2()) {
            ItemStack stack = breeder.removeVillager2();
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, stack);
            } else if (!player.getInventory().add(stack)) {
                Direction direction = (Direction)state.getValue((Property)FarmerBlock.FACING);
                Containers.dropItemStack((Level)worldIn, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_CELEBRATE);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && breeder.hasVillager1()) {
            ItemStack stack = breeder.removeVillager1();
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, stack);
            } else if (!player.getInventory().add(stack)) {
                Direction direction = (Direction)state.getValue((Property)FarmerBlock.FACING);
                Containers.dropItemStack((Level)worldIn, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_CELEBRATE);
            return InteractionResult.SUCCESS;
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)state.getBlock().getDescriptionId());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                return new BreederContainer(id, playerInventory, breeder.getFoodInventory(), breeder.getOutputInventory(), ContainerLevelAccess.create((Level)worldIn, (BlockPos)pos));
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BreederTileentity(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

