/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.block.IItemBlock;
import de.maxhenkel.easyvillagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class TraderBlockBase
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public TraderBlockBase() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.5f).sound(SoundType.METAL).noOcclusion());
    }

    @Override
    public abstract Item toItem();

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (!(tileEntity instanceof TraderTileentityBase)) {
            return super.use(state, worldIn, pos, player, handIn, hit);
        }
        TraderTileentityBase trader = (TraderTileentityBase)tileEntity;
        if (!trader.hasVillager() && heldItem.getItem() instanceof VillagerItem) {
            trader.setVillager(heldItem.copy());
            ItemUtils.decrItemStack(heldItem, player);
            if (trader.hasWorkstation()) {
                EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
                if (villagerEntity != null) {
                    this.playWorkstationSound(worldIn, pos, trader);
                }
            } else {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_CELEBRATE);
            }
            return InteractionResult.SUCCESS;
        }
        if (!trader.hasWorkstation() && heldItem.getItem() instanceof BlockItem && trader.isValidBlock(((BlockItem)heldItem.getItem()).getBlock())) {
            Block block = ((BlockItem)heldItem.getItem()).getBlock();
            trader.setWorkstation(block);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
            if (villagerEntity != null) {
                this.playWorkstationSound(worldIn, pos, trader);
            }
            SoundType type = block.getSoundType(block.defaultBlockState());
            worldIn.playSound(null, pos, type.getPlaceSound(), SoundSource.BLOCKS, type.getVolume(), type.getPitch());
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && trader.hasVillager()) {
            ItemStack stack = trader.removeVillager();
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, stack);
            } else if (!player.getInventory().add(stack)) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Containers.dropItemStack((Level)worldIn, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)stack);
            }
            TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_CELEBRATE);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && trader.hasWorkstation()) {
            ItemStack blockStack = new ItemStack((ItemLike)trader.removeWorkstation());
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, blockStack);
            } else if (!player.getInventory().add(blockStack)) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Containers.dropItemStack((Level)worldIn, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)blockStack);
            }
            if (trader.hasVillager()) {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.VILLAGER_NO);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.openGUI(trader, player, worldIn, pos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract boolean openGUI(TraderTileentityBase var1, Player var2, Level var3, BlockPos var4);

    protected void playWorkstationSound(Level world, BlockPos pos, TraderTileentityBase trader) {
        EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
        if (villagerEntity != null) {
            if (trader.getWorkstationProfession().equals((Object)villagerEntity.getVillagerData().getProfession())) {
                TraderBlockBase.playVillagerSound(world, pos, trader.getWorkstationProfession().workSound());
            } else {
                TraderBlockBase.playVillagerSound(world, pos, SoundEvents.VILLAGER_NO);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

