/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.BreederBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.FoodSlot;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.net.MessageVillagerParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BreederTileentity
extends FakeWorldTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> foodInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected ItemStack villager1 = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity1;
    protected ItemStack villager2 = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity2;
    private MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.foodInventory, this.outputInventory, FoodSlot::isValid);

    public BreederTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BREEDER.get(), ((BreederBlock)ModBlocks.BREEDER.get()).defaultBlockState(), pos, state);
    }

    public ItemStack getVillager1() {
        return this.villager1;
    }

    public ItemStack getVillager2() {
        return this.villager2;
    }

    public boolean hasVillager1() {
        return !this.villager1.isEmpty();
    }

    public boolean hasVillager2() {
        return !this.villager2.isEmpty();
    }

    public EasyVillagerEntity getVillagerEntity1() {
        if (this.villagerEntity1 == null && !this.villager1.isEmpty()) {
            this.villagerEntity1 = ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, this.villager1);
        }
        return this.villagerEntity1;
    }

    public EasyVillagerEntity getVillagerEntity2() {
        if (this.villagerEntity2 == null && !this.villager2.isEmpty()) {
            this.villagerEntity2 = ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, this.villager2);
        }
        return this.villagerEntity2;
    }

    public void setVillager1(ItemStack villager) {
        this.villager1 = villager;
        this.villagerEntity1 = villager.isEmpty() ? null : ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, villager);
        this.setChanged();
        this.sync();
    }

    public void setVillager2(ItemStack villager) {
        this.villager2 = villager;
        this.villagerEntity2 = villager.isEmpty() ? null : ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, villager);
        this.setChanged();
        this.sync();
    }

    public ItemStack removeVillager1() {
        ItemStack v = this.villager1;
        this.setVillager1(ItemStack.EMPTY);
        return v;
    }

    public ItemStack removeVillager2() {
        ItemStack v = this.villager2;
        this.setVillager2(ItemStack.EMPTY);
        return v;
    }

    @Override
    public void tickServer() {
        if (this.level.isClientSide) {
            return;
        }
        boolean age1 = VillagerTileentity.advanceAge(this.getVillagerEntity1());
        boolean age2 = VillagerTileentity.advanceAge(this.getVillagerEntity2());
        if (age1 || age2) {
            this.sync();
        }
        if (this.hasVillager1() || this.hasVillager2()) {
            this.setChanged();
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        }
        if (this.level.getGameTime() % (long)((Integer)Main.SERVER_CONFIG.breedingTime.get()).intValue() == 0L) {
            this.tryBreed();
        }
    }

    public void tryBreed() {
        if (this.canBreed() && this.addVillager()) {
            this.removeBreedingItems();
            VillagerBlockBase.playVillagerSound(this.level, this.worldPosition, SoundEvents.VILLAGER_CELEBRATE);
            this.spawnParticles();
        }
    }

    public void spawnParticles() {
        if (this.level.isClientSide) {
            for (int i = 0; i < 5; ++i) {
                this.level.addParticle((ParticleOptions)ParticleTypes.HEART, (double)this.worldPosition.getX() + (this.level.random.nextDouble() - 0.5) + 0.5, (double)this.worldPosition.getY() + this.level.random.nextDouble() + 1.0, (double)this.worldPosition.getZ() + (this.level.random.nextDouble() - 0.5) + 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            PacketDistributor.TRACKING_CHUNK.with((Object)this.level.getChunkAt(this.worldPosition)).send(new CustomPacketPayload[]{new MessageVillagerParticles(this.worldPosition)});
        }
    }

    private boolean addVillager() {
        for (int i = 0; i < this.outputInventory.size(); ++i) {
            if (!((ItemStack)this.outputInventory.get(i)).isEmpty()) continue;
            EasyVillagerEntity villagerEntity = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.VILLAGER, this.level);
            villagerEntity.setVillagerData(villagerEntity.getVillagerData().setType(VillagerType.byBiome((Holder)this.level.getBiome(this.getBlockPos()))));
            villagerEntity.setAge(-24000);
            ItemStack villager = new ItemStack((ItemLike)ModItems.VILLAGER.get());
            ((VillagerItem)((Object)ModItems.VILLAGER.get())).setVillager(villager, villagerEntity);
            this.outputInventory.set(i, (Object)villager);
            return true;
        }
        return false;
    }

    public boolean canBreed() {
        if (!this.hasVillager1() || !this.hasVillager2()) {
            return false;
        }
        if (this.getVillagerEntity1().isBaby() || this.getVillagerEntity2().isBaby()) {
            return false;
        }
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            value += Villager.FOOD_POINTS.getOrDefault(stack.getItem(), 0) * stack.getCount();
        }
        return value >= 24;
    }

    private void removeBreedingItems() {
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            for (int i = 0; i < stack.getCount(); ++i) {
                stack.shrink(1);
                if ((value += Villager.FOOD_POINTS.getOrDefault(stack.getItem(), 0).intValue()) < 24) continue;
                return;
            }
        }
    }

    protected void saveAdditional(CompoundTag compound) {
        CompoundTag comp;
        super.saveAdditional(compound);
        if (this.hasVillager1()) {
            comp = new CompoundTag();
            if (this.villagerEntity1 != null) {
                ((VillagerItem)((Object)ModItems.VILLAGER.get())).setVillager(this.villager1, this.villagerEntity1);
            }
            this.villager1.save(comp);
            compound.put("Villager1", (Tag)comp);
        }
        if (this.hasVillager2()) {
            comp = new CompoundTag();
            if (this.villagerEntity2 != null) {
                ((VillagerItem)((Object)ModItems.VILLAGER.get())).setVillager(this.villager2, this.villagerEntity2);
            }
            this.villager2.save(comp);
            compound.put("Villager2", (Tag)comp);
        }
        compound.put("FoodInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.foodInventory, (boolean)true));
        compound.put("OutputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
    }

    public void load(CompoundTag compound) {
        CompoundTag comp;
        if (compound.contains("Villager1")) {
            comp = compound.getCompound("Villager1");
            this.villager1 = ItemStack.of((CompoundTag)comp);
            this.villagerEntity1 = null;
        } else {
            this.removeVillager1();
        }
        if (compound.contains("Villager2")) {
            comp = compound.getCompound("Villager2");
            this.villager2 = ItemStack.of((CompoundTag)comp);
            this.villagerEntity2 = null;
        } else {
            this.removeVillager2();
        }
        ContainerHelper.loadAllItems((CompoundTag)compound.getCompound("FoodInventory"), this.foodInventory);
        ContainerHelper.loadAllItems((CompoundTag)compound.getCompound("OutputInventory"), this.outputInventory);
        super.load(compound);
    }

    public Container getFoodInventory() {
        return new ItemListInventory(this.foodInventory, () -> ((BreederTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BreederTileentity)this).setChanged());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

