/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.OutputItemHandler;
import de.maxhenkel.easyvillagers.blocks.IronFarmBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class IronFarmTileentity
extends VillagerTileentity
implements ITickableBlockEntity {
    protected static final ResourceLocation GOLEM_LOOT_TABLE = new ResourceLocation("entities/iron_golem");
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected long timer;
    protected ItemStackHandler itemHandler = new ItemStackHandler(this.inventory);
    protected OutputItemHandler outputItemHandler = new OutputItemHandler(this.inventory);

    public IronFarmTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.IRON_FARM.get(), ((IronFarmBlock)ModBlocks.IRON_FARM.get()).defaultBlockState(), pos, state);
    }

    public long getTimer() {
        return this.timer;
    }

    @Override
    public void tick() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
            if (this.advanceAge()) {
                this.sync();
            }
            ++this.timer;
            this.setChanged();
            if (this.timer == (long)IronFarmTileentity.getGolemSpawnTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.ZOMBIE_AMBIENT);
                this.sync();
            } else if (this.timer > (long)IronFarmTileentity.getGolemSpawnTime() && this.timer < (long)IronFarmTileentity.getGolemKillTime()) {
                if (this.timer % 20L == 0L) {
                    VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.IRON_GOLEM_HURT);
                }
            } else if (this.timer >= (long)IronFarmTileentity.getGolemKillTime()) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.IRON_GOLEM_DEATH);
                for (ItemStack drop : this.getDrops()) {
                    for (int i = 0; i < this.itemHandler.getSlots() && !(drop = this.itemHandler.insertItem(i, drop, false)).isEmpty(); ++i) {
                    }
                }
                this.timer = 0L;
                this.sync();
            }
        }
    }

    private List<ItemStack> getDrops() {
        if (!(this.level instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        ServerLevel serverWorld = (ServerLevel)this.level;
        LootParams.Builder builder = new LootParams.Builder(serverWorld).withParameter(LootContextParams.THIS_ENTITY, (Object)new IronGolem(EntityType.IRON_GOLEM, this.level)).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverWorld.damageSources().lava());
        LootParams lootContext = builder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = serverWorld.getServer().getLootData().getLootTable(GOLEM_LOOT_TABLE);
        return lootTable.getRandomItems(lootContext);
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((IronFarmTileentity)this).setChanged());
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventory, (boolean)false);
        compound.putLong("Timer", this.timer);
    }

    @Override
    public void load(CompoundTag compound) {
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventory);
        this.timer = compound.getLong("Timer");
        super.load(compound);
    }

    public static int getGolemSpawnTime() {
        return (Integer)Main.SERVER_CONFIG.golemSpawnTime.get() - 200;
    }

    public static int getGolemKillTime() {
        return IronFarmTileentity.getGolemSpawnTime() + 200;
    }

    public IItemHandler getItemHandler() {
        return this.outputItemHandler;
    }
}

