/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class VillagerTileentity
extends FakeWorldTileentity {
    protected ItemStack villager = ItemStack.EMPTY;
    protected EasyVillagerEntity villagerEntity;

    public VillagerTileentity(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public ItemStack getVillager() {
        if (this.villagerEntity != null) {
            this.saveVillagerEntity();
        }
        return this.villager;
    }

    public boolean hasVillager() {
        return !this.villager.isEmpty();
    }

    @Nullable
    public EasyVillagerEntity getVillagerEntity() {
        if (this.villagerEntity == null && !this.villager.isEmpty()) {
            this.villagerEntity = ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, this.villager);
        }
        return this.villagerEntity;
    }

    public void saveVillagerEntity() {
        if (this.villagerEntity != null) {
            ((VillagerItem)((Object)ModItems.VILLAGER.get())).setVillager(this.villager, this.villagerEntity);
        }
    }

    public void setVillager(ItemStack villager) {
        this.villager = villager;
        if (villager.isEmpty()) {
            this.villagerEntity = null;
        } else {
            this.villagerEntity = ((VillagerItem)((Object)ModItems.VILLAGER.get())).getVillager(this.level, villager);
            this.onAddVillager(this.villagerEntity);
        }
        this.setChanged();
        this.sync();
    }

    protected void onAddVillager(EasyVillagerEntity villager) {
    }

    public ItemStack removeVillager() {
        ItemStack v = this.getVillager();
        this.setVillager(ItemStack.EMPTY);
        return v;
    }

    public boolean advanceAge() {
        return VillagerTileentity.advanceAge(this.getVillagerEntity());
    }

    public boolean advanceAge(int amount) {
        return VillagerTileentity.advanceAge(this.getVillagerEntity(), amount);
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity, int amount) {
        if (villagerEntity == null) {
            return false;
        }
        int prevAge = villagerEntity.getAge();
        int age = prevAge + amount;
        villagerEntity.setAge(age);
        return prevAge < 0 && age >= 0;
    }

    public static boolean advanceAge(EasyVillagerEntity villagerEntity) {
        return VillagerTileentity.advanceAge(villagerEntity, 1);
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        if (this.hasVillager()) {
            CompoundTag comp = new CompoundTag();
            this.getVillager().save(comp);
            compound.put("Villager", (Tag)comp);
        }
    }

    public void load(CompoundTag compound) {
        if (compound.contains("Villager")) {
            CompoundTag comp = compound.getCompound("Villager");
            this.villager = ItemStack.of((CompoundTag)comp);
            this.villagerEntity = null;
        } else {
            this.removeVillager();
        }
        super.load(compound);
    }
}

