/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BedRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class BreederRenderer
extends VillagerRendererBase<BreederTileentity> {
    private BedRenderer bedRenderer;
    private BedBlockEntity bed;

    public BreederRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(BreederTileentity breeder, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(breeder, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.pushPose();
        if (this.bedRenderer == null) {
            this.bedRenderer = new BedRenderer(this.renderer);
            this.bed = new BedBlockEntity(BlockPos.ZERO, Blocks.RED_BED.defaultBlockState());
        }
        Direction direction = Direction.SOUTH;
        if (!breeder.isFakeWorld()) {
            direction = (Direction)breeder.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (breeder.getVillagerEntity1() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            this.villagerRenderer.render((Mob)breeder.getVillagerEntity1(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        if (breeder.getVillagerEntity2() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.3125, 0.0, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            this.villagerRenderer.render((Mob)breeder.getVillagerEntity2(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.0, 0.0, 0.1875);
        matrixStack.translate(-0.5, 0.0, -0.5);
        matrixStack.scale(0.4f, 0.4f, 0.4f);
        matrixStack.translate(0.75, 0.0, 0.75);
        this.bedRenderer.render(this.bed, 1.0f, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

