/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class ConverterRenderer
extends VillagerRendererBase<ConverterTileentity> {
    private Zombie zombie;
    private ZombieRenderer zombieRenderer;
    private ZombieVillagerRenderer zombieVillagerRenderer;
    private ZombieVillager zombieVillager;

    public ConverterRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(ConverterTileentity converter, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        EasyVillagerEntity villagerEntity;
        super.render(converter, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.pushPose();
        if (this.zombieRenderer == null) {
            this.zombieRenderer = new ZombieRenderer(this.createEntityRenderer());
            this.zombie = new Zombie((Level)this.minecraft.level);
        }
        if (this.zombieVillagerRenderer == null) {
            this.zombieVillagerRenderer = new ZombieVillagerRenderer(this.createEntityRenderer());
            this.zombieVillager = new ZombieVillager(EntityType.ZOMBIE_VILLAGER, (Level)this.minecraft.level);
        }
        Direction direction = Direction.SOUTH;
        if (!converter.isFakeWorld()) {
            direction = (Direction)converter.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if ((villagerEntity = converter.getVillagerEntity()) != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.4f, 0.4f, 0.4f);
            if (converter.getTimer() >= (long)ConverterTileentity.getZombifyTime() && converter.getTimer() < (long)ConverterTileentity.getConvertTime()) {
                this.zombieVillager.setVillagerData(villagerEntity.getVillagerData());
                this.zombieVillager.setBaby(villagerEntity.isBaby());
                this.zombieVillagerRenderer.render((Mob)this.zombieVillager, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            } else {
                this.villagerRenderer.render((Mob)villagerEntity, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            }
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.3125, 0.0, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        matrixStack.scale(0.4f, 0.4f, 0.4f);
        this.zombieRenderer.render((Mob)this.zombie, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

