/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.corelib.client.RenderUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class FarmerRenderer
extends VillagerRendererBase<FarmerTileentity> {
    public FarmerRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(FarmerTileentity farmer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState crop;
        super.render(farmer, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.pushPose();
        Direction direction = Direction.SOUTH;
        if (!farmer.isFakeWorld()) {
            direction = (Direction)farmer.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (farmer.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, -0.25);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            this.villagerRenderer.render((Mob)farmer.getVillagerEntity(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        if ((crop = farmer.getCrop()) != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, 0.125);
            matrixStack.translate(-0.5, 0.0, -0.5);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            matrixStack.translate(0.6111111111111112, 0.0, 0.6111111111111112);
            BlockRenderDispatcher dispatcher = this.minecraft.getBlockRenderer();
            int color = this.minecraft.getBlockColors().getColor(crop, null, null, 0);
            RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)crop, (boolean)false);
            dispatcher.getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(renderType), crop, dispatcher.getBlockModel(crop), (float)RenderUtils.getRed(color), (float)RenderUtils.getGreen(color), (float)RenderUtils.getBlue(color), combinedLight, combinedOverlay, ModelData.EMPTY, renderType);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

