/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.IronFarmTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class IronFarmRenderer
extends VillagerRendererBase<IronFarmTileentity> {
    private Zombie zombie;
    private ZombieRenderer zombieRenderer;
    private IronGolem ironGolem;
    private IronGolemRenderer ironGolemRenderer;

    public IronFarmRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(IronFarmTileentity farm, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(farm, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.pushPose();
        if (this.zombieRenderer == null) {
            this.zombieRenderer = new ZombieRenderer(this.createEntityRenderer());
            this.zombie = new Zombie((Level)this.minecraft.level);
        }
        if (this.ironGolemRenderer == null) {
            this.ironGolemRenderer = new IronGolemRenderer(this.createEntityRenderer());
            this.ironGolem = new IronGolem(EntityType.IRON_GOLEM, (Level)this.minecraft.level);
        }
        Direction direction = Direction.SOUTH;
        if (!farm.isFakeWorld()) {
            direction = (Direction)farm.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (farm.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, -0.3125);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.3f, 0.3f, 0.3f);
            this.villagerRenderer.render((Mob)farm.getVillagerEntity(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.3125, 0.0, -0.3125);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        matrixStack.scale(0.3f, 0.3f, 0.3f);
        this.zombieRenderer.render((Mob)this.zombie, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
        matrixStack.popPose();
        if (farm.getTimer() >= (long)IronFarmTileentity.getGolemSpawnTime() && farm.getTimer() < (long)IronFarmTileentity.getGolemKillTime()) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, 0.1875);
            matrixStack.scale(0.3f, 0.3f, 0.3f);
            this.ironGolem.hurtTime = farm.getTimer() % 20L < 10L ? 20 : 0;
            this.ironGolemRenderer.render((Mob)this.ironGolem, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

