/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.death;

import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.corelib.player.PlayerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> mainInventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> armorInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> offHandInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> additionalItems = NonNullList.create();
    private NonNullList<ItemStack> equipment = NonNullList.withSize((int)EquipmentSlot.values().length, (Object)ItemStack.EMPTY);
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;
    private byte model;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getMainInventory() {
        return this.mainInventory;
    }

    public NonNullList<ItemStack> getArmorInventory() {
        return this.armorInventory;
    }

    public NonNullList<ItemStack> getOffHandInventory() {
        return this.offHandInventory;
    }

    public NonNullList<ItemStack> getAdditionalItems() {
        return this.additionalItems;
    }

    public NonNullList<ItemStack> getEquipment() {
        return this.equipment;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return BlockPos.containing((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public byte getModel() {
        return this.model;
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(Player player) {
        int i;
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.getUUID();
        death.playerName = player.getName().getString();
        for (i = 0; i < death.mainInventory.size(); ++i) {
            death.mainInventory.set(i, (Object)((ItemStack)player.getInventory().items.get(i)));
        }
        for (i = 0; i < death.armorInventory.size(); ++i) {
            death.armorInventory.set(i, (Object)((ItemStack)player.getInventory().armor.get(i)));
        }
        for (i = 0; i < death.offHandInventory.size(); ++i) {
            death.offHandInventory.set(i, (Object)((ItemStack)player.getInventory().offhand.get(i)));
        }
        death.equipment = NonNullList.withSize((int)EquipmentSlot.values().length, (Object)ItemStack.EMPTY);
        for (i = 0; i < death.equipment.size(); ++i) {
            death.equipment.set(i, (Object)player.getItemBySlot(EquipmentSlot.values()[i]).copy());
        }
        death.timestamp = System.currentTimeMillis();
        death.experience = player.experienceLevel;
        death.posX = player.position().x;
        death.posY = player.position().y;
        death.posZ = player.position().z;
        death.dimension = player.level().dimension().location().toString();
        death.model = PlayerUtils.getModel(player);
        return death;
    }

    public void processDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::getItem).filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        this.processInventory(drops, this.mainInventory);
        this.processInventory(drops, this.armorInventory);
        this.processInventory(drops, this.offHandInventory);
        this.additionalItems.addAll(drops);
    }

    private void processInventory(List<ItemStack> drops, NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.isEmpty()) continue;
            if (drops.contains(itemStack)) {
                drops.remove(itemStack);
                continue;
            }
            inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public NonNullList<ItemStack> getAllItems() {
        NonNullList items = NonNullList.create();
        items.addAll(this.filterList((List<ItemStack>)this.mainInventory));
        items.addAll(this.filterList((List<ItemStack>)this.armorInventory));
        items.addAll(this.filterList((List<ItemStack>)this.offHandInventory));
        items.addAll(this.filterList((List<ItemStack>)this.additionalItems));
        return items;
    }

    private List<ItemStack> filterList(List<ItemStack> stacks) {
        return stacks.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
    }

    public static Death fromNBT(CompoundTag compound) {
        Death death = new Death();
        death.id = compound.contains("IdMost") && compound.contains("IdLeast") ? new UUID(compound.getLong("IdMost"), compound.getLong("IdLeast")) : (compound.contains("Id") ? compound.getUUID("Id") : UUID.randomUUID());
        death.playerUUID = compound.contains("PlayerUuidMost") && compound.contains("PlayerUuidLeast") ? new UUID(compound.getLong("PlayerUuidMost"), compound.getLong("PlayerUuidLeast")) : (compound.contains("PlayerUuid") ? compound.getUUID("PlayerUuid") : UUID.randomUUID());
        death.playerName = compound.getString("PlayerName");
        ItemUtils.readInventory(compound, "MainInventory", death.mainInventory);
        ItemUtils.readInventory(compound, "ArmorInventory", death.armorInventory);
        ItemUtils.readInventory(compound, "OffHandInventory", death.offHandInventory);
        death.additionalItems = ItemUtils.readItemList(compound, "Items");
        ItemUtils.readItemList(compound, "Equipment", death.equipment);
        death.timestamp = compound.getLong("Timestamp");
        death.experience = compound.getInt("Experience");
        death.posX = compound.getDouble("PosX");
        death.posY = compound.getDouble("PosY");
        death.posZ = compound.getDouble("PosZ");
        death.dimension = compound.getString("Dimension");
        death.model = compound.getByte("Model");
        return death;
    }

    public CompoundTag toNBT() {
        return this.toNBT(true);
    }

    public CompoundTag toNBT(boolean withItems) {
        CompoundTag compound = new CompoundTag();
        compound.putUUID("Id", this.id);
        compound.putUUID("PlayerUuid", this.playerUUID);
        compound.putString("PlayerName", this.playerName);
        if (withItems) {
            ItemUtils.saveInventory(compound, "MainInventory", this.mainInventory);
            ItemUtils.saveInventory(compound, "ArmorInventory", this.armorInventory);
            ItemUtils.saveInventory(compound, "OffHandInventory", this.offHandInventory);
            ItemUtils.saveItemList(compound, "Items", this.additionalItems);
        }
        ItemUtils.saveItemList(compound, "Equipment", this.equipment);
        compound.putLong("Timestamp", this.timestamp);
        compound.putInt("Experience", this.experience);
        compound.putDouble("PosX", this.posX);
        compound.putDouble("PosY", this.posY);
        compound.putDouble("PosZ", this.posZ);
        compound.putString("Dimension", this.dimension);
        compound.putByte("Model", this.model);
        return compound;
    }

    public static class Builder {
        private Death death = new Death();

        public Builder(UUID playerUUID, UUID id) {
            this.death.dimension = "";
            this.death.playerName = "";
            this.death.playerUUID = playerUUID;
            this.death.id = id;
        }

        public Death build() {
            return this.death;
        }

        public Builder id(UUID uuid) {
            this.death.id = uuid;
            return this;
        }

        public Builder playerUUID(UUID uuid) {
            this.death.playerUUID = uuid;
            return this;
        }

        public Builder playerName(String name) {
            this.death.playerName = name;
            return this;
        }

        public Builder mainInventory(NonNullList<ItemStack> list) {
            this.death.mainInventory = list;
            return this;
        }

        public Builder armorInventory(NonNullList<ItemStack> list) {
            this.death.armorInventory = list;
            return this;
        }

        public Builder offHandInventory(NonNullList<ItemStack> list) {
            this.death.offHandInventory = list;
            return this;
        }

        public Builder additionalItems(NonNullList<ItemStack> list) {
            this.death.additionalItems = list;
            return this;
        }

        public Builder equipment(NonNullList<ItemStack> list) {
            this.death.equipment = list;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.death.timestamp = timestamp;
            return this;
        }

        public Builder experience(int experience) {
            this.death.experience = experience;
            return this;
        }

        public Builder posX(double posX) {
            this.death.posX = posX;
            return this;
        }

        public Builder posY(double posY) {
            this.death.posY = posY;
            return this;
        }

        public Builder posZ(double posZ) {
            this.death.posZ = posZ;
            return this;
        }

        public Builder dimension(String dimension) {
            this.death.dimension = dimension;
            return this;
        }

        public Builder model(byte model) {
            this.death.model = model;
            return this;
        }
    }
}

