/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.inventory;

import de.maxhenkel.easyvillagers.corelib.sound.SoundUtils;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public abstract class ShulkerBoxInventory
implements Container,
MenuProvider {
    protected NonNullList<ItemStack> items;
    protected ItemStack shulkerBox;
    protected int invSize;
    protected CompoundTag blockEntityTag;
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public ShulkerBoxInventory(Player player, ItemStack shulkerBox, int invSize) {
        this.shulkerBox = shulkerBox;
        this.invSize = invSize;
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.startOpen(player);
        CompoundTag c = shulkerBox.getTag();
        if (c == null) {
            return;
        }
        if (!c.contains("BlockEntityTag")) {
            return;
        }
        this.blockEntityTag = c.getCompound("BlockEntityTag");
        if (this.blockEntityTag.contains("Items")) {
            ContainerHelper.loadAllItems((CompoundTag)this.blockEntityTag, this.items);
        } else if (this.blockEntityTag.contains("LootTable")) {
            this.lootTable = new ResourceLocation(this.blockEntityTag.getString("LootTable"));
            this.lootTableSeed = this.blockEntityTag.getLong("LootTableSeed");
            this.fillWithLoot(player);
            this.blockEntityTag.remove("LootTable");
            this.blockEntityTag.remove("LootTableSeed");
        }
    }

    public ShulkerBoxInventory(Player player, ItemStack shulkerBox) {
        this(player, shulkerBox, 27);
    }

    public void fillWithLoot(@Nullable Player player) {
        if (this.lootTable != null && player != null) {
            LootTable loottable = player.level().getServer().getLootData().getLootTable(this.lootTable);
            this.lootTable = null;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)player.level());
            builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            loottable.fill((Container)this, builder.create(LootContextParamSets.CHEST), this.lootTableSeed);
            this.setChanged();
        }
    }

    public int getContainerSize() {
        return this.invSize;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        this.setChanged();
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = ContainerHelper.takeItem(this.items, (int)index);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        CompoundTag tag = this.shulkerBox.getOrCreateTag();
        if (this.blockEntityTag == null) {
            this.blockEntityTag = new CompoundTag();
            tag.put("BlockEntityTag", (Tag)this.blockEntityTag);
        } else {
            tag.put("BlockEntityTag", (Tag)this.blockEntityTag);
        }
        ContainerHelper.saveAllItems((CompoundTag)this.blockEntityTag, this.items, (boolean)true);
    }

    public void startOpen(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.getOpenSound(), SoundSource.BLOCKS, 0.5f, SoundUtils.getVariatedPitch(player.level()));
    }

    public void stopOpen(Player player) {
        this.setChanged();
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.getCloseSound(), SoundSource.BLOCKS, 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
    }

    protected SoundEvent getOpenSound() {
        return SoundEvents.SHULKER_BOX_OPEN;
    }

    protected SoundEvent getCloseSound() {
        return SoundEvents.SHULKER_BOX_CLOSE;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean stillValid(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.getItemInHand(hand).equals(this.shulkerBox)) continue;
            return true;
        }
        return false;
    }

    public Component getDisplayName() {
        return this.shulkerBox.getHoverName();
    }

    @Nullable
    public abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3);
}

