/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.item;

import java.util.Comparator;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemUtils {
    public static final Comparator<ItemStack> ITEM_COMPARATOR = (item1, item2) -> {
        int cmp = item2.getItem().hashCode() - item1.getItem().hashCode();
        if (cmp != 0) {
            return cmp;
        }
        cmp = item2.getDamageValue() - item1.getDamageValue();
        if (cmp != 0) {
            return cmp;
        }
        CompoundTag c1 = item1.getTag();
        CompoundTag c2 = item2.getTag();
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.hashCode() - c2.hashCode();
    };

    public static ItemStack itemStackAmount(int amount, ItemStack stack, Player player) {
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (player != null && player.getAbilities().instabuild) {
            return stack;
        }
        stack.setCount(stack.getCount() + amount);
        if (stack.getCount() <= 0) {
            stack.setCount(0);
            return ItemStack.EMPTY;
        }
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(1, stack, player);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() == stack2.getItem()) {
            return stack1.getDamageValue() == stack2.getDamageValue();
        }
        return false;
    }

    public static void saveInventory(CompoundTag compound, String name, Container inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("Slot", i);
            inv.getItem(i).save(slot);
            tagList.add((Object)slot);
        }
        compound.put(name, (Tag)tagList);
    }

    public static void saveInventory(CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < inv.size(); ++i) {
            if (((ItemStack)inv.get(i)).isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putInt("Slot", i);
            ((ItemStack)inv.get(i)).save(slot);
            tagList.add((Object)slot);
        }
        compound.put(name, (Tag)tagList);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        ItemUtils.saveItemList(compound, name, list, true);
    }

    public static void saveItemList(CompoundTag compound, String name, NonNullList<ItemStack> list, boolean includeEmpty) {
        ListTag itemList = new ListTag();
        for (ItemStack stack : list) {
            if (!includeEmpty && stack.isEmpty()) continue;
            itemList.add((Object)stack.save(new CompoundTag()));
        }
        compound.put(name, (Tag)itemList);
    }

    public static void readInventory(CompoundTag compound, String name, Container inv) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag tagList = compound.getList(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.getCompound(i);
            int j = slot.getInt("Slot");
            if (j < 0 || j >= inv.getContainerSize()) continue;
            inv.setItem(j, ItemStack.of((CompoundTag)slot));
        }
    }

    public static void readInventory(CompoundTag compound, String name, NonNullList<ItemStack> inv) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag tagList = compound.getList(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag slot = tagList.getCompound(i);
            int j = slot.getInt("Slot");
            if (j < 0 || j >= inv.size()) continue;
            inv.set(j, (Object)ItemStack.of((CompoundTag)slot));
        }
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.create();
        if (!compound.contains(name)) {
            return items;
        }
        ListTag itemList = compound.getList(name, 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack item = ItemStack.of((CompoundTag)itemList.getCompound(i));
            if (!includeEmpty) {
                if (item.isEmpty()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(CompoundTag compound, String name) {
        return ItemUtils.readItemList(compound, name, true);
    }

    public static void readItemList(CompoundTag compound, String name, NonNullList<ItemStack> list) {
        if (!compound.contains(name)) {
            return;
        }
        ListTag itemList = compound.getList(name, 10);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.of((CompoundTag)itemList.getCompound(i)));
        }
    }

    public static void removeStackFromSlot(Container inventory, int index) {
        inventory.setItem(index, ItemStack.EMPTY);
    }

    public static boolean isStackable(ItemStack stack1, ItemStack stack2) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }

    public static CompoundTag writeOverstackedItem(CompoundTag compound, ItemStack stack) {
        stack.save(compound);
        compound.remove("Count");
        compound.putInt("Count", stack.getCount());
        return compound;
    }

    public static ItemStack readOverstackedItem(CompoundTag compound) {
        CompoundTag data = compound.copy();
        int count = data.getInt("Count");
        data.remove("Count");
        data.putByte("Count", (byte)1);
        ItemStack stack = ItemStack.of((CompoundTag)data);
        stack.setCount(count);
        return stack;
    }
}

