/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.corelib.inventory.ScreenBase;
import de.maxhenkel.easyvillagers.gui.ArrowButton;
import de.maxhenkel.easyvillagers.gui.AutoTraderContainer;
import de.maxhenkel.easyvillagers.net.MessageSelectTrade;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class AutoTraderScreen
extends ScreenBase<AutoTraderContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("easy_villagers", "textures/gui/container/auto_trader.png");
    private final Inventory playerInventory;

    public AutoTraderScreen(AutoTraderContainer container, Inventory playerInventory, Component name) {
        super(BACKGROUND, container, playerInventory, name);
        this.playerInventory = playerInventory;
        this.imageWidth = 176;
        this.imageHeight = 202;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.leftPos + 8, this.topPos + 19, true, button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageSelectTrade(false)})));
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.leftPos + this.imageWidth - 16 - 8, this.topPos + 19, false, button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageSelectTrade(true)})));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (((AutoTraderContainer)this.getMenu()).isLocked()) {
            guiGraphics.blit(BACKGROUND, this.leftPos + 83, this.topPos + 19, 176, 0, 28, 21);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        super.renderLabels(guiGraphics, x, y);
        this.drawCenteredText(guiGraphics, this.title, 6, 0x404040);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.easy_villagers.input"), 45, 0x404040);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.easy_villagers.output"), 77, 0x404040);
        guiGraphics.drawString(this.font, this.playerInventory.getDisplayName().getVisualOrderText(), 8.0f, (float)(this.imageHeight - 96 + 3), 0x404040, false);
    }

    protected void drawCenteredText(GuiGraphics guiGraphics, Component text, int y, int color) {
        int width = this.font.width((FormattedText)text);
        guiGraphics.drawString(this.font, text.getVisualOrderText(), (float)this.imageWidth / 2.0f - (float)width / 2.0f, (float)y, color, false);
    }
}

