/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import de.maxhenkel.easyvillagers.corelib.ClientRegistry;
import de.maxhenkel.easyvillagers.gui.AutoTraderContainer;
import de.maxhenkel.easyvillagers.gui.AutoTraderScreen;
import de.maxhenkel.easyvillagers.gui.BreederContainer;
import de.maxhenkel.easyvillagers.gui.BreederScreen;
import de.maxhenkel.easyvillagers.gui.ConverterContainer;
import de.maxhenkel.easyvillagers.gui.ConverterScreen;
import de.maxhenkel.easyvillagers.gui.IncubatorContainer;
import de.maxhenkel.easyvillagers.gui.IncubatorScreen;
import de.maxhenkel.easyvillagers.gui.InventoryViewerContainer;
import de.maxhenkel.easyvillagers.gui.InventoryViewerScreen;
import de.maxhenkel.easyvillagers.gui.OutputContainer;
import de.maxhenkel.easyvillagers.gui.OutputScreen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Containers {
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"easy_villagers");
    public static final DeferredHolder<MenuType<?>, MenuType<AutoTraderContainer>> AUTO_TRADER_CONTAINER = MENU_TYPE_REGISTER.register("auto_trader", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AutoTraderContainer(windowId, inv)));
    public static final DeferredHolder<MenuType<?>, MenuType<BreederContainer>> BREEDER_CONTAINER = MENU_TYPE_REGISTER.register("breeder", () -> IMenuTypeExtension.create((windowId, inv, data) -> new BreederContainer(windowId, inv)));
    public static final DeferredHolder<MenuType<?>, MenuType<ConverterContainer>> CONVERTER_CONTAINER = MENU_TYPE_REGISTER.register("converter", () -> IMenuTypeExtension.create((windowId, inv, data) -> new ConverterContainer(windowId, inv)));
    public static final DeferredHolder<MenuType<?>, MenuType<IncubatorContainer>> INCUBATOR_CONTAINER = MENU_TYPE_REGISTER.register("incubator", () -> IMenuTypeExtension.create((windowId, inv, data) -> new IncubatorContainer(windowId, inv)));
    public static final DeferredHolder<MenuType<?>, MenuType<OutputContainer>> OUTPUT_CONTAINER = MENU_TYPE_REGISTER.register("output", () -> IMenuTypeExtension.create((windowId, inv, data) -> new OutputContainer(windowId, inv)));
    public static final DeferredHolder<MenuType<?>, MenuType<InventoryViewerContainer>> INVENTORY_VIEWER_CONTAINER = MENU_TYPE_REGISTER.register("inventory_viewer", () -> IMenuTypeExtension.create((windowId, inv, data) -> new InventoryViewerContainer(windowId, inv, data.readBlockPos())));

    public static void init(IEventBus eventBus) {
        MENU_TYPE_REGISTER.register(eventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup() {
        ClientRegistry.registerScreen((MenuType)AUTO_TRADER_CONTAINER.get(), AutoTraderScreen::new);
        ClientRegistry.registerScreen((MenuType)BREEDER_CONTAINER.get(), BreederScreen::new);
        ClientRegistry.registerScreen((MenuType)CONVERTER_CONTAINER.get(), ConverterScreen::new);
        ClientRegistry.registerScreen((MenuType)INCUBATOR_CONTAINER.get(), IncubatorScreen::new);
        ClientRegistry.registerScreen((MenuType)OUTPUT_CONTAINER.get(), OutputScreen::new);
        ClientRegistry.registerScreen((MenuType)INVENTORY_VIEWER_CONTAINER.get(), InventoryViewerScreen::new);
    }
}

