/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.corelib.CachedMap;
import de.maxhenkel.easyvillagers.corelib.client.CustomRendererItem;
import de.maxhenkel.easyvillagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.render.VillagerItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VillagerItem
extends CustomRendererItem {
    private final CachedMap<ItemStack, EasyVillagerEntity> cachedVillagers = new CachedMap(10000L, ItemUtils.ITEM_COMPARATOR);

    public VillagerItem() {
        super(new Item.Properties().stacksTo(1));
        DispenserBlock.registerBehavior((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockpos = source.pos().relative(direction);
            ServerLevel world = source.level();
            EasyVillagerEntity villager = this.getVillager((Level)world, stack);
            villager.absMoveTo((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, direction.toYRot(), 0.0f);
            world.addFreshEntity((Entity)villager);
            stack.shrink(1);
            return stack;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemRenderer createItemRenderer() {
        return new VillagerItemRenderer();
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = world.getBlockState(blockpos);
        if (!blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty()) {
            blockpos = blockpos.relative(direction);
        }
        Villager villager = VillagerItem.convertToVillager(this.getVillager(world, itemstack));
        villager.setPos((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5);
        if (world.addFreshEntity((Entity)villager)) {
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return super.getName(stack);
        }
        EasyVillagerEntity villager = this.getVillagerFast((Level)world, stack);
        if (!villager.hasCustomName() && villager.isBaby()) {
            return Component.translatable((String)"item.easy_villagers.baby_villager");
        }
        return villager.getDisplayName();
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player) || world.isClientSide) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.villagerInventorySounds.get()).booleanValue()) {
            return;
        }
        VillagerBlockBase.playRandomVillagerSound((Player)entity, SoundEvents.VILLAGER_AMBIENT);
    }

    public void setVillager(ItemStack stack, Villager villager) {
        CompoundTag compound = new CompoundTag();
        villager.addAdditionalSaveData(compound);
        if (villager.hasCustomName()) {
            stack.setHoverName(villager.getCustomName());
        }
        stack.getOrCreateTag().put("villager", (Tag)compound);
    }

    public EasyVillagerEntity getVillager(Level world, ItemStack stack) {
        CompoundTag compound = stack.getTagElement("villager");
        if (compound == null) {
            compound = new CompoundTag();
        }
        EasyVillagerEntity villager = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.VILLAGER, world);
        villager.readAdditionalSaveData(compound);
        if (stack.hasCustomHoverName()) {
            villager.setCustomName(stack.getHoverName());
        }
        villager.hurtTime = 0;
        villager.yHeadRot = 0.0f;
        villager.yHeadRotO = 0.0f;
        return villager;
    }

    public static Villager convertToVillager(EasyVillagerEntity easyVillager) {
        Villager villager = new Villager(EntityType.VILLAGER, easyVillager.level());
        CompoundTag data = easyVillager.serializeNBT();
        villager.deserializeNBT(data);
        return villager;
    }

    public EasyVillagerEntity getVillagerFast(Level world, ItemStack stack) {
        return this.cachedVillagers.get(stack, () -> this.getVillager(world, stack));
    }

    public static ItemStack getBabyVillager() {
        ItemStack babyVillager = new ItemStack((ItemLike)ModItems.VILLAGER.get());
        CompoundTag compound = babyVillager.getOrCreateTagElement("villager");
        compound.putInt("Age", -24000);
        return babyVillager;
    }
}

