/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.net;

import de.maxhenkel.easyvillagers.corelib.net.Message;
import de.maxhenkel.easyvillagers.events.VillagerEvents;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessagePickUpVillager
implements Message<MessagePickUpVillager> {
    public static ResourceLocation ID = new ResourceLocation("easy_villagers", "pick_up_villager");
    private UUID villager;

    public MessagePickUpVillager(UUID villager) {
        this.villager = villager;
    }

    public MessagePickUpVillager() {
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(PlayPayloadContext context) {
        Object var3_2 = context.player().orElse(null);
        if (!(var3_2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = var3_2;
        sender.level().getEntitiesOfClass(Villager.class, sender.getBoundingBox().inflate(8.0), v -> v.getUUID().equals(this.villager)).stream().filter(VillagerEvents::arePickupConditionsMet).findAny().ifPresent(villagerEntity -> VillagerEvents.pickUp(villagerEntity, (Player)sender));
    }

    @Override
    public MessagePickUpVillager fromBytes(FriendlyByteBuf packetBuffer) {
        this.villager = packetBuffer.readUUID();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeUUID(this.villager);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

