/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.net;

import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.corelib.net.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageVillagerParticles
implements Message<MessageVillagerParticles> {
    public static ResourceLocation ID = new ResourceLocation("easy_villagers", "villager_particles");
    private BlockPos pos;

    public MessageVillagerParticles(BlockPos pos) {
        this.pos = pos;
    }

    public MessageVillagerParticles() {
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(PlayPayloadContext context) {
        this.spawnParticles();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (blockEntity = mc.level.getBlockEntity(this.pos)) instanceof BreederTileentity) {
            BreederTileentity breeder = (BreederTileentity)blockEntity;
            breeder.spawnParticles();
        }
    }

    @Override
    public MessageVillagerParticles fromBytes(FriendlyByteBuf packetBuffer) {
        this.pos = packetBuffer.readBlockPos();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBlockPos(this.pos);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

