/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_enchanting.ApothEnchConfig;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.client.DrawsOnLeft;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryScreen;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentScreen;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.EnchantmentTableParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod.EventBusSubscriber(modid="apothic_enchanting", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ApothEnchClient {
    private static final BlockHitResult MISS = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.NORTH, (BlockPos)BlockPos.ZERO);

    @SubscribeEvent
    public static void client(FMLClientSetupEvent e) {
        NeoForge.EVENT_BUS.register((Object)new ForgeBusEvents());
    }

    @SubscribeEvent
    public static void screens(RegisterMenuScreensEvent e) {
        e.register(Ench.Menus.ENCHANTING_TABLE.get(), ApothEnchantmentScreen::new);
        e.register(Ench.Menus.LIBRARY.get(), EnchLibraryScreen::new);
    }

    @SubscribeEvent
    public static void particleFactories(RegisterParticleProvidersEvent e) {
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_FIRE.get(), EnchantmentTableParticle.Provider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_WATER.get(), EnchantmentTableParticle.Provider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_SCULK.get(), EnchantmentTableParticle.Provider::new);
        e.registerSpriteSet((ParticleType)Ench.Particles.ENCHANT_END.get(), EnchantmentTableParticle.Provider::new);
    }

    public static class ForgeBusEvents {
        @SubscribeEvent
        public void tooltips(ItemTooltipEvent e) {
            ItemStack stack;
            Map enchMap;
            Item i = e.getItemStack().getItem();
            List tooltip = e.getToolTip();
            if (i == Items.COBWEB) {
                tooltip.add(TooltipUtil.lang("info", "cobweb", new Object[0]).withStyle(ChatFormatting.GRAY));
            } else if (i == Ench.Items.PRISMATIC_WEB.get()) {
                tooltip.add(TooltipUtil.lang("info", "prismatic_cobweb", new Object[0]).withStyle(ChatFormatting.GRAY));
            } else if (i instanceof BlockItem) {
                Block block = ((BlockItem)i).getBlock();
                ClientLevel world = Minecraft.getInstance().level;
                if (world == null || Minecraft.getInstance().player == null) {
                    return;
                }
                BlockPlaceContext ctx = new BlockPlaceContext((Level)world, (Player)Minecraft.getInstance().player, InteractionHand.MAIN_HAND, e.getItemStack(), MISS);
                BlockState state = null;
                try {
                    state = block.getStateForPlacement(ctx);
                }
                catch (Exception ex) {
                    StackTraceElement[] trace;
                    ApothicEnchanting.LOGGER.trace(ex.getMessage());
                    for (StackTraceElement traceElement : trace = ex.getStackTrace()) {
                        ApothicEnchanting.LOGGER.trace("\tat " + traceElement);
                    }
                }
                if (state == null) {
                    state = block.defaultBlockState();
                }
                TooltipUtil.appendBlockStats((Level)world, state, BlockPos.ZERO, tooltip::add);
            } else if (i == Items.ENCHANTED_BOOK && (enchMap = EnchantmentHelper.getEnchantments((ItemStack)(stack = e.getItemStack()))).size() == 1) {
                Enchantment ench = (Enchantment)enchMap.keySet().iterator().next();
                int lvl = (Integer)enchMap.values().iterator().next();
                if (!ModList.get().isLoaded("enchdesc") && "apothic_enchanting".equals(BuiltInRegistries.ENCHANTMENT.getKey((Object)ench).getNamespace())) {
                    tooltip.add(Component.translatable((String)(ench.getDescriptionId() + ".desc")).withStyle(ChatFormatting.DARK_GRAY));
                }
                if (ApothEnchConfig.showEnchantedBookMetadata) {
                    EnchantmentInfo info = ApothicEnchanting.getEnchInfo(ench);
                    Object[] args = new Object[]{ForgeBusEvents.boolComp("discoverable", info.isDiscoverable()), ForgeBusEvents.boolComp("lootable", info.isLootable()), ForgeBusEvents.boolComp("tradeable", info.isTradeable()), ForgeBusEvents.boolComp("treasure", info.isTreasure())};
                    if (e.getFlags().isAdvanced()) {
                        tooltip.add(Component.translatable((String)"%s \u2507 %s \u2507 %s \u2507 %s", (Object[])new Object[]{args[0], args[1], args[2], args[3]}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(TooltipUtil.lang("info", "book_range", info.getMinPower(lvl), info.getMaxPower(lvl)).withStyle(ChatFormatting.GREEN));
                    }
                }
            }
        }

        @SubscribeEvent
        public void drawAnvilCostBlob(ScreenEvent.Render.Post e) {
            Screen screen = e.getScreen();
            if (screen instanceof AnvilScreen) {
                AnvilScreen anv = (AnvilScreen)screen;
                int level = ((AnvilMenu)anv.getMenu()).getCost();
                if (level <= 0 || !((AnvilMenu)anv.getMenu()).getSlot(((AnvilMenu)anv.getMenu()).getResultSlot()).hasItem()) {
                    return;
                }
                ArrayList<Component> list = new ArrayList<Component>();
                list.add((Component)TooltipUtil.lang("info", "anvil_at", level).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}));
                int expCost = EnchantmentUtils.getTotalExperienceForLevel((int)level);
                list.add((Component)TooltipUtil.lang("info", "anvil_xp_cost", Component.literal((String)("" + expCost)).withStyle(ChatFormatting.GREEN), Component.literal((String)("" + level)).withStyle(ChatFormatting.GREEN)));
                DrawsOnLeft.draw(anv, e.getGuiGraphics(), list, anv.getGuiTop() + 28);
            }
        }

        private static Component boolComp(String key, boolean flag) {
            return TooltipUtil.lang("info", key + (flag ? "" : ".not"), new Object[0]).withStyle(Style.EMPTY.withColor(flag ? 0x108810 : 0xAA1616));
        }
    }
}

