/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.objects.ExtractionTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.ImprovedScrappingTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.ScrappingTomeItem;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import net.neoforged.neoforge.event.entity.living.LootingLevelEvent;
import net.neoforged.neoforge.event.entity.living.ShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ApothEnchEvents {
    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        if (e.getLeft().isEnchanted()) {
            if (e.getRight().getItem() == Items.COBWEB) {
                ItemStack stack = e.getLeft().copy();
                EnchantmentHelper.setEnchantments(EnchantmentHelper.getEnchantments((ItemStack)stack).entrySet().stream().filter(ent -> ((Enchantment)ent.getKey()).isCurse()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (ItemStack)stack);
                e.setCost(1);
                e.setMaterialCost(1);
                e.setOutput(stack);
            } else if (e.getRight().getItem() == Ench.Items.PRISMATIC_WEB.get()) {
                ItemStack stack = e.getLeft().copy();
                EnchantmentHelper.setEnchantments(EnchantmentHelper.getEnchantments((ItemStack)stack).entrySet().stream().filter(ent -> !((Enchantment)ent.getKey()).isCurse()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (ItemStack)stack);
                e.setCost(30);
                e.setMaterialCost(1);
                e.setOutput(stack);
                return;
            }
        }
        if ((e.getLeft().getItem() == Items.CHIPPED_ANVIL || e.getLeft().getItem() == Items.DAMAGED_ANVIL) && e.getRight().is(Tags.Items.STORAGE_BLOCKS_IRON)) {
            if (e.getLeft().getCount() != 1) {
                return;
            }
            int dmg = e.getLeft().getItem() == Items.DAMAGED_ANVIL ? 2 : 1;
            ItemStack out = new ItemStack((ItemLike)(dmg == 1 ? Items.ANVIL : Items.CHIPPED_ANVIL));
            EnchantmentHelper.setEnchantments((Map)EnchantmentHelper.getEnchantments((ItemStack)e.getLeft()), (ItemStack)out);
            out.setCount(1);
            e.setOutput(out);
            e.setCost(5 + e.getLeft().getAllEnchantments().entrySet().stream().mapToInt(ent -> (Integer)ent.getValue() * (((Enchantment)ent.getKey()).getRarity().ordinal() + 1)).sum());
            e.setMaterialCost(1);
            return;
        }
        if (ScrappingTomeItem.updateAnvil(e)) {
            return;
        }
        if (ImprovedScrappingTomeItem.updateAnvil(e)) {
            return;
        }
        if (ExtractionTomeItem.updateAnvil(e)) {
            return;
        }
    }

    @SubscribeEvent
    public void repairEvent(AnvilRepairEvent e) {
        if (ExtractionTomeItem.updateRepair(e)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Throwable {
        Entity entity = e.getSource().getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            Ench.Enchantments.SCAVENGER.get().drops(p, e);
            Ench.Enchantments.SPEARFISHING.get().addFishes(e);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        Entity entity = e.getSource().getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            Ench.Enchantments.KNOWLEDGE.get().drops(p, e);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void healing(LivingHealEvent e) {
        if (e.getEntity().getType() == EntityType.ARMOR_STAND) {
            return;
        }
        Ench.Enchantments.LIFE_MENDING.get().lifeMend(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void block(ShieldBlockEvent e) {
        Ench.Enchantments.REFLECTIVE.get().reflect(e);
    }

    @SubscribeEvent
    public void looting(LootingLevelEvent e) {
        Entity entity;
        DamageSource src = e.getDamageSource();
        if (src != null && (entity = src.getDirectEntity()) instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            ItemStack triStack = trident.getPickupItemStackOrigin();
            e.setLootingLevel(triStack.getEnchantmentLevel(Enchantments.MOB_LOOTING));
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        Ench.Enchantments.STABLE_FOOTING.get().breakSpeed(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void breakSpeedLow(PlayerEvent.BreakSpeed e) {
        Ench.Enchantments.MINERS_FERVOR.get().breakSpeed(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void breakSpeed(BlockEvent.BreakEvent e) {
        Ench.Enchantments.EARTHS_BOON.get().provideBenefits(e);
        Ench.Enchantments.CHAINSAW.get().chainsaw(e);
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        Ench.Enchantments.NATURES_BLESSING.get().rightClick(e);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void livingHurt(LivingHurtEvent e) {
        Ench.Enchantments.BERSERKERS_FURY.get().livingHurt(e);
    }
}

