/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_enchanting.ApothEnchConfig;
import dev.shadowsoffire.apothic_enchanting.ApothEnchEvents;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.asm.EnchHooks;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.apothic_enchanting.objects.TomeItem;
import dev.shadowsoffire.apothic_enchanting.payloads.CluePayload;
import dev.shadowsoffire.apothic_enchanting.payloads.StatsPayload;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentTableBlock;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.apothic_enchanting.util.MiscDatagen;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.events.ResourceReloadEvent;
import dev.shadowsoffire.placebo.loot.LootSystem;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="apothic_enchanting")
public class ApothicEnchanting {
    public static final String MODID = "apothic_enchanting";
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Object2IntMap<Enchantment> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final String ENCH_HARD_CAP_IMC = "set_ench_hard_cap";
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();
    public static final EquipmentSlot[] ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EnchantmentCategory HOE = EnchantmentCategory.create((String)"HOE", HoeItem.class::isInstance);
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"SHIELD", ShieldItem.class::isInstance);
    public static final EnchantmentCategory ANVIL = EnchantmentCategory.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).getBlock() instanceof AnvilBlock);
    public static final EnchantmentCategory SHEARS = EnchantmentCategory.create((String)"SHEARS", ShearsItem.class::isInstance);
    public static final EnchantmentCategory PICKAXE = EnchantmentCategory.create((String)"PICKAXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.PICKAXE_DIG));
    public static final EnchantmentCategory AXE = EnchantmentCategory.create((String)"AXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.AXE_DIG));
    public static final EnchantmentCategory CORE_ARMOR = EnchantmentCategory.create((String)"CORE_ARMOR", i -> EnchantmentCategory.ARMOR_CHEST.canEnchant(i) || EnchantmentCategory.ARMOR_LEGS.canEnchant(i));
    static Configuration enchInfoConfig;

    public ApothicEnchanting(IEventBus bus) {
        Ench.bootstrap(bus);
        bus.register((Object)this);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        NeoForge.EVENT_BUS.register((Object)new ApothEnchEvents());
        NeoForge.EVENT_BUS.addListener(this::reload);
        e.enqueueWork(() -> {
            LootSystem.defaultBlockTable((Block)Ench.Blocks.HELLSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.INFUSED_HELLSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.BLAZING_HELLSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.GLOWING_HELLSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.SEASHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.INFUSED_SEASHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.CRYSTAL_SEASHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.HEART_SEASHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.DORMANT_DEEPSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.DEEPSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.ECHOING_DEEPSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.SOUL_TOUCHED_DEEPSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.ECHOING_SCULKSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.SOUL_TOUCHED_SCULKSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.ENDSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.PEARL_ENDSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.DRACONIC_ENDSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.BEESHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.MELONSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.STONESHELF.get());
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.LIBRARY.get()));
            LootSystem.defaultBlockTable((Block)Ench.Blocks.GEODE_SHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.SIGHTSHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.SIGHTSHELF_T2.get());
            LootSystem.defaultBlockTable((Block)((Block)Ench.Blocks.ENDER_LIBRARY.get()));
            LootSystem.defaultBlockTable((Block)Ench.Blocks.FILTERING_SHELF.get());
            LootSystem.defaultBlockTable((Block)Ench.Blocks.TREASURE_SHELF.get());
            DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new ShearsDispenseItemBehavior());
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.HELLSHELF, Ench.Items.INFUSED_HELLSHELF, Ench.Items.BLAZING_HELLSHELF, Ench.Items.GLOWING_HELLSHELF, Ench.Items.SEASHELF, Ench.Items.INFUSED_SEASHELF, Ench.Items.CRYSTAL_SEASHELF, Ench.Items.HEART_SEASHELF, Ench.Items.DORMANT_DEEPSHELF, Ench.Items.DEEPSHELF, Ench.Items.ECHOING_DEEPSHELF, Ench.Items.SOUL_TOUCHED_DEEPSHELF, Ench.Items.ECHOING_SCULKSHELF, Ench.Items.SOUL_TOUCHED_SCULKSHELF, Ench.Items.ENDSHELF, Ench.Items.PEARL_ENDSHELF, Ench.Items.DRACONIC_ENDSHELF, Ench.Items.BEESHELF, Ench.Items.MELONSHELF, Ench.Items.STONESHELF, Ench.Items.SIGHTSHELF, Ench.Items.SIGHTSHELF_T2, Ench.Items.FILTERING_SHELF, Ench.Items.TREASURE_SHELF, Ench.Items.GEODE_SHELF, Ench.Items.LIBRARY, Ench.Items.ENDER_LIBRARY});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.HELMET_TOME, Ench.Items.CHESTPLATE_TOME, Ench.Items.LEGGINGS_TOME, Ench.Items.BOOTS_TOME, Ench.Items.WEAPON_TOME, Ench.Items.BOW_TOME, Ench.Items.PICKAXE_TOME, Ench.Items.FISHING_TOME, Ench.Items.OTHER_TOME, Ench.Items.SCRAP_TOME, Ench.Items.IMPROVED_SCRAP_TOME, Ench.Items.EXTRACTION_TOME});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Supplier[])new Supplier[]{Ench.Items.PRISMATIC_WEB, Ench.Items.INERT_TRIDENT, Ench.Items.WARDEN_TENDRIL, Ench.Items.INFUSED_BREATH});
            ApothicEnchanting.fill((ResourceKey<CreativeModeTab>)Ench.Tabs.ENCH.getKey(), Ench.Enchantments.BERSERKERS_FURY, Ench.Enchantments.CHAINSAW, Ench.Enchantments.CHROMATIC, Ench.Enchantments.CRESCENDO, Ench.Enchantments.EARTHS_BOON, Ench.Enchantments.ENDLESS_QUIVER, Ench.Enchantments.EXPLOITATION, Ench.Enchantments.GROWTH_SERUM, Ench.Enchantments.ICY_THORNS, Ench.Enchantments.KNOWLEDGE, Ench.Enchantments.LIFE_MENDING, Ench.Enchantments.MINERS_FERVOR, Ench.Enchantments.NATURES_BLESSING, Ench.Enchantments.REBOUNDING, Ench.Enchantments.REFLECTIVE, Ench.Enchantments.SCAVENGER, Ench.Enchantments.SHIELD_BASH, Ench.Enchantments.SPEARFISHING, Ench.Enchantments.STABLE_FOOTING, Ench.Enchantments.TEMPTING);
            PlaceboUtil.registerCustomColor((TextColor)Ench.Colors.LIGHT_BLUE_FLASH);
        });
        EnchantingStatRegistry.INSTANCE.registerToBus();
        PayloadHelper.registerPayload((PayloadProvider)new CluePayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new StatsPayload.Provider());
    }

    @SubscribeEvent
    public void handleIMC(InterModProcessEvent e) {
        e.getIMCStream(ENCH_HARD_CAP_IMC::equals).forEach(msg -> {
            try {
                EnchantmentInstance data = (EnchantmentInstance)msg.messageSupplier().get();
                if (data != null && data.enchantment != null && data.level > 0) {
                    ENCH_HARD_CAPS.put((Object)data.enchantment, data.level);
                } else {
                    LOGGER.error("Failed to process IMC message with method {} from {} (invalid values passed).", (Object)msg.method(), (Object)msg.senderModId());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception thrown during IMC message with method {} from {}.", (Object)msg.method(), (Object)msg.senderModId());
                ex.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void caps(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Ench.Tiles.LIBRARY.get(), EnchLibraryTile::getItemHandler);
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Ench.Tiles.ENDER_LIBRARY.get(), EnchLibraryTile::getItemHandler);
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityType.ENCHANTING_TABLE, ApothEnchantmentTableBlock::getItemHandler);
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        MiscDatagen gen = new MiscDatagen(e.getGenerator().getPackOutput().getOutputFolder(PackOutput.Target.DATA_PACK).resolve(MODID));
        e.getGenerator().addProvider(true, (DataProvider)gen);
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            return new EnchantmentInfo(ench);
        }
        if (info == null) {
            info = EnchantmentInfo.load(ench, enchInfoConfig);
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)BuiltInRegistries.ENCHANTMENT.getKey((Object)ench), (Object)BuiltInRegistries.ENCHANTMENT.getKey((Object)ench).getNamespace());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.getMaxLevel();
        if (level == 1) {
            return 1;
        }
        EnchantmentInfo.PowerFunc minFunc = EnchantmentInfo.defaultMin(ench);
        int max = 200;
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    @SafeVarargs
    public static void fill(ResourceKey<CreativeModeTab> tab, Supplier<? extends Enchantment> ... enchants) {
        Arrays.stream(enchants).map(ApothicEnchanting::enchFiller).forEach(filler -> TabFillingRegistry.register((ITabFiller)filler, (ResourceKey[])new ResourceKey[]{tab}));
    }

    public static ITabFiller enchFiller(Supplier<? extends Enchantment> e) {
        return (tab, output) -> {
            Enchantment ench = (Enchantment)e.get();
            int maxLevel = EnchHooks.getMaxLevel(ench);
            output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(ench, maxLevel)), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            for (int level = 1; level <= maxLevel; ++level) {
                output.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(ench, level)), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
        };
    }

    public void reload(ResourceReloadEvent e) {
        enchInfoConfig = new Configuration(ApothicAttributes.getConfigFile((String)"enchantments"));
        enchInfoConfig.setTitle("Apotheosis Enchantment Information");
        enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
        ENCHANTMENT_INFO.clear();
        for (Enchantment ench : BuiltInRegistries.ENCHANTMENT) {
            ENCHANTMENT_INFO.put(ench, EnchantmentInfo.load(ench, enchInfoConfig));
        }
        for (Enchantment ench : BuiltInRegistries.ENCHANTMENT) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable except by combination.", (Object)BuiltInRegistries.ENCHANTMENT.getKey((Object)ench), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        if (e == null && enchInfoConfig.hasChanged()) {
            enchInfoConfig.save();
        }
        ApothEnchConfig.load(new Configuration(ApothicAttributes.getConfigFile((String)MODID)));
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }
}

