/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.api;

import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public interface EnchantableItem {
    default public ItemStack applyEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        boolean isBook = stack.is(Items.BOOK);
        if (isBook) {
            ItemStack enchBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            CompoundTag tag = stack.getTag();
            if (tag != null) {
                stack.setTag(tag.copy());
            }
            stack = enchBook;
        }
        for (EnchantmentInstance inst : enchantments) {
            if (isBook) {
                EnchantedBookItem.addEnchantment((ItemStack)stack, (EnchantmentInstance)inst);
                continue;
            }
            stack.enchant(inst.enchantment, inst.level);
        }
        return stack;
    }

    default public List<EnchantmentInstance> selectEnchantments(List<EnchantmentInstance> builtList, RandomSource rand, ItemStack stack, int level, EnchantmentTableStats stats) {
        return builtList;
    }

    default public boolean forciblyAllowsTableEnchantment(ItemStack stack, Enchantment enchantment) {
        return stack.is(Items.BOOK) && enchantment.isAllowedOnBooks();
    }

    default public boolean isTreasureAllowed(ItemStack stack, boolean wasTreasureAllowed) {
        return wasTreasureAllowed;
    }
}

